/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.join.FixedBitSetCachingWrapperFilter;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SyntaxError;

class BlockJoinParentQParser
extends QParser {
    public String CACHE_NAME = "perSegFilter";

    protected String getParentFilterLocalParamName() {
        return "which";
    }

    BlockJoinParentQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        String filter = this.localParams.get(this.getParentFilterLocalParamName());
        QParser parentParser = this.subQuery(filter, null);
        Query parentQ = parentParser.getQuery();
        String queryText = this.localParams.get("v");
        if (queryText == null || queryText.length() == 0) {
            SolrConstantScoreQuery wrapped = new SolrConstantScoreQuery(this.getFilter(parentQ));
            wrapped.setCache(false);
            return wrapped;
        }
        QParser childrenParser = this.subQuery(queryText, null);
        Query childrenQuery = childrenParser.getQuery();
        return this.createQuery(parentQ, childrenQuery);
    }

    protected Query createQuery(Query parentList, Query query) {
        return new ToParentBlockJoinQuery(query, this.getFilter(parentList), ScoreMode.None);
    }

    protected Filter getFilter(Query parentList) {
        Filter result;
        SolrCache parentCache = this.req.getSearcher().getCache(this.CACHE_NAME);
        Filter filter = null;
        if (parentCache != null) {
            filter = (Filter)parentCache.get(parentList);
        }
        if (filter == null) {
            result = this.createParentFilter(parentList);
            if (parentCache != null) {
                parentCache.put(parentList, result);
            }
        } else {
            result = filter;
        }
        return result;
    }

    protected Filter createParentFilter(Query parentQ) {
        return new FixedBitSetCachingWrapperFilter((Filter)new QueryWrapperFilter(parentQ));
    }
}

