/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.twowaysql;

import org.codelibs.robot.dbflute.exception.CommentTerminatorNotFoundException;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;

public class SqlTokenizer {
    public static final int SQL = 1;
    public static final int COMMENT = 2;
    public static final int ELSE = 3;
    public static final int BIND_VARIABLE = 4;
    public static final int EOF = 99;
    protected final String _sql;
    protected int _position = 0;
    protected String _token;
    protected int _tokenType = 1;
    protected int _nextTokenType = 1;
    protected int _bindVariableNum = 0;

    public SqlTokenizer(String sql) {
        this._sql = sql;
    }

    public int next() {
        if (this._position >= this._sql.length()) {
            this._token = null;
            this._tokenType = 99;
            this._nextTokenType = 99;
            return this._tokenType;
        }
        switch (this._nextTokenType) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
                break;
            }
            default: {
                this.parseEof();
            }
        }
        return this._tokenType;
    }

    protected void parseSql() {
        int nextStartPos;
        int lineCommentStartPos;
        int commentStartPos = this._sql.indexOf("/*", this._position);
        int commentStartPos2 = this._sql.indexOf("#*", this._position);
        if (0 < commentStartPos2 && commentStartPos2 < commentStartPos) {
            commentStartPos = commentStartPos2;
        }
        int bindVariableStartPos = this._sql.indexOf("?", this._position);
        int elseCommentStartPos = -1;
        int elseCommentLength = -1;
        int elseCommentSearchCurrentPosition = this._position;
        while ((lineCommentStartPos = this._sql.indexOf("--", elseCommentSearchCurrentPosition)) >= 0 && this.calculateNextStartPos(commentStartPos, bindVariableStartPos, -1) >= lineCommentStartPos) {
            int skipPos = this.skipWhitespace(lineCommentStartPos + 2);
            if (skipPos + 4 < this._sql.length() && "ELSE".equals(this._sql.substring(skipPos, skipPos + 4))) {
                elseCommentStartPos = lineCommentStartPos;
                elseCommentLength = skipPos + 4 - lineCommentStartPos;
                break;
            }
            elseCommentSearchCurrentPosition = skipPos;
        }
        if ((nextStartPos = this.calculateNextStartPos(commentStartPos, bindVariableStartPos, elseCommentStartPos)) < 0) {
            this._token = this._sql.substring(this._position);
            this._nextTokenType = 99;
            this._position = this._sql.length();
            this._tokenType = 1;
        } else {
            boolean needNext;
            this._token = this._sql.substring(this._position, nextStartPos);
            this._tokenType = 1;
            boolean bl = needNext = nextStartPos == this._position;
            if (nextStartPos == commentStartPos) {
                this._nextTokenType = 2;
                this._position = commentStartPos + 2;
            } else if (nextStartPos == elseCommentStartPos) {
                this._nextTokenType = 3;
                this._position = elseCommentStartPos + elseCommentLength;
            } else if (nextStartPos == bindVariableStartPos) {
                this._nextTokenType = 4;
                this._position = bindVariableStartPos;
            }
            if (needNext) {
                this.next();
            }
        }
    }

    protected int calculateNextStartPos(int commentStartPos, int bindVariableStartPos, int elseCommentStartPos) {
        int nextStartPos = -1;
        if (commentStartPos >= 0) {
            nextStartPos = commentStartPos;
        }
        if (bindVariableStartPos >= 0 && (nextStartPos < 0 || bindVariableStartPos < nextStartPos)) {
            nextStartPos = bindVariableStartPos;
        }
        if (elseCommentStartPos >= 0 && (nextStartPos < 0 || elseCommentStartPos < nextStartPos)) {
            nextStartPos = elseCommentStartPos;
        }
        return nextStartPos;
    }

    protected String nextBindVariableName() {
        return "$" + ++this._bindVariableNum;
    }

    protected void parseComment() {
        int commentEndPos = this._sql.indexOf("*/", this._position);
        int commentEndPos2 = this._sql.indexOf("*#", this._position);
        if (0 < commentEndPos2 && commentEndPos2 < commentEndPos) {
            commentEndPos = commentEndPos2;
        }
        if (commentEndPos < 0) {
            this.throwCommentTerminatorNotFoundException(this._sql.substring(this._position));
        }
        this._token = this._sql.substring(this._position, commentEndPos);
        this._nextTokenType = 1;
        this._position = commentEndPos + 2;
        this._tokenType = 2;
    }

    protected void throwCommentTerminatorNotFoundException(String expression) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The comment end was NOT found!");
        br.addItem("Advice");
        br.addElement("Please confirm the SQL comment writing.");
        br.addElement("Any comments DOESN'T have a comment end.");
        br.addElement("For example:");
        br.addElement("  (x) -- /*pmb.xxxId3");
        br.addElement("  (o) -- /*pmb.xxxId*/3");
        br.addItem("Specified SQL");
        br.addElement(expression);
        br.addItem("Comment Expression");
        br.addElement(this._sql);
        String msg = br.buildExceptionMessage();
        throw new CommentTerminatorNotFoundException(msg);
    }

    protected void parseBindVariable() {
        this._token = this.nextBindVariableName();
        this._nextTokenType = 1;
        ++this._position;
        this._tokenType = 4;
    }

    protected void parseElse() {
        this._token = null;
        this._nextTokenType = 1;
        this._tokenType = 3;
    }

    protected void parseEof() {
        this._token = null;
        this._tokenType = 99;
        this._nextTokenType = 99;
    }

    public String skipToken() {
        return this.skipToken(false);
    }

    public String skipToken(boolean testValue) {
        int i;
        int index = this._sql.length();
        String dateLiteralPrefix = this.extractDateLiteralPrefix(testValue, this._sql, this._position);
        if (dateLiteralPrefix != null) {
            this._position += dateLiteralPrefix.length();
        }
        char firstChar = this._position < this._sql.length() ? this._sql.charAt(this._position) : (char)'\u0000';
        char quote = firstChar == '(' ? (char)')' : (char)firstChar;
        boolean quoting = quote == '\'' || quote == ')';
        int n = i = quoting ? this._position + 1 : this._position;
        while (i < this._sql.length()) {
            char c = this._sql.charAt(i);
            if (this.isNotQuoteEndPoint(quoting, c)) {
                index = i;
                break;
            }
            if (this.isBlockCommentBeginPoint(this._sql, c, i)) {
                index = i;
                break;
            }
            if (this.isLineCommentBeginPoint(this._sql, c, i)) {
                index = i;
                break;
            }
            if (quoting && this.isSingleQuoteEndPoint(this._sql, quote, c, i)) {
                index = i + 1;
                break;
            }
            if (quoting && this.isQuoteEndPoint(this._sql, quote, c, i)) {
                index = i + 1;
                break;
            }
            ++i;
        }
        this._token = this._sql.substring(this._position, index);
        if (dateLiteralPrefix != null) {
            this._token = dateLiteralPrefix + this._token;
        }
        this._tokenType = 1;
        this._nextTokenType = 1;
        this._position = index;
        return this._token;
    }

    protected String extractDateLiteralPrefix(boolean testValue, String currentSql, int position) {
        if (!testValue) {
            return null;
        }
        if (position >= currentSql.length()) {
            return null;
        }
        char firstChar = currentSql.charAt(position);
        if (firstChar != 'd' && firstChar != 'D' && firstChar != 't' && firstChar != 'T') {
            return null;
        }
        String tmpRear = currentSql.substring(position);
        int maxlength = "timestamp '".length();
        String rear = tmpRear.length() > maxlength ? tmpRear.substring(0, maxlength) : tmpRear;
        String lowerRear = rear.toLowerCase();
        String literalPrefix = null;
        if (lowerRear.startsWith("date '")) {
            literalPrefix = rear.substring(0, "date ".length());
        } else if (lowerRear.startsWith("date'")) {
            literalPrefix = rear.substring(0, "date".length());
        } else if (lowerRear.startsWith("timestamp '")) {
            literalPrefix = rear.substring(0, "timestamp ".length());
        } else if (lowerRear.startsWith("timestamp'")) {
            literalPrefix = rear.substring(0, "timestamp".length());
        }
        return literalPrefix;
    }

    protected boolean isNotQuoteEndPoint(boolean quoting, char c) {
        return !quoting && (Character.isWhitespace(c) || c == ',' || c == ')' || c == '(');
    }

    protected boolean isBlockCommentBeginPoint(String currentSql, char c, int i) {
        return c == '/' && this.isNextCharacter(currentSql, i, '*');
    }

    protected boolean isLineCommentBeginPoint(String currentSql, char c, int i) {
        return c == '-' && this.isNextCharacter(currentSql, i, '-');
    }

    protected boolean isSingleQuoteEndPoint(String currentSql, char quote, char c, int i) {
        int sqlLen = currentSql.length();
        boolean endSqlOrNotEscapeQuote = i + 1 >= sqlLen || currentSql.charAt(i + 1) != '\'';
        return quote == '\'' && c == '\'' && endSqlOrNotEscapeQuote;
    }

    protected boolean isQuoteEndPoint(String currentSql, char quote, char c, int i) {
        return c == quote;
    }

    protected boolean isNextCharacter(String currentSql, int i, char targetChar) {
        return i + 1 < currentSql.length() && currentSql.charAt(i + 1) == targetChar;
    }

    public String skipWhitespace() {
        int index = this.skipWhitespace(this._position);
        this._token = this._sql.substring(this._position, index);
        this._position = index;
        return this._token;
    }

    protected int skipWhitespace(int position) {
        int index = this._sql.length();
        for (int i = position; i < this._sql.length(); ++i) {
            char c = this._sql.charAt(i);
            if (Character.isWhitespace(c)) continue;
            index = i;
            break;
        }
        return index;
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public int getPosition() {
        return this._position;
    }

    public String getToken() {
        return this._token;
    }

    public String getBefore() {
        return this._sql.substring(0, this._position);
    }

    public String getAfter() {
        return this._sql.substring(this._position);
    }

    public int getTokenType() {
        return this._tokenType;
    }

    public int getNextTokenType() {
        return this._nextTokenType;
    }
}

