/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.optional;

import org.codelibs.robot.dbflute.optional.OptionalObject;
import org.codelibs.robot.dbflute.optional.OptionalObjectConsumer;
import org.codelibs.robot.dbflute.optional.OptionalObjectExceptionThrower;
import org.codelibs.robot.dbflute.optional.OptionalObjectFunction;
import org.codelibs.robot.dbflute.optional.OptionalObjectPredicate;

public abstract class BaseOptional<OBJ> {
    protected final OBJ _obj;
    protected final OptionalObjectExceptionThrower _thrower;

    public BaseOptional(OBJ obj, OptionalObjectExceptionThrower thrower) {
        this._obj = obj;
        if (thrower == null) {
            String msg = "The argument 'thrower' should not be null: obj=" + obj;
            throw new IllegalArgumentException(msg);
        }
        this._thrower = thrower;
    }

    protected OBJ directlyGet() {
        if (!this.exists()) {
            this._thrower.throwNotFoundException();
        }
        return this._obj;
    }

    protected void callbackIfPresent(OptionalObjectConsumer<OBJ> consumer) {
        if (consumer == null) {
            String msg = "The argument 'consumer' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this.exists()) {
            consumer.accept(this._obj);
        }
    }

    protected boolean exists() {
        return this._obj != null;
    }

    protected BaseOptional<OBJ> callbackFilter(OptionalObjectPredicate<OBJ> mapper) {
        if (mapper == null) {
            String msg = "The argument 'mapper' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this.exists()) {
            if (mapper.test(this._obj)) {
                return this;
            }
            return this.createOptionalFilteredObject(null);
        }
        return this.createOptionalFilteredObject(null);
    }

    protected abstract <ARG> BaseOptional<ARG> createOptionalFilteredObject(ARG var1);

    protected <RESULT> BaseOptional<RESULT> callbackMapping(OptionalObjectFunction<? super OBJ, ? extends RESULT> mapper) {
        if (mapper == null) {
            String msg = "The argument 'mapper' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        Object result = this.exists() ? (Object)mapper.apply((OBJ)this._obj) : null;
        return this.createOptionalMappedObject(result);
    }

    protected abstract <ARG> BaseOptional<ARG> createOptionalMappedObject(ARG var1);

    protected <RESULT> OptionalObject<RESULT> callbackFlatMapping(OptionalObjectFunction<? super OBJ, OptionalObject<RESULT>> mapper) {
        if (mapper == null) {
            String msg = "The argument 'mapper' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.exists() ? mapper.apply(this._obj) : null;
    }

    protected OBJ directlyGetOrElse(OBJ other) {
        return this.exists() ? this._obj : other;
    }

    protected void callbackRequired(OptionalObjectConsumer<OBJ> consumer) {
        if (consumer == null) {
            String msg = "The argument 'consumer' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._obj == null) {
            this._thrower.throwNotFoundException();
        }
        consumer.accept(this._obj);
    }

    public int hashCode() {
        return this._obj != null ? this._obj.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this.getClass().isInstance(obj)) {
            BaseOptional other = (BaseOptional)obj;
            if (this._obj != null) {
                return this._obj.equals(other.directlyGet());
            }
            return !other.exists();
        }
        return false;
    }

    public String toString() {
        return "opt:{" + (this._obj != null ? this._obj.toString() : "null") + "}";
    }
}

