/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.cbean.chelper;

import org.codelibs.robot.dbflute.cbean.ckey.ConditionKey;
import org.codelibs.robot.dbflute.dbmeta.info.ColumnInfo;
import org.codelibs.robot.dbflute.util.DfTypeUtil;
import org.codelibs.robot.dbflute.util.Srl;

public class HpInvalidQueryInfo {
    protected final String _locationBase;
    protected final ColumnInfo _targetColumn;
    protected final ConditionKey _conditionKey;
    protected final Object _invalidValue;
    protected boolean _inlineView;
    protected boolean _onClause;

    public HpInvalidQueryInfo(String locationBase, ColumnInfo targetColumn, ConditionKey conditionKey, Object invalidValue) {
        this.assertObjectNotNull("locationBase", locationBase);
        this.assertObjectNotNull("targetColumn", targetColumn);
        this.assertObjectNotNull("conditionKey", conditionKey);
        this._locationBase = locationBase;
        this._targetColumn = targetColumn;
        this._conditionKey = conditionKey;
        this._invalidValue = invalidValue;
    }

    public HpInvalidQueryInfo inlineView() {
        this._inlineView = true;
        return this;
    }

    public HpInvalidQueryInfo onClause() {
        this._onClause = true;
        return this;
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public String buildDisplay() {
        StringBuilder sb = new StringBuilder();
        String tableDbName = this._targetColumn.getDBMeta().getTableDbName();
        String columnDbName = this._targetColumn.getColumnDbName();
        sb.append(tableDbName).append(".").append(columnDbName);
        sb.append(" ").append(this._conditionKey.getConditionKey());
        sb.append(" {value=").append(this._invalidValue).append("}");
        sb.append(" : ").append(this.buildLocationDisp());
        if (this._inlineView) {
            sb.append("(").append("inlineView").append(")");
        } else if (this._onClause) {
            sb.append("(").append("onClause").append(")");
        }
        return sb.toString();
    }

    protected String buildLocationDisp() {
        String locationExp = Srl.replace(this._locationBase, ".", "().");
        locationExp = Srl.replace(locationExp, "conditionQuery()", "query()");
        locationExp = Srl.replace(locationExp, ".conditionQuery", ".query");
        locationExp = Srl.rtrim(locationExp, ".");
        return locationExp;
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this.buildDisplay() + "}";
    }

    public String getLocationBase() {
        return this._locationBase;
    }

    public ColumnInfo getTargetColumn() {
        return this._targetColumn;
    }

    public ConditionKey getConditionKey() {
        return this._conditionKey;
    }

    public Object getInvalidValue() {
        return this._invalidValue;
    }

    public boolean isInlineView() {
        return this._inlineView;
    }

    public boolean isOnClause() {
        return this._onClause;
    }
}

