/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sastruts.core.action;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.codelibs.core.crypto.CachedCipher;
import org.codelibs.sastruts.core.entity.UserInfo;
import org.codelibs.sastruts.core.exception.LoginException;
import org.codelibs.sastruts.core.form.AbstractLoginForm;
import org.codelibs.sastruts.core.util.ActivityUtil;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.util.ResponseUtil;

public abstract class AbstractLoginAction
implements Serializable {
    private static final Logger logger = Logger.getLogger(AbstractLoginAction.class);
    private static final long serialVersionUID = 1L;
    @Resource
    protected HttpServletRequest request;
    @Resource
    protected CachedCipher authCipher;

    protected String doIndex(AbstractLoginForm form) {
        Object obj;
        HttpSession session = this.request.getSession(false);
        Object object = obj = session == null ? null : session.getAttribute("LoginInfo");
        if (obj instanceof UserInfo) {
            this.redirect(this.getAuthRootPath());
            return null;
        }
        String params = null;
        if ("forbidden".equals(form.type)) {
            if (logger.isInfoEnabled()) {
                logger.log("ISSC0001", new Object[]{this.request.getRemoteUser()});
            }
            if (session != null) {
                session = this.invalidateSession(session);
            }
            params = "msgs=error.login_error";
        }
        if (session == null) {
            session = this.request.getSession();
        }
        if (StringUtil.isNotBlank((String)form.returnPath)) {
            String value = this.authCipher.decryptoText(form.returnPath);
            int idx = value.indexOf(124);
            if (idx >= 0) {
                String path = value.substring(idx + 1);
                session.setAttribute("ReturnPath", (Object)path);
            } else {
                session.removeAttribute("ReturnPath");
            }
        } else {
            session.removeAttribute("ReturnPath");
        }
        return this.getLoginPath(params);
    }

    protected String doLogin(AbstractLoginForm form) {
        HttpSession oldSession = this.request.getSession();
        HttpSession session = this.invalidateSession(oldSession);
        session.removeAttribute("org.apache.struts.action.ACTION_MESSAGE");
        UserInfo loginInfo = new UserInfo();
        loginInfo.setUsername(this.request.getRemoteUser());
        session.setAttribute("LoginInfo", (Object)loginInfo);
        String returnPath = (String)session.getAttribute("ReturnPath");
        if (returnPath != null) {
            session.removeAttribute("ReturnPath");
        } else {
            returnPath = this.getAuthRootPath();
        }
        ActivityUtil.login(loginInfo.getUsername(), this.request);
        this.redirect(returnPath);
        return null;
    }

    private HttpSession invalidateSession(HttpSession oldSession) {
        HashMap<String, Object> sessionObjMap = new HashMap<String, Object>();
        Enumeration e = oldSession.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            sessionObjMap.put(name, oldSession.getAttribute(name));
        }
        oldSession.invalidate();
        HttpSession session = this.request.getSession();
        for (Map.Entry entry : sessionObjMap.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
        return session;
    }

    protected String doLogout(AbstractLoginForm form) {
        ActivityUtil.login(this.request.getRemoteUser(), this.request);
        HttpSession session = this.request.getSession();
        session.invalidate();
        return this.getLoginPath(null);
    }

    protected String getDefaultPath() {
        return "/index?redirect=true";
    }

    protected String getLoginPath(String params) {
        StringBuilder buf = new StringBuilder();
        buf.append("login?");
        if (params != null && params.length() > 0) {
            buf.append(params).append('&');
        }
        buf.append("redirect=true");
        return buf.toString();
    }

    protected String getAuthRootPath() {
        String contextPath = this.request.getContextPath();
        if (StringUtil.isEmpty((String)contextPath) || "/".equals(contextPath)) {
            return "/admin/";
        }
        return contextPath + "/admin/";
    }

    protected void redirect(String returnPath) {
        HttpServletResponse response = ResponseUtil.getResponse();
        try {
            response.sendRedirect(response.encodeURL(returnPath));
        }
        catch (IOException e) {
            throw new LoginException("ESSC0002", new Object[]{returnPath}, e);
        }
    }
}

