/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.logging.Level;
import org.restlet.Context;

public final class Tag {
    public static final Tag ALL = Tag.parse("*");
    private volatile String name;
    private final boolean weak;

    public static Tag parse(String httpTag) {
        Tag result = null;
        boolean weak = false;
        String httpTagCopy = httpTag;
        if (httpTagCopy.startsWith("W/")) {
            weak = true;
            httpTagCopy = httpTagCopy.substring(2);
        }
        if (httpTagCopy.startsWith("\"") && httpTagCopy.endsWith("\"")) {
            result = new Tag(httpTagCopy.substring(1, httpTagCopy.length() - 1), weak);
        } else if (httpTagCopy.equals("*")) {
            result = new Tag("*", weak);
        } else {
            Context.getCurrentLogger().log(Level.WARNING, "Invalid tag format detected: " + httpTagCopy);
        }
        return result;
    }

    public Tag() {
        this(null, true);
    }

    public Tag(String opaqueTag) {
        this(opaqueTag, true);
    }

    public Tag(String opaqueTag, boolean weak) {
        this.name = opaqueTag;
        this.weak = weak;
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean checkWeakness) {
        boolean result;
        boolean bl = result = object != null && object instanceof Tag;
        if (result) {
            Tag that = (Tag)object;
            if (checkWeakness) {
                boolean bl2 = result = that.isWeak() == this.isWeak();
            }
            if (result) {
                result = this.getName() == null ? that.getName() == null : this.getName().equals(that.getName());
            }
        }
        return result;
    }

    public String format() {
        if (this.getName().equals("*")) {
            return "*";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isWeak()) {
            sb.append("W/");
        }
        return sb.append('\"').append(this.getName()).append('\"').toString();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.format().hashCode();
    }

    public boolean isWeak() {
        return this.weak;
    }

    public String toString() {
        return this.getName();
    }
}

