/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.stdlib.GrokDictionaries;

public final class SplitKeyValueBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("splitKeyValue");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new SplitKeyValue(this, config, parent, child, context);
    }

    private static final class SplitKeyValue
    extends AbstractCommand {
        private final String inputFieldName;
        private final String outputFieldPrefix;
        private final String separator;
        private final Matcher regex;
        private final boolean addEmptyStrings;
        private final boolean trim;

        public SplitKeyValue(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.inputFieldName = this.getConfigs().getString(config, "inputField");
            this.outputFieldPrefix = this.getConfigs().getString(config, "outputFieldPrefix", "");
            this.separator = this.getConfigs().getString(config, "separator", "=");
            if (this.separator.length() == 0) {
                throw new MorphlineCompilationException("separator must not be the empty string", config);
            }
            if (this.getConfigs().getBoolean(config, "isRegex", false)) {
                GrokDictionaries dict = new GrokDictionaries(config, this.getConfigs());
                this.regex = dict.compileExpression(this.separator).pattern().matcher("");
            } else {
                this.regex = null;
            }
            this.addEmptyStrings = this.getConfigs().getBoolean(config, "addEmptyStrings", false);
            this.trim = this.getConfigs().getBoolean(config, "trim", true);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            for (Object item : record.get(this.inputFieldName)) {
                int end;
                int start;
                String str = item.toString();
                if (this.regex != null) {
                    if (this.regex.reset(str).find()) {
                        start = this.regex.start();
                        end = this.regex.end();
                    } else {
                        start = -1;
                        end = -1;
                    }
                } else if (this.separator.length() == 1) {
                    start = str.indexOf(this.separator.charAt(0));
                    end = start + 1;
                } else {
                    start = str.indexOf(this.separator);
                    end = start + this.separator.length();
                }
                String key = str;
                String value = "";
                if (start >= 0) {
                    key = str.substring(0, start);
                    value = str.substring(end, str.length());
                    value = this.trim(value);
                }
                if (value.length() <= 0 && !this.addEmptyStrings) continue;
                record.put(this.concat(this.outputFieldPrefix, this.trim(key)), value);
            }
            return super.doProcess(record);
        }

        private String trim(String str) {
            return this.trim ? str.trim() : str;
        }

        private String concat(String x, String y) {
            return x.length() == 0 ? y : x + y;
        }
    }
}

