/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.codelibs.robot.dbflute.DBDef;
import org.codelibs.robot.dbflute.Entity;
import org.codelibs.robot.dbflute.bhv.DeleteOption;
import org.codelibs.robot.dbflute.bhv.InsertOption;
import org.codelibs.robot.dbflute.bhv.UpdateOption;
import org.codelibs.robot.dbflute.cbean.ConditionBean;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbway.WayOfSQLServer;
import org.codelibs.robot.dbflute.dbway.WayOfSybase;
import org.codelibs.robot.dbflute.exception.EntityAlreadyUpdatedException;
import org.codelibs.robot.dbflute.exception.handler.SQLExceptionResource;
import org.codelibs.robot.dbflute.helper.beans.DfPropertyDesc;
import org.codelibs.robot.dbflute.jdbc.StatementFactory;
import org.codelibs.robot.dbflute.jdbc.ValueType;
import org.codelibs.robot.dbflute.resource.ResourceContext;
import org.codelibs.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.codelibs.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.codelibs.robot.dbflute.s2dao.sqlhandler.TnAbstractBasicSqlHandler;
import org.codelibs.robot.dbflute.s2dao.sqlhandler.TnBasicUpdateHandler;
import org.codelibs.robot.dbflute.util.DfCollectionUtil;
import org.codelibs.robot.dbflute.util.DfTypeUtil;

public abstract class TnAbstractEntityHandler
extends TnAbstractBasicSqlHandler {
    protected final TnBeanMetaData _beanMetaData;
    protected final TnPropertyType[] _boundPropTypes;
    protected boolean _optimisticLockHandling;
    protected boolean _versionNoAutoIncrementOnMemory;
    protected InsertOption<? extends ConditionBean> _insertOption;
    protected UpdateOption<? extends ConditionBean> _updateOption;
    protected DeleteOption<? extends ConditionBean> _deleteOption;
    protected Object[] _bindVariables;
    protected ValueType[] _bindVariableValueTypes;
    protected List<Timestamp> _newTimestampList;
    protected List<Long> _newVersionNoList;

    public TnAbstractEntityHandler(DataSource dataSource, StatementFactory statementFactory, String sql, TnBeanMetaData beanMetaData, TnPropertyType[] boundPropTypes) {
        super(dataSource, statementFactory, sql);
        this.assertObjectNotNull("beanMetaData", beanMetaData);
        this.assertObjectNotNull("boundPropTypes", boundPropTypes);
        this._beanMetaData = beanMetaData;
        this._boundPropTypes = boundPropTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] args) {
        Connection conn = this.getConnection();
        try {
            int n = this.execute(conn, args[0]);
            return n;
        }
        finally {
            this.close(conn);
        }
    }

    protected int execute(Connection conn, Object bean) {
        int ret;
        this.processBefore(bean);
        this.setupBindVariables(bean);
        this.logSql(this._bindVariables, this.getArgTypes(this._bindVariables));
        PreparedStatement ps = this.prepareStatement(conn);
        RuntimeException sqlEx = null;
        try {
            this.bindArgs(conn, ps, this._bindVariables, this._bindVariableValueTypes);
            ret = this.executeUpdate(ps);
            this.handleUpdateResultWithOptimisticLock(bean, ret);
        }
        catch (RuntimeException e) {
            sqlEx = e;
            throw e;
        }
        finally {
            this.close(ps);
            this.processFinally(bean, sqlEx);
        }
        this.processSuccess(bean, ret);
        return ret;
    }

    protected void processBefore(Object bean) {
    }

    protected void processFinally(Object bean, RuntimeException sqlEx) {
    }

    protected void processSuccess(Object bean, int ret) {
    }

    protected void handleUpdateResultWithOptimisticLock(Object bean, int ret) {
        if (this._optimisticLockHandling && ret < 1) {
            throw this.createEntityAlreadyUpdatedException(bean, ret);
        }
    }

    protected EntityAlreadyUpdatedException createEntityAlreadyUpdatedException(Object bean, int rows) {
        return new EntityAlreadyUpdatedException(bean, rows);
    }

    protected abstract void setupBindVariables(Object var1);

    protected void setupInsertBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        TnBeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < this._boundPropTypes.length; ++i) {
            TnPropertyType pt = this._boundPropTypes[i];
            if (pt.getPropertyName().equalsIgnoreCase(timestampPropertyName)) {
                Timestamp timestamp = ResourceContext.getAccessTimestamp();
                this.addNewTimestamp(timestamp);
                varList.add(timestamp);
            } else if (pt.getPropertyName().equalsIgnoreCase(versionNoPropertyName)) {
                Long firstNo = InsertOption.VERSION_NO_FIRST_VALUE;
                this.addNewVersionNo(firstNo);
                varList.add(firstNo);
            } else {
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varValueTypeList.add(pt.getValueType());
        }
        this._bindVariables = varList.toArray();
        this._bindVariableValueTypes = varValueTypeList.toArray(new ValueType[varValueTypeList.size()]);
    }

    protected void setupUpdateBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        Set<String> uniqueDrivenPropSet = this.extractUniqueDrivenPropSet(bean);
        TnBeanMetaData bmd = this.getBeanMetaData();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < this._boundPropTypes.length; ++i) {
            TnPropertyType pt = this._boundPropTypes[i];
            String propertyName = pt.getPropertyName();
            if (uniqueDrivenPropSet != null && uniqueDrivenPropSet.contains(propertyName)) continue;
            if (propertyName.equalsIgnoreCase(timestampPropertyName)) {
                Timestamp timestamp = ResourceContext.getAccessTimestamp();
                this.addNewTimestamp(timestamp);
                varList.add(timestamp);
            } else if (propertyName.equalsIgnoreCase(versionNoPropertyName)) {
                if (!this._versionNoAutoIncrementOnMemory) continue;
                Object value = pt.getPropertyDesc().getValue(bean);
                long longValue = DfTypeUtil.toPrimitiveLong(value) + 1L;
                Long versionNo = longValue;
                this.addNewVersionNo(versionNo);
                varList.add(versionNo);
            } else {
                if (this._updateOption != null && this._updateOption.hasStatement(pt.getColumnDbName())) continue;
                varList.add(pt.getPropertyDesc().getValue(bean));
            }
            varValueTypeList.add(pt.getValueType());
        }
        this.doSetupUpdateWhereBindVariables(varList, varValueTypeList, bean, uniqueDrivenPropSet);
        this._bindVariables = varList.toArray();
        this._bindVariableValueTypes = varValueTypeList.toArray(new ValueType[varValueTypeList.size()]);
    }

    protected void setupDeleteBindVariables(Object bean) {
        ArrayList<Object> varList = new ArrayList<Object>();
        ArrayList<ValueType> varValueTypeList = new ArrayList<ValueType>();
        Set<String> uniqueDrivenPropertySet = this.extractUniqueDrivenPropSet(bean);
        this.doSetupUpdateWhereBindVariables(varList, varValueTypeList, bean, uniqueDrivenPropertySet);
        this._bindVariables = varList.toArray();
        this._bindVariableValueTypes = varValueTypeList.toArray(new ValueType[varValueTypeList.size()]);
    }

    protected Set<String> extractUniqueDrivenPropSet(Object bean) {
        Set<String> propSet;
        if (bean instanceof Entity && (propSet = ((Entity)bean).myuniqueDrivenProperties()) != null && !propSet.isEmpty()) {
            return propSet;
        }
        return null;
    }

    protected void doSetupUpdateWhereBindVariables(List<Object> varList, List<ValueType> varValueTypeList, Object bean, Set<String> uniqueDrivenPropSet) {
        TnPropertyType pt;
        TnBeanMetaData bmd = this.getBeanMetaData();
        if (uniqueDrivenPropSet != null && !uniqueDrivenPropSet.isEmpty()) {
            for (String uniqueProp : uniqueDrivenPropSet) {
                TnPropertyType pt2 = bmd.getPropertyType(uniqueProp);
                this.doRegisterUpdateWhereBindVariable(varList, varValueTypeList, bean, pt2);
            }
        } else {
            for (int i = 0; i < bmd.getPrimaryKeySize(); ++i) {
                TnPropertyType pt3 = bmd.getPropertyTypeByColumnName(bmd.getPrimaryKeyDbName(i));
                this.doRegisterUpdateWhereBindVariable(varList, varValueTypeList, bean, pt3);
            }
        }
        if (this._optimisticLockHandling && bmd.hasVersionNoPropertyType()) {
            pt = bmd.getVersionNoPropertyType();
            this.doRegisterUpdateWhereBindVariable(varList, varValueTypeList, bean, pt);
        }
        if (this._optimisticLockHandling && bmd.hasTimestampPropertyType()) {
            pt = bmd.getTimestampPropertyType();
            this.doRegisterUpdateWhereBindVariable(varList, varValueTypeList, bean, pt);
        }
    }

    protected void doRegisterUpdateWhereBindVariable(List<Object> varList, List<ValueType> varValueTypeList, Object bean, TnPropertyType pt) {
        DfPropertyDesc pd = pt.getPropertyDesc();
        varList.add(pd.getValue(bean));
        varValueTypeList.add(pt.getValueType());
    }

    protected void addNewTimestamp(Timestamp timestamp) {
        if (this._newTimestampList == null) {
            this._newTimestampList = DfCollectionUtil.newArrayList();
        }
        this._newTimestampList.add(timestamp);
    }

    protected void addNewVersionNo(Long versionNo) {
        if (this._newVersionNoList == null) {
            this._newVersionNoList = DfCollectionUtil.newArrayList();
        }
        this._newVersionNoList.add(versionNo);
    }

    protected void updateTimestampIfNeed(Object bean) {
        this.updateTimestampIfNeed(bean, 0);
    }

    protected void updateTimestampIfNeed(Object bean, int index) {
        List<Timestamp> newTimestampList = this._newTimestampList;
        if (newTimestampList == null || newTimestampList.isEmpty()) {
            return;
        }
        DfPropertyDesc pd = this.getBeanMetaData().getTimestampPropertyType().getPropertyDesc();
        pd.setValue(bean, newTimestampList.get(index));
    }

    protected void updateVersionNoIfNeed(Object bean) {
        this.updateVersionNoIfNeed(bean, 0);
    }

    protected void updateVersionNoIfNeed(Object bean, int index) {
        List<Long> newVersionNoList = this._newVersionNoList;
        if (newVersionNoList == null || newVersionNoList.isEmpty()) {
            return;
        }
        DfPropertyDesc pd = this.getBeanMetaData().getVersionNoPropertyType().getPropertyDesc();
        pd.setValue(bean, newVersionNoList.get(index));
    }

    protected void disableIdentityGeneration() {
        String tableDbName = this._beanMetaData.getTableName();
        TnAbstractEntityHandler.delegateDisableIdentityGeneration(tableDbName, this._dataSource, this._statementFactory);
    }

    protected void enableIdentityGeneration() {
        String tableDbName = this._beanMetaData.getTableName();
        TnAbstractEntityHandler.delegateEnableIdentityGeneration(tableDbName, this._dataSource, this._statementFactory);
    }

    protected boolean isPrimaryKeyIdentityDisabled() {
        return this._insertOption != null && this._insertOption.isPrimaryKeyIdentityDisabled();
    }

    public static void delegateDisableIdentityGeneration(String tableDbName, DataSource dataSource, StatementFactory statementFactory) {
        TnIdentityGenerationHandler handler = new TnIdentityGenerationHandler();
        handler.disableIdentityGeneration(tableDbName, dataSource, statementFactory);
    }

    public static void delegateEnableIdentityGeneration(String tableDbName, DataSource dataSource, StatementFactory statementFactory) {
        TnIdentityGenerationHandler handler = new TnIdentityGenerationHandler();
        handler.enableIdentityGeneration(tableDbName, dataSource, statementFactory);
    }

    public TnBeanMetaData getBeanMetaData() {
        return this._beanMetaData;
    }

    public void setOptimisticLockHandling(boolean optimisticLockHandling) {
        this._optimisticLockHandling = optimisticLockHandling;
    }

    public void setVersionNoAutoIncrementOnMemory(boolean versionNoAutoIncrementOnMemory) {
        this._versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
    }

    public void setInsertOption(InsertOption<? extends ConditionBean> insertOption) {
        this._insertOption = insertOption;
    }

    public void setUpdateOption(UpdateOption<? extends ConditionBean> updateOption) {
        this._updateOption = updateOption;
    }

    public void setDeleteOption(DeleteOption<? extends ConditionBean> deleteOption) {
        this._deleteOption = deleteOption;
    }

    protected static class TnIdentityAdjustmentSqlHandler
    extends TnBasicUpdateHandler {
        public TnIdentityAdjustmentSqlHandler(DataSource dataSource, StatementFactory statementFactory, String sql) {
            super(dataSource, statementFactory, sql);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object doExecute(Connection conn, Object[] args, Class<?>[] argTypes) {
            this.logSql(args, argTypes);
            Statement st = null;
            try {
                st = conn.createStatement();
                Integer n = st.executeUpdate(this._sql);
                return n;
            }
            catch (SQLException e) {
                SQLExceptionResource resource = this.createSQLExceptionResource();
                resource.setNotice("Failed to execute the SQL to adjust identity.");
                this.handleSQLException(e, resource);
                Integer n = 0;
                return n;
            }
            finally {
                this.close(st);
            }
        }
    }

    protected static class TnIdentityGenerationHandler {
        protected TnIdentityGenerationHandler() {
        }

        public void disableIdentityGeneration(String tableDbName, DataSource dataSource, StatementFactory statementFactory) {
            if (this.isDatabaseSQLServer()) {
                String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
                String disableSql = this.getWayOfSQLServer().buildIdentityDisableSql(tableSqlName);
                this.doExecuteIdentityAdjustment(disableSql, dataSource, statementFactory);
            } else if (this.isDatabaseSybase()) {
                String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
                String disableSql = this.getWayOfSybase().buildIdentityDisableSql(tableSqlName);
                this.doExecuteIdentityAdjustment(disableSql, dataSource, statementFactory);
            }
        }

        public void enableIdentityGeneration(String tableDbName, DataSource dataSource, StatementFactory statementFactory) {
            if (this.isDatabaseSQLServer()) {
                String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
                String enableSql = this.getWayOfSQLServer().buildIdentityEnableSql(tableSqlName);
                this.doExecuteIdentityAdjustment(enableSql, dataSource, statementFactory);
            } else if (this.isDatabaseSybase()) {
                String tableSqlName = this.findDBMeta(tableDbName).getTableSqlName().toString();
                String enableSql = this.getWayOfSybase().buildIdentityEnableSql(tableSqlName);
                this.doExecuteIdentityAdjustment(enableSql, dataSource, statementFactory);
            }
        }

        protected DBMeta findDBMeta(String tableDbName) {
            return ResourceContext.dbmetaProvider().provideDBMeta(tableDbName);
        }

        protected boolean isDatabaseSQLServer() {
            return ResourceContext.isCurrentDBDef(DBDef.SQLServer);
        }

        protected boolean isDatabaseSybase() {
            return ResourceContext.isCurrentDBDef(DBDef.Sybase);
        }

        protected WayOfSQLServer getWayOfSQLServer() {
            return (WayOfSQLServer)ResourceContext.currentDBDef().dbway();
        }

        protected WayOfSybase getWayOfSybase() {
            return (WayOfSybase)ResourceContext.currentDBDef().dbway();
        }

        protected void doExecuteIdentityAdjustment(String sql, DataSource dataSource, StatementFactory statementFactory) {
            TnIdentityAdjustmentSqlHandler handler = this.createIdentityAdjustmentSqlHandler(sql, dataSource, statementFactory);
            handler.execute(new Object[0]);
        }

        protected TnIdentityAdjustmentSqlHandler createIdentityAdjustmentSqlHandler(String sql, DataSource dataSource, StatementFactory statementFactory) {
            return new TnIdentityAdjustmentSqlHandler(dataSource, statementFactory, sql);
        }
    }
}

