/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.codelibs.robot.dbflute.Entity;
import org.codelibs.robot.dbflute.bhv.InsertOption;
import org.codelibs.robot.dbflute.bhv.UpdateOption;
import org.codelibs.robot.dbflute.cbean.ConditionBean;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.info.ColumnInfo;
import org.codelibs.robot.dbflute.helper.StringKeyMap;
import org.codelibs.robot.dbflute.jdbc.StatementConfig;
import org.codelibs.robot.dbflute.jdbc.StatementFactory;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;
import org.codelibs.robot.dbflute.resource.InternalMapContext;
import org.codelibs.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.codelibs.robot.dbflute.s2dao.sqlcommand.TnAbstractQueryDynamicCommand;
import org.codelibs.robot.dbflute.s2dao.sqlhandler.TnAbstractEntityHandler;
import org.codelibs.robot.dbflute.s2dao.sqlhandler.TnCommandContextHandler;
import org.codelibs.robot.dbflute.twowaysql.context.CommandContext;
import org.codelibs.robot.dbflute.util.Srl;

public class TnQueryInsertDynamicCommand
extends TnAbstractQueryDynamicCommand {
    public TnQueryInsertDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    public Object execute(Object[] args) {
        int rows;
        boolean identityDisabled;
        Entity entity = this.extractEntityWithCheck(args);
        ConditionBean intoCB = this.extractIntoConditionBeanWithCheck(args);
        ConditionBean resourceCB = this.extractResourceConditionBeanWithCheck(args);
        InsertOption<ConditionBean> option = this.extractInsertOptionWithCheck(args);
        this.prepareStatementConfigOnThreadIfExists(option);
        String[] argNames = new String[]{"entity", "pmb"};
        Class[] argTypes = new Class[]{entity.getClass(), resourceCB.getClass()};
        Object[] realArgs = new Object[]{entity, resourceCB};
        ArrayList<TnPropertyType> boundPropTypeList = new ArrayList<TnPropertyType>();
        String twoWaySql = this.buildQueryInsertTwoWaySql(entity, intoCB, resourceCB, option, boundPropTypeList);
        CommandContext context = this.createCommandContext(twoWaySql, argNames, argTypes, realArgs);
        TnCommandContextHandler handler = this.createCommandContextHandler(context);
        handler.setExceptionMessageSqlArgs(context.getBindVariables());
        boolean bl = identityDisabled = option != null && option.isPrimaryKeyIdentityDisabled();
        if (identityDisabled) {
            this.disableIdentityGeneration(entity);
        }
        RuntimeException sqlEx = null;
        try {
            rows = handler.execute(realArgs);
        }
        catch (RuntimeException e) {
            sqlEx = e;
            throw e;
        }
        finally {
            block12: {
                if (identityDisabled) {
                    try {
                        this.enableIdentityGeneration(entity);
                    }
                    catch (RuntimeException e) {
                        if (sqlEx != null) break block12;
                        throw e;
                    }
                }
            }
        }
        return rows;
    }

    protected Entity extractEntityWithCheck(Object[] args) {
        this.assertArgument(args);
        Object fisrtArg = args[0];
        if (!(fisrtArg instanceof Entity)) {
            String msg = "The type of first argument should be " + Entity.class + ":";
            msg = msg + " type=" + fisrtArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (Entity)fisrtArg;
    }

    protected ConditionBean extractIntoConditionBeanWithCheck(Object[] args) {
        this.assertArgument(args);
        Object secondArg = args[1];
        if (!(secondArg instanceof ConditionBean)) {
            String msg = "The type of second argument should be " + ConditionBean.class + ":";
            msg = msg + " type=" + secondArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (ConditionBean)secondArg;
    }

    protected ConditionBean extractResourceConditionBeanWithCheck(Object[] args) {
        this.assertArgument(args);
        Object thirdArg = args[2];
        if (!(thirdArg instanceof ConditionBean)) {
            String msg = "The type of third argument should be " + ConditionBean.class + ":";
            msg = msg + " type=" + thirdArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (ConditionBean)thirdArg;
    }

    protected InsertOption<ConditionBean> extractInsertOptionWithCheck(Object[] args) {
        this.assertArgument(args);
        if (args.length < 4) {
            return null;
        }
        Object fourthArg = args[3];
        if (fourthArg == null) {
            return null;
        }
        if (!(fourthArg instanceof InsertOption)) {
            String msg = "The type of fourth argument should be " + UpdateOption.class + ":";
            msg = msg + " type=" + fourthArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        InsertOption option = (InsertOption)fourthArg;
        return option;
    }

    protected void prepareStatementConfigOnThreadIfExists(InsertOption<ConditionBean> option) {
        StatementConfig config;
        StatementConfig statementConfig = config = option != null ? option.getInsertStatementConfig() : null;
        if (config != null) {
            InternalMapContext.setUpdateStatementConfig(config);
        }
    }

    protected void assertArgument(Object[] args) {
        if (args == null || args.length <= 1) {
            String msg = "The arguments should have two argument at least! But:";
            msg = msg + " args=" + (args != null ? Integer.valueOf(args.length) : null);
            throw new IllegalArgumentException(msg);
        }
    }

    protected String buildQueryInsertTwoWaySql(Entity entity, ConditionBean intoCB, ConditionBean resourceCB, InsertOption<ConditionBean> option, List<TnPropertyType> boundPropTypeList) {
        StringKeyMap<String> fixedValueQueryExpMap = StringKeyMap.createAsFlexibleOrdered();
        Set<String> modifiedProperties = entity.modifiedProperties();
        DBMeta dbmeta = entity.getDBMeta();
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            String propertyName = columnInfo.getPropertyName();
            if (!modifiedProperties.contains(propertyName)) continue;
            Object value = columnInfo.read(entity);
            String fixedValueQueryExp = value != null ? "/*entity." + propertyName + "*/null" : null;
            fixedValueQueryExpMap.put(columnInfo.getColumnDbName(), fixedValueQueryExp);
        }
        return intoCB.getSqlClause().getClauseQueryInsert(fixedValueQueryExpMap, resourceCB.getSqlClause());
    }

    protected void disableIdentityGeneration(Entity entity) {
        String tableDbName = entity.getTableDbName();
        TnAbstractEntityHandler.delegateDisableIdentityGeneration(tableDbName, this._dataSource, this._statementFactory);
    }

    protected void enableIdentityGeneration(Entity entity) {
        String tableDbName = entity.getTableDbName();
        TnAbstractEntityHandler.delegateEnableIdentityGeneration(tableDbName, this._dataSource, this._statementFactory);
    }

    @Override
    protected String getUpdateSQLFailureProcessTitle() {
        return "query insert";
    }

    protected String replace(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }
}

