/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import java.util.Set;
import javax.sql.DataSource;
import org.codelibs.robot.dbflute.Entity;
import org.codelibs.robot.dbflute.bhv.InsertOption;
import org.codelibs.robot.dbflute.cbean.ConditionBean;
import org.codelibs.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.jdbc.StatementConfig;
import org.codelibs.robot.dbflute.jdbc.StatementFactory;
import org.codelibs.robot.dbflute.resource.InternalMapContext;
import org.codelibs.robot.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.codelibs.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.codelibs.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.codelibs.robot.dbflute.s2dao.sqlcommand.TnAbstractEntityDynamicCommand;
import org.codelibs.robot.dbflute.s2dao.sqlhandler.TnInsertEntityHandler;

public class TnInsertEntityDynamicCommand
extends TnAbstractEntityDynamicCommand {
    public TnInsertEntityDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    public Object execute(Object[] args) {
        Object bean = this.extractBeanFromArgsChecked(args);
        InsertOption<ConditionBean> option = this.extractInsertOptionChecked(args);
        this.prepareStatementConfigOnThreadIfExists(option);
        TnBeanMetaData bmd = this._beanMetaData;
        TnPropertyType[] propertyTypes = this.createInsertPropertyTypes(bmd, bean, this._propertyNames, option);
        String sql = this.filterExecutedSql(this.createInsertSql(bmd, propertyTypes, option));
        return this.doExecute(bean, propertyTypes, sql, option);
    }

    protected InsertOption<ConditionBean> extractInsertOptionChecked(Object[] args) {
        if (args.length < 2 || args[1] == null) {
            return null;
        }
        InsertOption option = (InsertOption)args[1];
        return option;
    }

    protected void prepareStatementConfigOnThreadIfExists(InsertOption<ConditionBean> option) {
        StatementConfig config;
        StatementConfig statementConfig = config = option != null ? option.getInsertStatementConfig() : null;
        if (config != null) {
            InternalMapContext.setUpdateStatementConfig(config);
        }
    }

    protected Object doExecute(Object bean, TnPropertyType[] propertyTypes, String sql, InsertOption<ConditionBean> option) {
        TnInsertEntityHandler handler = this.createInsertEntityHandler(propertyTypes, sql, option);
        Object[] realArgs = new Object[]{bean};
        handler.setExceptionMessageSqlArgs(realArgs);
        int rows = handler.execute(realArgs);
        return rows;
    }

    protected TnPropertyType[] createInsertPropertyTypes(TnBeanMetaData bmd, Object bean, String[] propertyNames, InsertOption<ConditionBean> option) {
        if (0 == propertyNames.length) {
            String msg = "The property name was not found in the bean: " + bean;
            throw new IllegalStateException(msg);
        }
        ArrayList<TnPropertyType> typeList = new ArrayList<TnPropertyType>();
        Set<?> modifiedSet = this.getModifiedPropertyNames(bean);
        String timestampProp = bmd.getTimestampPropertyName();
        String versionNoProp = bmd.getVersionNoPropertyName();
        for (int i = 0; i < propertyNames.length; ++i) {
            TnPropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey()) {
                TnIdentifierGenerator generator;
                if ((option == null || !option.isPrimaryKeyIdentityDisabled()) && !(generator = bmd.getIdentifierGenerator(pt.getPropertyName())).isSelfGenerate()) continue;
                typeList.add(pt);
                continue;
            }
            if (!this.isOptimisticLockProperty(timestampProp, versionNoProp, pt) && !this.isSpecifiedProperty(bean, option, modifiedSet, pt)) continue;
            typeList.add(pt);
        }
        if (typeList.isEmpty()) {
            this.throwEntityInsertPropertyNotFoundException(bmd, bean);
        }
        return typeList.toArray(new TnPropertyType[typeList.size()]);
    }

    protected Set<?> getModifiedPropertyNames(Object bean) {
        return this._beanMetaData.getModifiedPropertyNames(bean);
    }

    protected boolean isOptimisticLockProperty(String timestampProp, String versionNoProp, TnPropertyType pt) {
        String propertyName = pt.getPropertyName();
        return propertyName.equalsIgnoreCase(timestampProp) || propertyName.equalsIgnoreCase(versionNoProp);
    }

    protected boolean isSpecifiedProperty(Object bean, InsertOption<ConditionBean> option, Set<?> modifiedSet, TnPropertyType pt) {
        if (option != null && option.hasSpecifiedInsertColumn()) {
            return option.isSpecifiedInsertColumn(pt.getColumnDbName());
        }
        if (this.isEntityCreatedBySelect(bean)) {
            return true;
        }
        if (option != null && option.xisCompatibleInsertColumnNotNullOnly()) {
            return this.isNotNullProperty(bean, pt);
        }
        return this.isModifiedProperty(modifiedSet, pt);
    }

    protected boolean isEntityCreatedBySelect(Object bean) {
        if (bean instanceof Entity) {
            Entity entity = (Entity)bean;
            return entity.createdBySelect();
        }
        return false;
    }

    protected boolean isNotNullProperty(Object bean, TnPropertyType pt) {
        return pt.getPropertyAccessor().getValue(bean) != null;
    }

    protected boolean isModifiedProperty(Set<?> modifiedSet, TnPropertyType pt) {
        return modifiedSet.contains(pt.getPropertyName());
    }

    protected void throwEntityInsertPropertyNotFoundException(TnBeanMetaData bmd, Object bean) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The insert property of the entity was not found.");
        br.addItem("Advice");
        br.addElement("The entity should have one or more insert properties.");
        br.addElement("For example, an identity-column-only table is unsupported.");
        br.addItem("Table");
        br.addElement(bmd.getTableName());
        br.addItem("Entity");
        br.addElement(bean != null ? bean.getClass() : null);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected String createInsertSql(TnBeanMetaData bmd, TnPropertyType[] propertyTypes, InsertOption<ConditionBean> option) {
        String tableDbName = this._targetDBMeta.getTableDbName();
        StringBuilder columnSb = new StringBuilder(48);
        StringBuilder valuesSb = new StringBuilder(48);
        for (int i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            ColumnSqlName columnSqlName = pt.getColumnSqlName();
            if (i > 0) {
                columnSb.append(", ");
                valuesSb.append(", ");
            }
            columnSb.append(columnSqlName);
            String columnDbName = pt.getColumnDbName();
            valuesSb.append(this.encryptIfNeeds(tableDbName, columnDbName, "?"));
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("insert into ").append(this._targetDBMeta.getTableSqlName());
        sb.append(" (").append((CharSequence)columnSb).append(")");
        sb.append(this.ln()).append(" values (").append((CharSequence)valuesSb).append(")");
        return sb.toString();
    }

    protected TnInsertEntityHandler createInsertEntityHandler(TnPropertyType[] boundPropTypes, String sql, InsertOption<ConditionBean> option) {
        TnInsertEntityHandler handler = new TnInsertEntityHandler(this._dataSource, this._statementFactory, sql, this._beanMetaData, boundPropTypes);
        handler.setInsertOption(option);
        return handler;
    }
}

