/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.s2dao.sqlcommand;

import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.codelibs.robot.dbflute.CallbackContext;
import org.codelibs.robot.dbflute.Entity;
import org.codelibs.robot.dbflute.bhv.SqlStringFilter;
import org.codelibs.robot.dbflute.bhv.core.BehaviorCommand;
import org.codelibs.robot.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.name.ColumnSqlName;
import org.codelibs.robot.dbflute.jdbc.StatementFactory;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;
import org.codelibs.robot.dbflute.resource.ResourceContext;
import org.codelibs.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.codelibs.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.codelibs.robot.dbflute.s2dao.sqlcommand.TnAbstractBasicSqlCommand;

public abstract class TnAbstractEntityDynamicCommand
extends TnAbstractBasicSqlCommand {
    protected TnBeanMetaData _beanMetaData;
    protected DBMeta _targetDBMeta;
    protected String[] _propertyNames;

    public TnAbstractEntityDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    protected Object extractBeanFromArgsChecked(Object[] args) {
        if (args == null || args.length == 0) {
            String msg = "The argument 'args' should not be null or empty.";
            throw new IllegalArgumentException(msg);
        }
        Object bean = args[0];
        if (bean == null) {
            String msg = "The argument 'args' should have not-null bean at first element.";
            throw new IllegalArgumentException(msg);
        }
        return bean;
    }

    protected List<?> extractBeanListFromBeanChecked(Object bean) {
        if (!(bean instanceof List)) {
            String msg = "The argument 'args[0]' should be list: " + bean;
            throw new IllegalArgumentException(msg);
        }
        List beanList = (List)bean;
        return beanList;
    }

    protected void checkPrimaryKey() {
        TnBeanMetaData bmd = this._beanMetaData;
        if (bmd.getPrimaryKeySize() == 0) {
            String msg = "The table '" + this._targetDBMeta.getTableDbName() + "' should have primary key.";
            throw new IllegalStateException(msg);
        }
    }

    protected Set<String> extractUniqueDrivenPropSet(Object bean) {
        Set<String> propSet;
        if (bean instanceof Entity && (propSet = ((Entity)bean).myuniqueDrivenProperties()) != null && !propSet.isEmpty()) {
            return propSet;
        }
        return null;
    }

    protected void setupUpdateWhere(StringBuilder sb, Set<String> uniqueDrivenPropSet, boolean optimisticLockHandling) {
        TnPropertyType pt;
        TnBeanMetaData bmd = this._beanMetaData;
        sb.append(" where ");
        this.prepareWherePrimaryKey(sb, uniqueDrivenPropSet);
        if (optimisticLockHandling && bmd.hasVersionNoPropertyType()) {
            pt = bmd.getVersionNoPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
        if (optimisticLockHandling && bmd.hasTimestampPropertyType()) {
            pt = bmd.getTimestampPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
    }

    protected void prepareWherePrimaryKey(StringBuilder sb, Set<String> uniqueDrivenPropSet) {
        String bindingSuffix = " = ?";
        String connectorSuffix = " and ";
        if (uniqueDrivenPropSet != null && !uniqueDrivenPropSet.isEmpty()) {
            for (String uniqueProp : uniqueDrivenPropSet) {
                ColumnSqlName sqlName = this._targetDBMeta.findColumnInfo(uniqueProp).getColumnSqlName();
                sb.append(sqlName).append(" = ?").append(" and ");
            }
        } else {
            for (int i = 0; i < this._beanMetaData.getPrimaryKeySize(); ++i) {
                ColumnSqlName sqlName = this._beanMetaData.getPrimaryKeySqlName(i);
                sb.append(sqlName).append(" = ?").append(" and ");
            }
        }
        sb.setLength(sb.length() - " and ".length());
    }

    protected String filterExecutedSql(String executedSql) {
        return this.doFilterExecutedSqlByCallbackFilter(executedSql);
    }

    protected String doFilterExecutedSqlByCallbackFilter(String executedSql) {
        SqlStringFilter sqlStringFilter = this.getSqlStringFilter();
        if (sqlStringFilter != null) {
            BehaviorCommand<?> meta = ResourceContext.behaviorCommand();
            String filteredSql = sqlStringFilter.filterEntityUpdate(meta, executedSql);
            return filteredSql != null ? filteredSql : executedSql;
        }
        return executedSql;
    }

    protected SqlStringFilter getSqlStringFilter() {
        if (!CallbackContext.isExistSqlStringFilterOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlStringFilter();
    }

    protected String encryptIfNeeds(String tableDbName, String columnDbName, String valueExp) {
        ColumnFunctionCipher cipher = ResourceContext.findColumnFunctionCipher(tableDbName, columnDbName);
        return cipher != null ? cipher.encrypt(valueExp) : valueExp;
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public void setBeanMetaData(TnBeanMetaData beanMetaData) {
        this._beanMetaData = beanMetaData;
    }

    public void setTargetDBMeta(DBMeta targetDBMeta) {
        this._targetDBMeta = targetDBMeta;
    }

    public void setPropertyNames(String[] propertyNames) {
        this._propertyNames = propertyNames;
    }
}

