/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.resource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.codelibs.robot.dbflute.jdbc.DataSourceHandler;
import org.codelibs.robot.dbflute.jdbc.NotClosingConnectionWrapper;

public class ManualThreadDataSourceHandler
implements DataSourceHandler {
    private static final ThreadLocal<ManualThreadDataSourceHandler> _handlerLocal = new ThreadLocal();
    protected NotClosingConnectionWrapper _connectionWrapper;

    public static ManualThreadDataSourceHandler getDataSourceHandler() {
        return _handlerLocal.get();
    }

    public static void prepareDataSourceHandler() {
        if (_handlerLocal.get() != null) {
            return;
        }
        ManualThreadDataSourceHandler handler = new ManualThreadDataSourceHandler();
        _handlerLocal.set(handler);
    }

    public static void closeDataSourceHandler() {
        ManualThreadDataSourceHandler handler = _handlerLocal.get();
        if (handler == null) {
            return;
        }
        try {
            handler.close();
        }
        catch (SQLException e) {
            String msg = "Failed to close the data source handler of manual thread: " + handler;
            throw new IllegalStateException(msg, e);
        }
        _handlerLocal.set(null);
    }

    @Override
    public Connection getConnection(DataSource actualDs) throws SQLException {
        if (this._connectionWrapper != null) {
            return this._connectionWrapper;
        }
        Connection actualConnection = actualDs.getConnection();
        this._connectionWrapper = new NotClosingConnectionWrapper(actualConnection);
        this._connectionWrapper.keepActualIfClosed();
        return this._connectionWrapper;
    }

    public void close() throws SQLException {
        if (this._connectionWrapper != null) {
            this._connectionWrapper.closeActualReally();
            this._connectionWrapper = null;
        }
    }
}

