/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.infra.reps;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.infra.reps.DfRepsSchemaSqlDir;
import org.codelibs.robot.dbflute.infra.reps.exception.DfReplaceSchemaExecuteNotAllowedException;

public class DfRepsExecuteLimitter {
    protected final String _sqlRootDir;
    protected final String _sqlFileEncoding;

    public DfRepsExecuteLimitter(String sqlRootDir, String sqlFileEncoding) {
        this._sqlRootDir = sqlRootDir;
        this._sqlFileEncoding = sqlFileEncoding;
    }

    public void checkExecutableOrNot() {
        DfRepsSchemaSqlDir schemaSqlDir = this.createRepsSchemaSqlDir();
        List<File> sqlFileList = schemaSqlDir.collectReplaceSchemaSqlFileList();
        for (File sqlFile : sqlFileList) {
            String text = this.readSqlFileText(sqlFile);
            if (text.trim().length() <= 0) continue;
            return;
        }
        this.throwReplaceSchemaExecuteNotAllowedException();
    }

    protected DfRepsSchemaSqlDir createRepsSchemaSqlDir() {
        return new DfRepsSchemaSqlDir(this._sqlRootDir);
    }

    protected void throwReplaceSchemaExecuteNotAllowedException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Your ReplaceSchema execution was not allowed.");
        br.addItem("Advice");
        br.addElement("Not found SQL files for ReplaceSchema,");
        br.addElement("so your execution might be mistake...?");
        br.addItem("SQL Root Directory");
        br.addElement(this._sqlRootDir);
        String msg = br.buildExceptionMessage();
        throw new DfReplaceSchemaExecuteNotAllowedException(msg);
    }

    protected String readSqlFileText(File sqlFile) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sqlFile), this._sqlFileEncoding));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            line = sb.toString();
            return line;
        }
        catch (Exception e) {
            String msg = "Failed to read the SQL file for check:";
            msg = msg + " file=" + sqlFile + " encoding=" + this._sqlFileEncoding;
            throw new IllegalStateException(msg);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

