/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.infra.diffmap;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.codelibs.robot.dbflute.exception.DfPropFileReadFailureException;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.helper.mapstring.MapListFile;

public class DfDiffMapFile {
    public Map<String, Object> readMap(InputStream ins) {
        MapListFile mapListFile = this.createMapListFile();
        try {
            return mapListFile.readMap(ins);
        }
        catch (Exception e) {
            this.throwDfPropFileReadFailureException(ins, e);
            return null;
        }
    }

    protected void throwDfPropFileReadFailureException(InputStream ins, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to read the diff-map file.");
        br.addItem("Advice");
        br.addElement("Make sure the map-string is correct in the file.");
        br.addElement("For exapmle, the number of start and end braces are the same.");
        br.addItem("DBFlute Property");
        br.addElement(ins);
        String msg = br.buildExceptionMessage();
        throw new DfPropFileReadFailureException(msg, e);
    }

    public void writeMap(OutputStream ous, Map<String, Object> map) {
        MapListFile mapListFile = this.createMapListFile();
        try {
            mapListFile.writeMap(ous, map);
        }
        catch (Exception e) {
            this.throwDfPropFileWriteFailureException(ous, e);
        }
    }

    protected void throwDfPropFileWriteFailureException(OutputStream ous, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to write the diff-map file.");
        br.addItem("DBFlute Property");
        br.addElement(ous);
        String msg = br.buildExceptionMessage();
        throw new DfPropFileReadFailureException(msg, e);
    }

    protected MapListFile createMapListFile() {
        return new MapListFile();
    }
}

