/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.cbean.coption;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codelibs.robot.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.codelibs.robot.dbflute.cbean.cipher.GearedCipherManager;
import org.codelibs.robot.dbflute.cbean.coption.ParameterOption;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClause;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClauseDb2;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClauseDerby;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClauseH2;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClauseMySql;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClauseOracle;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClausePostgreSql;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClauseSqlServer;
import org.codelibs.robot.dbflute.cbean.sqlclause.subquery.QueryDerivedReferrer;
import org.codelibs.robot.dbflute.cbean.sqlclause.subquery.SpecifyDerivedReferrer;
import org.codelibs.robot.dbflute.cbean.sqlclause.subquery.SubQueryIndentProcessor;
import org.codelibs.robot.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.info.ColumnInfo;
import org.codelibs.robot.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.codelibs.robot.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.codelibs.robot.dbflute.exception.IllegalConditionBeanOperationException;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;
import org.codelibs.robot.dbflute.util.DfTypeUtil;
import org.codelibs.robot.dbflute.util.Srl;

public class FunctionFilterOption
implements ParameterOption {
    protected static final String DATE_TRUNC_MONTH = "df:month";
    protected static final String DATE_TRUNC_DAY = "df:day";
    protected static final String DATE_TRUNC_TIME = "df:time";
    protected Object _coalesce;
    protected Object _round;
    protected Object _trunc;
    protected Integer _addYear;
    protected Integer _addMonth;
    protected Integer _addDay;
    protected Integer _addHour;
    protected Integer _addMinute;
    protected Integer _addSecond;
    protected LinkedHashMap<String, ProcessCallback> _callbackMap;
    protected String _parameterKey;
    protected String _parameterMapPath;
    protected ColumnInfo _targetColumnInfo;
    protected boolean _databaseMySQL;
    protected boolean _databasePostgreSQL;
    protected boolean _databaseOracle;
    protected boolean _databaseDB2;
    protected boolean _databaseSQLServer;
    protected boolean _databaseH2;
    protected boolean _databaseDerby;

    protected void doCoalesce(Object coalesce) {
        this._coalesce = coalesce;
        this.addProcessCallback("coalesce", new ProcessCallback(){

            @Override
            public String callback(String functionExp) {
                return FunctionFilterOption.this.processCoalesce(functionExp);
            }
        });
    }

    protected void doRound(Object round) {
        this._round = round;
        this.addProcessCallback("round", new ProcessCallback(){

            @Override
            public String callback(String functionExp) {
                return FunctionFilterOption.this.processRound(functionExp);
            }
        });
    }

    protected void doTrunc(Object trunc) {
        this._trunc = trunc;
        this.addProcessCallback("trunc", new ProcessCallback(){

            @Override
            public String callback(String functionExp) {
                return FunctionFilterOption.this.processTrunc(functionExp);
            }
        });
    }

    protected void doTruncMonth() {
        this.doTrunc(DATE_TRUNC_MONTH);
    }

    protected void doTruncDay() {
        this.doTrunc(DATE_TRUNC_DAY);
    }

    protected void doTruncTime() {
        this.doTrunc(DATE_TRUNC_TIME);
    }

    protected void doAddYear(Integer addedYear) {
        this._addYear = addedYear;
        this.addProcessCallback("addYear", new ProcessCallback(){

            @Override
            public String callback(String functionExp) {
                return FunctionFilterOption.this.processAddYear(functionExp);
            }
        });
    }

    protected void doAddMonth(Integer addedMonth) {
        this._addMonth = addedMonth;
        this.addProcessCallback("addMonth", new ProcessCallback(){

            @Override
            public String callback(String functionExp) {
                return FunctionFilterOption.this.processAddMonth(functionExp);
            }
        });
    }

    protected void doAddDay(Integer addedDay) {
        this._addDay = addedDay;
        this.addProcessCallback("addDay", new ProcessCallback(){

            @Override
            public String callback(String functionExp) {
                return FunctionFilterOption.this.processAddDay(functionExp);
            }
        });
    }

    protected void doAddHour(Integer addedHour) {
        this._addHour = addedHour;
        this.addProcessCallback("addHour", new ProcessCallback(){

            @Override
            public String callback(String functionExp) {
                return FunctionFilterOption.this.processAddHour(functionExp);
            }
        });
    }

    protected void doAddMinute(Integer addedMinute) {
        this._addMinute = addedMinute;
        this.addProcessCallback("addMinute", new ProcessCallback(){

            @Override
            public String callback(String functionExp) {
                return FunctionFilterOption.this.processAddMinute(functionExp);
            }
        });
    }

    protected void doAddSecond(Integer addedSecond) {
        this._addSecond = addedSecond;
        this.addProcessCallback("addSecond", new ProcessCallback(){

            @Override
            public String callback(String functionExp) {
                return FunctionFilterOption.this.processAddSecond(functionExp);
            }
        });
    }

    public String filterFunction(String functionExp) {
        String filtered = functionExp;
        LinkedHashMap<String, ProcessCallback> callbackMap = this._callbackMap;
        if (callbackMap != null) {
            Set<Map.Entry<String, ProcessCallback>> entrySet = callbackMap.entrySet();
            for (Map.Entry<String, ProcessCallback> entry : entrySet) {
                filtered = entry.getValue().callback(filtered);
            }
        }
        return this.processVarious(this.processCalculation(filtered));
    }

    protected void addProcessCallback(String functionKey, ProcessCallback callback) {
        if (this._callbackMap == null) {
            this._callbackMap = new LinkedHashMap();
        }
        if (this._callbackMap.containsKey(functionKey)) {
            String msg = "The function has been already set up: ";
            msg = msg + "function=" + functionKey + "() option=" + this.toString();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._callbackMap.put(functionKey, callback);
    }

    protected String processCoalesce(String functionExp) {
        if (this._coalesce == null) {
            return functionExp;
        }
        if (this._coalesce instanceof String && this.isDateTypeColumn()) {
            this._coalesce = DfTypeUtil.toDate(this._coalesce);
        }
        String functionName = "coalesce";
        String propertyName = "coalesce";
        return this.processSimpleFunction(functionExp, "coalesce", "coalesce", null, false);
    }

    protected String processRound(String functionExp) {
        if (this._round == null) {
            return functionExp;
        }
        String functionName = "round";
        String propertyName = "round";
        return this.processSimpleFunction(functionExp, "round", "round", null, false);
    }

    protected String processTrunc(String functionExp) {
        String processed;
        if (this._trunc == null) {
            return functionExp;
        }
        if (this.isDateTypeColumn() && (processed = this.doProcessTruncPurposeDateType(functionExp)) != null) {
            return processed;
        }
        return this.doProcessTruncSimpleCase(functionExp);
    }

    protected String doProcessTruncPurposeDateType(String functionExp) {
        String processed = this.isDatabaseMySQL() ? this.doProcessTruncPurposeDateTypeMySQL(functionExp) : (this.isDatabasePostgreSQL() ? this.doProcessTruncPurposeDateTypePostgreSQL(functionExp) : (this.isDatabaseOracle() ? this.doProcessTruncPurposeDateTypeOracle(functionExp) : (this.isDatabaseDB2() ? this.doProcessTruncPurposeDateTypeDB2(functionExp) : (this.isDatabaseSQLServer() ? this.doProcessTruncPurposeDateTypeSQLServer(functionExp) : this.doProcessTruncPurposeDateTypeDefault(functionExp)))));
        return processed;
    }

    protected String doProcessTruncPurposeDateTypeMySQL(String functionExp) {
        if (this.isDateTruncMonth()) {
            return "cast(concat(substring(" + functionExp + ", 1, 4), '-01-01') as date)";
        }
        if (this.isDateTruncDay()) {
            return "cast(concat(substring(" + functionExp + ", 1, 7), '-01') as date)";
        }
        if (this.isDateTruncTime()) {
            return "cast(substring(" + functionExp + ", 1, 10) as date)";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypePostgreSQL(String functionExp) {
        if (this.isDateTruncMonth()) {
            this._trunc = "year";
        } else if (this.isDateTruncDay()) {
            this._trunc = "month";
        } else if (this.isDateTruncTime()) {
            this._trunc = "day";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypeOracle(String functionExp) {
        if (this.isDateTruncMonth()) {
            this._trunc = "YYYY";
        } else if (this.isDateTruncDay()) {
            this._trunc = "MM";
        } else if (this.isDateTruncTime()) {
            this._trunc = "DD";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypeDB2(String functionExp) {
        String finalType;
        String baseExp = "cast(to_char(" + functionExp + ", 'yyyy";
        String timePartBasicSuffix = this.isJustDateTypeColumn() ? "" : " 00:00:00";
        String string = finalType = this.isJustDateTypeColumn() ? "date" : "timestamp";
        if (this.isDateTruncMonth()) {
            return baseExp + "') || '-01-01" + timePartBasicSuffix + "' as " + finalType + ")";
        }
        if (this.isDateTruncDay()) {
            return baseExp + "-MM') || '-01" + timePartBasicSuffix + "' as " + finalType + ")";
        }
        if (this.isDateTruncTime()) {
            String timePartConnectSuffix = this.isJustDateTypeColumn() ? "" : " || ' 00:00:00'";
            return baseExp + "-MM-dd')" + timePartConnectSuffix + " as " + finalType + ")";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypeSQLServer(String functionExp) {
        String baseExp = "cast(substring(convert(nvarchar, ";
        String finalType = "datetime";
        if (this.isDateTruncMonth()) {
            return "cast(substring(convert(nvarchar, " + functionExp + ", 120), 1, 4) + '-01-01' as " + "datetime" + ")";
        }
        if (this.isDateTruncDay()) {
            return "cast(substring(convert(nvarchar, " + functionExp + ", 120), 1, 7) + '-01' as " + "datetime" + ")";
        }
        if (this.isDateTruncTime()) {
            return "cast(substring(convert(nvarchar, " + functionExp + ", 120), 1, 10) as " + "datetime" + ")";
        }
        return null;
    }

    protected String doProcessTruncPurposeDateTypeDefault(String functionExp) {
        String baseExp = "cast(substring(";
        String finalType = "date";
        if (this.isDateTruncMonth()) {
            return "cast(substring(" + functionExp + ", 1, 4) || '-01-01' as " + "date" + ")";
        }
        if (this.isDateTruncDay()) {
            return "cast(substring(" + functionExp + ", 1, 7) || '-01' as " + "date" + ")";
        }
        if (this.isDateTruncTime()) {
            return "cast(substring(" + functionExp + ", 1, 10) as " + "date" + ")";
        }
        return null;
    }

    protected boolean isDateTruncMonth() {
        return this._trunc.equals(DATE_TRUNC_MONTH);
    }

    protected boolean isDateTruncDay() {
        return this._trunc.equals(DATE_TRUNC_DAY);
    }

    protected boolean isDateTruncTime() {
        return this._trunc.equals(DATE_TRUNC_TIME);
    }

    protected String doProcessTruncSimpleCase(String functionExp) {
        String functionName;
        String thirdArg = null;
        boolean leftArg = false;
        if (this.isTruncNamedTruncate()) {
            functionName = "truncate";
        } else if (this.isDatabaseSQLServer()) {
            functionName = "round";
            thirdArg = "1";
        } else if (this.isDatabasePostgreSQL() && this.isDateTypeColumn()) {
            functionName = "date_trunc";
            leftArg = true;
        } else {
            functionName = "trunc";
        }
        return this.processSimpleFunction(functionExp, functionName, "trunc", thirdArg, leftArg);
    }

    protected boolean isTruncNamedTruncate() {
        return this.isDatabaseMySQL() || this.isDatabaseH2();
    }

    protected String processAddYear(String functionExp) {
        return this.doProcessDateAdd(functionExp, this._addYear, "addYear");
    }

    protected String processAddMonth(String functionExp) {
        return this.doProcessDateAdd(functionExp, this._addMonth, "addMonth");
    }

    protected String processAddDay(String functionExp) {
        return this.doProcessDateAdd(functionExp, this._addDay, "addDay");
    }

    protected String processAddHour(String functionExp) {
        return this.doProcessDateAdd(functionExp, this._addHour, "addHour");
    }

    protected String processAddMinute(String functionExp) {
        return this.doProcessDateAdd(functionExp, this._addMinute, "addMinute");
    }

    protected String processAddSecond(String functionExp) {
        return this.doProcessDateAdd(functionExp, this._addSecond, "addSecond");
    }

    protected String doProcessDateAdd(String functionExp, Integer addedValue, String propertyName) {
        if (addedValue == null) {
            return functionExp;
        }
        if (!this.isDateTypeColumn()) {
            String msg = "The column should be Date type for the function addXxx():";
            msg = msg + " column=" + this._targetColumnInfo;
            throw new IllegalStateException(msg);
        }
        if (this.isDatabaseMySQL()) {
            return this.doProcessDateAddMySQL(functionExp, addedValue, propertyName);
        }
        if (this.isDatabasePostgreSQL()) {
            return this.doProcessDateAddPostgreSQL(functionExp, addedValue, propertyName);
        }
        if (this.isDatabaseOracle()) {
            return this.doProcessDateAddOracle(functionExp, addedValue, propertyName);
        }
        if (this.isDatabaseDB2()) {
            return this.doProcessDateAddDB2(functionExp, addedValue, propertyName);
        }
        if (this.isDatabaseSQLServer()) {
            return this.doProcessDateAddSQLServer(functionExp, addedValue, propertyName);
        }
        if (this.isDatabaseH2()) {
            return this.doProcessDateAddSQLServer(functionExp, addedValue, propertyName);
        }
        String msg = "Unsupported database to the function addXxx(): " + propertyName;
        throw new IllegalStateException(msg);
    }

    protected String doProcessDateAddMySQL(String functionExp, Integer addedValue, String propertyName) {
        String type = this.buildDateAddExpType(propertyName, null, false);
        String bindParameter = this.buildBindParameter(propertyName);
        return "date_add(" + functionExp + ", interval " + bindParameter + " " + type + ")";
    }

    protected String doProcessDateAddPostgreSQL(String functionExp, Integer addedValue, String propertyName) {
        String type = this.buildDateAddExpType(propertyName, null, true);
        if (this.isJustDateTypeColumn()) {
            return "cast(" + functionExp + " as timestamp) + '" + addedValue + " " + type + "'";
        }
        return functionExp + " + '" + addedValue + " " + type + "'";
    }

    protected String doProcessDateAddOracle(String functionExp, Integer addedValue, String propertyName) {
        String bindParameter = this.buildBindParameter(propertyName);
        if (this.isPropertyAddYear(propertyName)) {
            return "add_months(" + functionExp + ", 12 * " + bindParameter + ")";
        }
        if (this.isPropertyAddMonth(propertyName)) {
            return "add_months(" + functionExp + ", " + bindParameter + ")";
        }
        if (this.isPropertyAddDay(propertyName)) {
            return functionExp + " + " + bindParameter;
        }
        if (this.isPropertyAddHour(propertyName)) {
            return functionExp + " + " + bindParameter + " / 24";
        }
        if (this.isPropertyAddMinute(propertyName)) {
            return functionExp + " + " + bindParameter + " / 1440";
        }
        if (this.isPropertyAddSecond(propertyName)) {
            return functionExp + " + " + bindParameter + " / 86400";
        }
        String msg = "Unknown property for date-add: " + propertyName;
        throw new IllegalStateException(msg);
    }

    protected String doProcessDateAddDB2(String functionExp, Integer addedValue, String propertyName) {
        String bindParameter = this.buildBindParameter(propertyName);
        String type = this.buildDateAddExpType(propertyName, null, false);
        return functionExp + " + " + bindParameter + " " + type;
    }

    protected String doProcessDateAddSQLServer(String functionExp, Integer addedValue, String propertyName) {
        String type = this.buildDateAddExpType(propertyName, null, false);
        return "dateadd(" + type + ", " + addedValue + ", " + functionExp + ")";
    }

    protected String buildDateAddExpType(String propertyName, String prefix, boolean plural) {
        String type;
        String suffix;
        prefix = prefix != null ? prefix : "";
        String string = suffix = plural ? "s" : "";
        if (this.isPropertyAddYear(propertyName)) {
            type = prefix + "year" + suffix;
        } else if (this.isPropertyAddMonth(propertyName)) {
            type = prefix + "month" + suffix;
        } else if (this.isPropertyAddDay(propertyName)) {
            type = prefix + "day" + suffix;
        } else if (this.isPropertyAddHour(propertyName)) {
            type = prefix + "hour" + suffix;
        } else if (this.isPropertyAddMinute(propertyName)) {
            type = prefix + "minute" + suffix;
        } else if (this.isPropertyAddSecond(propertyName)) {
            type = prefix + "second" + suffix;
        } else {
            String msg = "Unknown property for date-add: " + propertyName;
            throw new IllegalStateException(msg);
        }
        return type;
    }

    protected boolean isPropertyAddYear(String propertyName) {
        return "addYear".equals(propertyName);
    }

    protected boolean isPropertyAddMonth(String propertyName) {
        return "addMonth".equals(propertyName);
    }

    protected boolean isPropertyAddDay(String propertyName) {
        return "addDay".equals(propertyName);
    }

    protected boolean isPropertyAddHour(String propertyName) {
        return "addHour".equals(propertyName);
    }

    protected boolean isPropertyAddMinute(String propertyName) {
        return "addMinute".equals(propertyName);
    }

    protected boolean isPropertyAddSecond(String propertyName) {
        return "addSecond".equals(propertyName);
    }

    protected String processCalculation(String functionExp) {
        return functionExp;
    }

    protected String processVarious(String functionExp) {
        return functionExp;
    }

    protected String processSimpleFunction(String functionExp, String functionName, String propertyName, String thirdArg, boolean leftArg) {
        String pureFunction;
        String bindParameter = this.buildBindParameter(propertyName);
        StringBuilder sb = new StringBuilder();
        sb.append(functionName).append("(");
        String sqend = "--#df:sqend#";
        boolean handleSqEnd = this.hasSubQueryEndOnLastLine(functionExp);
        String string = pureFunction = handleSqEnd ? Srl.substringLastFront(functionExp, "--#df:sqend#") : functionExp;
        if (leftArg) {
            sb.append(bindParameter);
            if (handleSqEnd) {
                sb.append(this.ln()).append("       ");
            }
            sb.append(", ").append(pureFunction);
        } else {
            sb.append(pureFunction).append(", ").append(bindParameter);
        }
        if (Srl.is_NotNull_and_NotTrimmedEmpty(thirdArg)) {
            sb.append(", ").append(thirdArg);
        }
        sb.append(")");
        if (handleSqEnd) {
            sb.append("--#df:sqend#").append(Srl.substringLastRear(functionExp, "--#df:sqend#"));
        }
        return sb.toString();
    }

    protected boolean hasSubQueryEndOnLastLine(String functionExp) {
        return SubQueryIndentProcessor.hasSubQueryEndOnLastLine(functionExp);
    }

    protected String buildBindParameter(String propertyName) {
        return "/*pmb." + this._parameterMapPath + "." + this._parameterKey + "." + propertyName + "*/null";
    }

    protected boolean isDateTypeColumn() {
        return this._targetColumnInfo != null && this._targetColumnInfo.isObjectNativeTypeDate();
    }

    protected boolean isJustDateTypeColumn() {
        return this._targetColumnInfo != null && this._targetColumnInfo.isObjectNativeTypeJustDate();
    }

    @Override
    public void acceptParameterKey(String parameterKey, String parameterMapPath) {
        this._parameterKey = parameterKey;
        this._parameterMapPath = parameterMapPath;
    }

    public SpecifyDerivedReferrer createSpecifyDerivedReferrer(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQueryClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager, String mainSubQueryIdentity, String aliasName) {
        return new SpecifyDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, cipherManager, mainSubQueryIdentity, aliasName);
    }

    public QueryDerivedReferrer createQueryDerivedReferrer(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQueryClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager, String mainSubQueryIdentity, String operand, Object value, String parameterPath) {
        return new QueryDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, cipherManager, mainSubQueryIdentity, operand, value, parameterPath);
    }

    public boolean mayNullRevived() {
        return this._coalesce != null;
    }

    protected final String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCalculationColumnNumber(HpSpecifiedColumn specifiedColumn) {
        ColumnInfo columnInfo = specifiedColumn.getColumnInfo();
        if (columnInfo == null) {
            return;
        }
        if (!columnInfo.isObjectNativeTypeNumber()) {
            String msg = "The type of the calculation column should be Number: " + specifiedColumn;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertSpecifiedDreamCruiseTicket(HpSpecifiedColumn column) {
        if (!column.isDreamCruiseTicket()) {
            String msg = "The specified column was not dream cruise ticket: " + column;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        return title + ":{coalesce=" + this._coalesce + ", round=" + this._round + ", trunc=" + this._trunc + "}";
    }

    public Object getCoalesce() {
        return this._coalesce;
    }

    public Object getRound() {
        return this._round;
    }

    public Object getTrunc() {
        return this._trunc;
    }

    public Object getAddYear() {
        return this._addYear;
    }

    public Object getAddMonth() {
        return this._addMonth;
    }

    public Object getAddDay() {
        return this._addDay;
    }

    public Object getAddHour() {
        return this._addHour;
    }

    public Object getAddMinute() {
        return this._addMinute;
    }

    public Object getAddSecond() {
        return this._addSecond;
    }

    public void xsetTargetColumnInfo(ColumnInfo targetColumnInfo) {
        this._targetColumnInfo = targetColumnInfo;
    }

    public void xjudgeDatabase(SqlClause sqlClause) {
        this.setDatabaseMySQL(sqlClause instanceof SqlClauseMySql);
        this.setDatabasePostgreSQL(sqlClause instanceof SqlClausePostgreSql);
        this.setDatabaseOracle(sqlClause instanceof SqlClauseOracle);
        this.setDatabaseDB2(sqlClause instanceof SqlClauseDb2);
        this.setDatabaseSQLServer(sqlClause instanceof SqlClauseSqlServer);
        this.setDatabaseH2(sqlClause instanceof SqlClauseH2);
        this.setDatabaseDerby(sqlClause instanceof SqlClauseDerby);
    }

    protected boolean isDatabaseMySQL() {
        return this._databaseMySQL;
    }

    protected void setDatabaseMySQL(boolean databaseMySQL) {
        this._databaseMySQL = databaseMySQL;
    }

    protected boolean isDatabasePostgreSQL() {
        return this._databasePostgreSQL;
    }

    protected void setDatabasePostgreSQL(boolean databasePostgreSQL) {
        this._databasePostgreSQL = databasePostgreSQL;
    }

    protected boolean isDatabaseOracle() {
        return this._databaseOracle;
    }

    protected void setDatabaseOracle(boolean databaseOracle) {
        this._databaseOracle = databaseOracle;
    }

    protected boolean isDatabaseDB2() {
        return this._databaseDB2;
    }

    protected void setDatabaseDB2(boolean databaseDB2) {
        this._databaseDB2 = databaseDB2;
    }

    protected boolean isDatabaseSQLServer() {
        return this._databaseSQLServer;
    }

    protected void setDatabaseSQLServer(boolean databaseSQLServer) {
        this._databaseSQLServer = databaseSQLServer;
    }

    protected boolean isDatabaseH2() {
        return this._databaseH2;
    }

    protected void setDatabaseH2(boolean databaseH2) {
        this._databaseH2 = databaseH2;
    }

    protected boolean isDatabaseDerby() {
        return this._databaseDerby;
    }

    protected void setDatabaseDerby(boolean databaseDerby) {
        this._databaseDerby = databaseDerby;
    }

    protected static interface ProcessCallback {
        public String callback(String var1);
    }
}

