/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.suggest.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.solr.update.TransactionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionLogUtil {
    private static final Logger logger = LoggerFactory.getLogger(TransactionLogUtil.class);
    private static final String PREFIX = "suggest-";
    private static Constructor<TransactionLog> transactionLogConstructor;

    private TransactionLogUtil() {
    }

    public static TransactionLog createSuggestTransactionLog(File tlogFile, Collection<String> globalStrings, boolean openExisting) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IOException, InvocationTargetException {
        long start = System.currentTimeMillis();
        File file = new File(tlogFile.getParent(), PREFIX + tlogFile.getName());
        Files.copy((File)tlogFile, (File)file);
        if (logger.isInfoEnabled()) {
            logger.info("Create suggest trans log. took=" + (System.currentTimeMillis() - start) + " file=" + file.getAbsolutePath());
        }
        return transactionLogConstructor.newInstance(file, globalStrings, openExisting);
    }

    public static void clearSuggestTransactionLog(String dir) {
        File d = new File(dir);
        if (!d.isDirectory()) {
            return;
        }
        for (File f : d.listFiles()) {
            if (!f.isFile() || !f.getName().startsWith(PREFIX) || f.delete()) continue;
            logger.warn("Failed to delete " + f.getAbsolutePath());
        }
    }

    static {
        try {
            Class<TransactionLog> cls = TransactionLog.class;
            transactionLogConstructor = cls.getDeclaredConstructor(File.class, Collection.class, Boolean.TYPE);
            transactionLogConstructor.setAccessible(true);
        }
        catch (Exception e) {
            logger.error("Failed to load TransactionLog class.", (Throwable)e);
        }
    }
}

