/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.util;

import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.fess.suggest.converter.SuggestReadingConverter;
import jp.sf.fess.suggest.normalizer.SuggestNormalizer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SuggestUtil {
    private static final Logger logger = LoggerFactory.getLogger(SuggestUtil.class);

    private SuggestUtil() {
    }

    public static SuggestReadingConverter createConverter(String className, Map<String, String> properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        Class<?> cls = Class.forName(className);
        Object obj = cls.newInstance();
        if (!(obj instanceof SuggestReadingConverter)) {
            throw new IllegalArgumentException("Not converter. " + className);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String fieldName = entry.getKey();
            String fieldValue = entry.getValue();
            Field field = cls.getField(fieldName);
            field.set(obj, fieldValue);
        }
        return (SuggestReadingConverter)obj;
    }

    public static SuggestNormalizer createNormalizer(String className, Map<String, String> properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        Class<?> cls = Class.forName(className);
        Object obj = cls.newInstance();
        if (!(obj instanceof SuggestNormalizer)) {
            throw new IllegalArgumentException("Not normalizer. " + className);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String fieldName = entry.getKey();
            String fieldValue = entry.getValue();
            Field field = cls.getField(fieldName);
            field.set(obj, fieldValue);
        }
        return (SuggestNormalizer)obj;
    }

    public static Map<String, String> parseSolrParams(String solrParams) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params = solrParams.split("&")) {
            String value;
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            try {
                value = URLDecoder.decode(keyValue[1], "UTF-8");
            }
            catch (Exception e) {
                value = keyValue[1];
            }
            if (!StringUtils.isNotBlank((String)key) || !StringUtils.isNotBlank((String)value)) continue;
            map.put(key, value);
        }
        return map;
    }

    public static List<String> parseQuery(String query, String field) {
        String[] elems;
        ArrayList<String> words = new ArrayList<String>();
        for (String elem : elems = query.replace("(", " ").replace(")", " ").replaceAll(" +", " ").trim().split(" ")) {
            String[] pair;
            if (elem.indexOf(":") == -1 || (pair = elem.split(":")).length != 2 || !field.equals(pair[0]) || words.contains(pair[1])) continue;
            words.add(pair[1]);
        }
        return words;
    }
}

