/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.ckey;

import java.util.List;
import org.seasar.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;

public class ConditionKeyLessThan
extends ConditionKey {
    private static final long serialVersionUID = 1L;

    protected ConditionKeyLessThan() {
        this.initializeConditionKey();
        this.initializeOperand();
    }

    protected void initializeConditionKey() {
        this._conditionKey = "lessThan";
    }

    protected void initializeOperand() {
        this._operand = "<";
    }

    @Override
    protected boolean doPrepareQuery(ConditionValue cvalue, Object value, ColumnRealName callerName) {
        if (value == null) {
            return false;
        }
        if (this.needsOverrideValue(cvalue)) {
            if (cvalue.equalLessThan(value)) {
                this.noticeRegistered(callerName, value);
                return false;
            }
            cvalue.overrideLessThan(value);
            return false;
        }
        return true;
    }

    @Override
    public boolean needsOverrideValue(ConditionValue cvalue) {
        return cvalue.isFixedQuery() && cvalue.hasLessThan();
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value, ColumnFunctionCipher cipher, ConditionOption option) {
        conditionList.add(this.buildBindClause(columnRealName, value.getLessThanLatestLocation(), cipher, option));
    }

    @Override
    protected void doSetupConditionValue(ConditionValue cvalue, Object value, String location, ConditionOption option) {
        cvalue.setupLessThan(value, location);
    }
}

