/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.ckey;

import java.util.List;
import org.seasar.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;

public class ConditionKeyLessEqual
extends ConditionKey {
    private static final long serialVersionUID = 1L;

    protected ConditionKeyLessEqual() {
        this.initializeConditionKey();
        this.initializeOperand();
    }

    protected void initializeConditionKey() {
        this._conditionKey = "lessEqual";
    }

    protected void initializeOperand() {
        this._operand = "<=";
    }

    @Override
    protected boolean doPrepareQuery(ConditionValue cvalue, Object value, ColumnRealName callerName) {
        if (value == null) {
            return false;
        }
        if (this.needsOverrideValue(cvalue)) {
            if (cvalue.equalLessEqual(value)) {
                this.noticeRegistered(callerName, value);
                return false;
            }
            cvalue.overrideLessEqual(value);
            return false;
        }
        return true;
    }

    @Override
    public boolean needsOverrideValue(ConditionValue cvalue) {
        return cvalue.isFixedQuery() && cvalue.hasLessEqual();
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value, ColumnFunctionCipher cipher, ConditionOption option) {
        conditionList.add(this.buildBindClause(columnRealName, value.getLessEqualLatestLocation(), cipher, option));
    }

    @Override
    protected void doSetupConditionValue(ConditionValue cvalue, Object value, String location, ConditionOption option) {
        cvalue.setupLessEqual(value, location);
    }
}

