/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.logging.invoke;

import java.util.List;
import org.seasar.dbflute.bhv.logging.invoke.ClientInvokeNameResult;
import org.seasar.dbflute.bhv.logging.invoke.InvokeNameExtractingCoinLogic;
import org.seasar.dbflute.helper.stacktrace.InvokeNameExtractingResource;
import org.seasar.dbflute.helper.stacktrace.InvokeNameResult;

public class ClientInvokeNameExtractor {
    protected final List<String> _suffixList;
    protected final int _startIndex;
    protected final InvokeNameExtractingCoinLogic _coinLogic = this.createInvokeNameExtractingCoinLogic();

    protected InvokeNameExtractingCoinLogic createInvokeNameExtractingCoinLogic() {
        return new InvokeNameExtractingCoinLogic();
    }

    public ClientInvokeNameExtractor(List<String> suffixList, int startIndex) {
        this._suffixList = suffixList;
        this._startIndex = startIndex;
    }

    public ClientInvokeNameResult extractClientInvoke(StackTraceElement[] stackTrace) {
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            @Override
            public boolean isTargetElement(String className, String methodName) {
                return ClientInvokeNameExtractor.this.isClassNameEndsWith(className, ClientInvokeNameExtractor.this._suffixList);
            }

            @Override
            public String filterSimpleClassName(String simpleClassName) {
                return simpleClassName;
            }

            @Override
            public boolean isUseAdditionalInfo() {
                return true;
            }

            @Override
            public int getStartIndex() {
                return ClientInvokeNameExtractor.this._startIndex;
            }

            @Override
            public int getLoopSize() {
                return ClientInvokeNameExtractor.this.getInvocationExtractingMaxLoopSize();
            }
        };
        List<InvokeNameResult> invokeNameResultList = this.extractInvokeName(resource, stackTrace);
        return new ClientInvokeNameResult(invokeNameResultList);
    }

    protected int getInvocationExtractingMaxLoopSize() {
        return 20;
    }

    protected List<InvokeNameResult> extractInvokeName(InvokeNameExtractingResource resource, StackTraceElement[] stackTrace) {
        return this._coinLogic.extractInvokeName(resource, stackTrace);
    }

    protected boolean isClassNameEndsWith(String className, List<String> suffixList) {
        return this._coinLogic.isClassNameEndsWith(className, suffixList);
    }

    protected boolean isClassNameContains(String className, List<String> keywordList) {
        return this._coinLogic.isClassNameContains(className, keywordList);
    }
}

