/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest;

import java.util.ArrayList;
import java.util.List;
import jp.sf.fess.suggest.converter.SuggestReadingConverter;
import jp.sf.fess.suggest.normalizer.SuggestNormalizer;
import org.apache.solr.client.solrj.util.ClientUtils;

public class SpellChecker {
    private static final String _AND_ = " AND ";
    private static final String _OR_ = " OR ";
    public float fuzzyValue = 0.5f;
    private SuggestReadingConverter converter = null;
    private SuggestNormalizer normalizer = null;

    public void setFuzzyValue(float fuzzyValue) {
        this.fuzzyValue = fuzzyValue;
    }

    public void setConverter(SuggestReadingConverter converter) {
        this.converter = converter;
    }

    public void setNormalizer(SuggestNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public String buildSpellCheckQuery(String query, List<String> targetFields, List<String> labels, List<String> roles) {
        return this.buildSpellCheckQuery(query, this.fuzzyValue, targetFields, labels, roles);
    }

    public String buildSpellCheckQuery(String query, float fuzzy, List<String> targetFields, List<String> labels, List<String> roles) {
        boolean isFirst;
        StringBuilder queryBuf = new StringBuilder();
        String q = query;
        if (this.normalizer != null) {
            q = this.normalizer.normalize(q);
        }
        q = ClientUtils.escapeQueryChars((String)q.trim());
        List<Object> readingList = new ArrayList<String>();
        if (this.converter != null) {
            readingList = this.converter.convert(q);
        } else {
            readingList.add(q);
        }
        if (readingList.isEmpty()) {
            queryBuf.append("reading_s_m").append(':').append(q);
        } else {
            queryBuf.append("reading_s_m").append(':').append((String)readingList.get(0));
        }
        queryBuf.append('~').append(fuzzy);
        if (targetFields != null && !targetFields.isEmpty()) {
            queryBuf.append(_AND_);
            if (targetFields.size() >= 2) {
                queryBuf.append("(");
            }
            for (int i = 0; i < targetFields.size(); ++i) {
                String fieldName = targetFields.get(i);
                if (i > 0) {
                    queryBuf.append(_OR_);
                }
                queryBuf.append("fieldname_s_m");
                queryBuf.append(':');
                queryBuf.append(fieldName);
            }
            if (targetFields.size() >= 2) {
                queryBuf.append(')');
            }
        }
        if (labels != null && !labels.isEmpty()) {
            queryBuf.append(_AND_);
            if (labels.size() >= 2) {
                queryBuf.append('(');
            }
            isFirst = true;
            for (String label : labels) {
                if (!isFirst) {
                    queryBuf.append(_OR_);
                }
                queryBuf.append("label_s_m");
                queryBuf.append(':');
                queryBuf.append(label);
                isFirst = false;
            }
            if (labels.size() >= 2) {
                queryBuf.append(')');
            }
        }
        if (roles != null && !roles.isEmpty()) {
            queryBuf.append(_AND_);
            if (roles.size() >= 2) {
                queryBuf.append('(');
            }
            isFirst = true;
            for (String role : roles) {
                if (!isFirst) {
                    queryBuf.append(_OR_);
                }
                queryBuf.append("role_s_m");
                queryBuf.append(':');
                queryBuf.append(role);
                isFirst = false;
            }
            if (roles.size() >= 2) {
                queryBuf.append(')');
            }
        }
        return queryBuf.toString();
    }
}

