/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

public class DynamicHuffman
implements Cloneable {
    public static final int ROOT = 0;
    private static final int MAX_WEIGHT = 32768;
    private int[] weight;
    private int[] child;
    private int[] parent;
    private int[] leafs;
    private int size;

    private DynamicHuffman() {
    }

    public DynamicHuffman(int n) {
        this(n, n);
    }

    public DynamicHuffman(int n, int n2) {
        if (1 <= n2 && n2 <= n) {
            int n3;
            this.weight = new int[n * 2 - 1];
            this.child = new int[n * 2 - 1];
            this.parent = new int[n * 2 - 1];
            this.leafs = new int[n];
            this.size = Math.max(0, n2 * 2 - 1);
            int n4 = this.size - 1;
            for (n3 = 0; n3 < n2; ++n3) {
                this.weight[n4] = 1;
                this.child[n4] = ~n3;
                this.leafs[n3] = n4--;
            }
            for (n3 = this.size - 1; 0 <= n4 && n4 != n3; n3 -= 2) {
                this.weight[n4] = this.weight[n3] + this.weight[n3 - 1];
                this.child[n4] = n3;
                int n5 = n4--;
                this.parent[n3 - 1] = n5;
                this.parent[n3] = n5;
            }
        } else {
            if (n < n2) {
                throw new IllegalArgumentException("\"max\" must be larger than \"first\".");
            }
            throw new IllegalArgumentException("\"first\" must be one or more.");
        }
    }

    public Object clone() {
        DynamicHuffman dynamicHuffman = new DynamicHuffman();
        dynamicHuffman.weight = (int[])this.weight.clone();
        dynamicHuffman.child = (int[])this.child.clone();
        dynamicHuffman.parent = (int[])this.parent.clone();
        dynamicHuffman.leafs = (int[])this.leafs.clone();
        dynamicHuffman.size = this.size;
        return dynamicHuffman;
    }

    public int codeToNode(int n) {
        return this.leafs[n];
    }

    public int childNode(int n) {
        return this.child[n];
    }

    public int parentNode(int n) {
        return this.parent[n];
    }

    public void update(int n) {
        if (this.weight[0] == 32768) {
            this.rebuildTree();
        }
        int n2 = this.leafs[n];
        while (0 != n2) {
            int n3 = n2;
            while (this.weight[n3 - 1] == this.weight[n2] && 0 < n3 - 1) {
                --n3;
            }
            if (n2 != n3) {
                this.swap(n2, n3);
            }
            int n4 = n3;
            this.weight[n4] = this.weight[n4] + 1;
            n2 = this.parent[n3];
        }
        this.weight[0] = this.weight[0] + 1;
    }

    public void addLeaf(int n) {
        if (this.size < this.weight.length - 1) {
            int n2 = this.size - 1;
            int n3 = this.size;
            int n4 = this.size + 1;
            this.child[n3] = this.child[n2];
            this.child[n4] = ~n;
            this.child[n2] = n4;
            this.weight[n3] = this.weight[n2];
            this.weight[n4] = 0;
            this.leafs[this.child[n3] ^ 0xFFFFFFFF] = n3;
            this.leafs[this.child[n4] ^ 0xFFFFFFFF] = n4;
            this.parent[n3] = this.parent[n4] = n2;
            this.size = n4 + 1;
            if (n2 == 0) {
                int n5 = n2;
                this.weight[n5] = this.weight[n5] - 1;
            }
        } else {
            throw new IllegalStateException();
        }
        this.update(n);
    }

    private void rebuildTree() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.size; ++n) {
            if (this.child[n] >= 0) continue;
            this.weight[n2] = (this.weight[n] + 1) / 2;
            this.child[n2] = this.child[n];
            ++n2;
        }
        --n2;
        n = this.size - 1;
        int n3 = this.size - 2;
        while (0 <= n) {
            while (n3 <= n) {
                this.leafs[this.child[n2] ^ 0xFFFFFFFF] = n;
                this.weight[n] = this.weight[n2];
                this.child[n--] = this.child[n2--];
            }
            int n4 = this.weight[n3] + this.weight[n3 + 1];
            while (0 <= n2 && this.weight[n2] <= n4) {
                this.leafs[this.child[n2] ^ 0xFFFFFFFF] = n;
                this.weight[n] = this.weight[n2];
                this.child[n--] = this.child[n2--];
            }
            this.weight[n] = n4;
            this.child[n] = n3 + 1;
            int n5 = n--;
            this.parent[n3 + 1] = n5;
            this.parent[n3] = n5;
            n3 -= 2;
        }
    }

    private void swap(int n, int n2) {
        if (this.child[n] < 0) {
            this.leafs[this.child[n] ^ 0xFFFFFFFF] = n2;
        } else {
            int n3 = n2;
            this.parent[this.child[n] - 1] = n3;
            this.parent[this.child[n]] = n3;
        }
        if (this.child[n2] < 0) {
            this.leafs[this.child[n2] ^ 0xFFFFFFFF] = n;
        } else {
            int n4 = n;
            this.parent[this.child[n2] - 1] = n4;
            this.parent[this.child[n2]] = n4;
        }
        int n5 = this.child[n];
        this.child[n] = this.child[n2];
        this.child[n2] = n5;
        n5 = this.weight[n];
        this.weight[n] = this.weight[n2];
        this.weight[n2] = n5;
    }
}

