/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util;

import java.util.Date;

public class MsdosDate
extends Date
implements Cloneable {
    public MsdosDate(Date date) {
        super(date.getTime() / 2000L * 2000L);
        this.checkRange();
    }

    public MsdosDate(int n) {
        super((n >> 25 & 0x7F) + 80, (n >> 21 & 0xF) - 1, n >> 16 & 0x1F, n >> 11 & 0x1F, n >> 5 & 0x3F, n << 1 & 0x3F);
        this.checkRange();
    }

    public Object clone() {
        return new MsdosDate(this);
    }

    public void setYear(int n) {
        if (n < 80 || 207 < n) {
            throw new IllegalArgumentException("out of MS-DOS time format range.");
        }
        super.setYear(n);
    }

    public void setTime(long l) {
        int n = new Date(l).getYear();
        if (n < 80 || 207 < n) {
            throw new IllegalArgumentException("out of MS-DOS time format range.");
        }
        super.setTime(l / 2000L * 2000L);
    }

    public void setMsdosTime(int n) {
        Date date = new Date((n >> 25 & 0x7F) + 80, (n >> 21 & 0xF) - 1, n >> 16 & 0x1F, n >> 11 & 0x1F, n >> 5 & 0x3F, n << 1 & 0x3F);
        this.setTime(date.getTime());
    }

    public int getMsdosTime() {
        return super.getYear() - 80 << 25 | super.getMonth() + 1 << 21 | super.getDate() << 16 | super.getHours() << 11 | super.getMinutes() << 5 | super.getSeconds() >> 1;
    }

    private void checkRange() {
        int n = this.getYear();
        if (n < 80 || 207 < n) {
            throw new IllegalArgumentException("out of MS-DOS time format range.");
        }
    }
}

