/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.DoubleByteProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractDoubleByteMap
extends AbstractSet {
    public boolean containsKey(final double key) {
        return !this.forEachKey(new DoubleProcedure(){

            public boolean apply(double iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final byte value) {
        return !this.forEachPair(new DoubleByteProcedure(){

            public boolean apply(double iterKey, byte iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractDoubleByteMap copy() {
        return (AbstractDoubleByteMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractDoubleByteMap)) {
            return false;
        }
        final AbstractDoubleByteMap other = (AbstractDoubleByteMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new DoubleByteProcedure(){

            public boolean apply(double key, byte value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new DoubleByteProcedure(){

            public boolean apply(double key, byte value) {
                return AbstractDoubleByteMap.this.containsKey(key) && AbstractDoubleByteMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(DoubleProcedure var1);

    public boolean forEachPair(final DoubleByteProcedure procedure) {
        return this.forEachKey(new DoubleProcedure(){

            public boolean apply(double key) {
                return procedure.apply(key, AbstractDoubleByteMap.this.get(key));
            }
        });
    }

    public abstract byte get(double var1);

    public DoubleArrayList keys() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(DoubleArrayList keyList) {
        this.pairsSortedByValue(keyList, new ByteArrayList(this.size()));
    }

    public void pairsMatching(final DoubleByteProcedure condition, final DoubleArrayList keyList, final ByteArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new DoubleByteProcedure(){

            public boolean apply(double key, byte value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(DoubleArrayList keyList, ByteArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(DoubleArrayList keyList, ByteArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final double[] k = keyList.elements();
        final byte[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                byte t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                double t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(double var1, byte var3);

    public abstract boolean removeKey(double var1);

    public String toString() {
        DoubleArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            double key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        DoubleArrayList theKeys = new DoubleArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            double key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public ByteArrayList values() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double key) {
                list.add(AbstractDoubleByteMap.this.get(key));
                return true;
            }
        });
    }

    public byte adjustOrPutValue(double key, byte newValue, byte incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (byte)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

