/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchHandler
extends RequestHandlerBase
implements SolrCoreAware,
PluginInfoInitialized {
    static final String INIT_COMPONENTS = "components";
    static final String INIT_FIRST_COMPONENTS = "first-components";
    static final String INIT_LAST_COMPONENTS = "last-components";
    protected static Logger log = LoggerFactory.getLogger(SearchHandler.class);
    protected List<SearchComponent> components = null;
    private ShardHandlerFactory shardHandlerFactory;
    private PluginInfo shfInfo;

    protected List<String> getDefaultComponents() {
        ArrayList<String> names = new ArrayList<String>(6);
        names.add("query");
        names.add("facet");
        names.add("mlt");
        names.add("highlight");
        names.add("stats");
        names.add("debug");
        names.add("expand");
        return names;
    }

    @Override
    public void init(PluginInfo info) {
        this.init(info.initArgs);
        for (PluginInfo child : info.children) {
            if (!"shardHandlerFactory".equals(child.type)) continue;
            this.shfInfo = child;
            break;
        }
    }

    @Override
    public void inform(SolrCore core) {
        Object declaredComponents = this.initArgs.get(INIT_COMPONENTS);
        List first = (List)this.initArgs.get(INIT_FIRST_COMPONENTS);
        List last = (List)this.initArgs.get(INIT_LAST_COMPONENTS);
        List list = null;
        boolean makeDebugLast = true;
        if (declaredComponents == null) {
            list = this.getDefaultComponents();
            if (first != null) {
                List clist = first;
                clist.addAll(list);
                list = clist;
            }
            if (last != null) {
                list.addAll(last);
            }
        } else {
            list = (List)declaredComponents;
            if (first != null || last != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "First/Last components only valid if you do not declare 'components'");
            }
            makeDebugLast = false;
        }
        this.components = new ArrayList<SearchComponent>(list.size());
        DebugComponent dbgCmp = null;
        for (String c : list) {
            SearchComponent comp = core.getSearchComponent(c);
            if (comp instanceof DebugComponent && makeDebugLast) {
                dbgCmp = (DebugComponent)comp;
                continue;
            }
            this.components.add(comp);
            log.debug("Adding  component:" + comp);
        }
        if (makeDebugLast && dbgCmp != null) {
            this.components.add(dbgCmp);
            log.debug("Adding  debug component:" + dbgCmp);
        }
        if (this.shfInfo == null) {
            this.shardHandlerFactory = core.getCoreDescriptor().getCoreContainer().getShardHandlerFactory();
        } else {
            this.shardHandlerFactory = core.createInitInstance(this.shfInfo, ShardHandlerFactory.class, null, null);
            core.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                    SearchHandler.this.shardHandlerFactory.close();
                }

                @Override
                public void postClose(SolrCore core) {
                }
            });
        }
    }

    public List<SearchComponent> getComponents() {
        return this.components;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        RTimer subt;
        if (req.getContentStreams() != null && req.getContentStreams().iterator().hasNext()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Search requests cannot accept content streams");
        }
        ResponseBuilder rb = new ResponseBuilder(req, rsp, this.components);
        if (rb.requestInfo != null) {
            rb.requestInfo.setResponseBuilder(rb);
        }
        boolean dbg = req.getParams().getBool("debugQuery", false);
        rb.setDebug(dbg);
        if (!dbg) {
            SolrPluginUtils.getDebugInterests(req.getParams().getParams("debug"), rb);
        }
        RTimer timer = rb.isDebug() ? new RTimer() : null;
        ShardHandler shardHandler1 = this.shardHandlerFactory.getShardHandler();
        shardHandler1.checkDistributed(rb);
        if (timer == null) {
            for (SearchComponent c : this.components) {
                c.prepare(rb);
            }
        } else {
            subt = timer.sub("prepare");
            for (SearchComponent c : this.components) {
                rb.setTimer(subt.sub(c.getName()));
                c.prepare(rb);
                rb.getTimer().stop();
            }
            subt.stop();
        }
        if (!rb.isDistrib) {
            if (!rb.isDebug()) {
                for (SearchComponent c : this.components) {
                    c.process(rb);
                }
            } else {
                subt = timer.sub("process");
                for (SearchComponent c : this.components) {
                    rb.setTimer(subt.sub(c.getName()));
                    c.process(rb);
                    rb.getTimer().stop();
                }
                subt.stop();
                timer.stop();
                if (rb.isDebugTimings()) {
                    rb.addDebugInfo("timing", timer.asNamedList());
                }
            }
        } else {
            if (rb.outgoing == null) {
                rb.outgoing = new LinkedList<ShardRequest>();
            }
            rb.finished = new ArrayList<ShardRequest>();
            int nextStage = 0;
            do {
                rb.stage = nextStage;
                nextStage = ResponseBuilder.STAGE_DONE;
                for (SearchComponent c : this.components) {
                    nextStage = Math.min(nextStage, c.distributedProcess(rb));
                }
                while (rb.outgoing.size() > 0) {
                    ShardResponse srsp;
                    while (rb.outgoing.size() > 0) {
                        ShardRequest sreq = rb.outgoing.remove(0);
                        sreq.actualShards = sreq.shards;
                        if (sreq.actualShards == ShardRequest.ALL_SHARDS) {
                            sreq.actualShards = rb.shards;
                        }
                        sreq.responses = new ArrayList<ShardResponse>();
                        for (String shard : sreq.actualShards) {
                            String shardQt;
                            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)sreq.params);
                            params.remove("shards");
                            params.set("distrib", new String[]{"false"});
                            params.remove("indent");
                            params.remove("echoParams");
                            params.set("isShard", true);
                            params.set("shard.url", new String[]{shard});
                            if (rb.requestInfo != null) {
                                params.set("NOW", new String[]{Long.toString(rb.requestInfo.getNOW().getTime())});
                            }
                            if ((shardQt = params.get("shards.qt")) == null) {
                                params.remove("qt");
                            } else {
                                params.set("qt", new String[]{shardQt});
                            }
                            shardHandler1.submit(sreq, shard, params);
                        }
                    }
                    boolean tolerant = rb.req.getParams().getBool("shards.tolerant", false);
                    while (rb.outgoing.size() == 0 && (srsp = tolerant ? shardHandler1.takeCompletedIncludingErrors() : shardHandler1.takeCompletedOrError()) != null) {
                        if (srsp.getException() != null) {
                            if (!tolerant) {
                                shardHandler1.cancelAll();
                                if (srsp.getException() instanceof SolrException) {
                                    throw (SolrException)srsp.getException();
                                }
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, srsp.getException());
                            }
                            if (rsp.getResponseHeader().get("partialResults") == null) {
                                rsp.getResponseHeader().add("partialResults", (Object)Boolean.TRUE);
                            }
                        }
                        rb.finished.add(srsp.getShardRequest());
                        for (SearchComponent c : this.components) {
                            c.handleResponses(rb, srsp.getShardRequest());
                        }
                    }
                }
                for (SearchComponent c : this.components) {
                    c.finishStage(rb);
                }
            } while (nextStage != Integer.MAX_VALUE);
        }
        if (!rb.isDistrib && req.getParams().getBool("shards.info", false) && rb.shortCircuitedURL != null) {
            SimpleOrderedMap shardInfo = new SimpleOrderedMap();
            SimpleOrderedMap nl = new SimpleOrderedMap();
            if (rsp.getException() != null) {
                Throwable cause = rsp.getException();
                if (cause instanceof SolrServerException) {
                    cause = ((SolrServerException)cause).getRootCause();
                } else if (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                nl.add("error", (Object)cause.toString());
                StringWriter trace = new StringWriter();
                cause.printStackTrace(new PrintWriter(trace));
                nl.add("trace", (Object)trace.toString());
            } else {
                nl.add("numFound", (Object)rb.getResults().docList.matches());
                nl.add("maxScore", (Object)Float.valueOf(rb.getResults().docList.maxScore()));
            }
            nl.add("shardAddress", (Object)rb.shortCircuitedURL);
            nl.add("time", (Object)(rsp.getEndTime() - req.getStartTime()));
            int pos = rb.shortCircuitedURL.indexOf("://");
            String shardInfoName = pos != -1 ? rb.shortCircuitedURL.substring(pos + 3) : rb.shortCircuitedURL;
            shardInfo.add(shardInfoName, (Object)nl);
            rsp.getValues().add("shards.info", (Object)shardInfo);
        }
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search using components: ");
        if (this.components != null) {
            for (SearchComponent c : this.components) {
                sb.append(c.getName());
                sb.append(",");
            }
        }
        return sb.toString();
    }

    @Override
    public String getSource() {
        return null;
    }
}

