/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.EigenStatus;
import org.apache.mahout.math.decomposer.SimpleEigenVerifier;

public class AsyncEigenVerifier
extends SimpleEigenVerifier {
    private final Executor threadPool = Executors.newFixedThreadPool(1);
    private EigenStatus status = new EigenStatus(-1.0, 0.0);
    private boolean finished;
    private boolean started;

    @Override
    public synchronized EigenStatus verify(VectorIterable corpus, Vector vector) {
        if (!this.finished && !this.started) {
            this.status = new EigenStatus(-1.0, 0.0);
            Vector vectorCopy = vector.clone();
            this.threadPool.execute(new VerifierRunnable(corpus, vectorCopy));
            this.started = true;
        }
        if (this.finished) {
            this.finished = false;
        }
        return this.status;
    }

    protected EigenStatus innerVerify(VectorIterable corpus, Vector vector) {
        return super.verify(corpus, vector);
    }

    private class VerifierRunnable
    implements Runnable {
        private final VectorIterable corpus;
        private final Vector vector;

        protected VerifierRunnable(VectorIterable corpus, Vector vector) {
            this.corpus = corpus;
            this.vector = vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EigenStatus status = AsyncEigenVerifier.this.innerVerify(this.corpus, this.vector);
            AsyncEigenVerifier asyncEigenVerifier = AsyncEigenVerifier.this;
            synchronized (asyncEigenVerifier) {
                AsyncEigenVerifier.this.status = status;
                AsyncEigenVerifier.this.finished = true;
                AsyncEigenVerifier.this.started = false;
            }
        }
    }
}

