/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.solr.lib.server.interceptor;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(PreemptiveAuthInterceptor.class);
    protected ContextAwareAuthScheme authScheme = new BasicScheme();

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState != null && authState.getAuthScheme() == null) {
            HttpHost targetHost;
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
            if (creds == null) {
                throw new HttpException("No credentials for preemptive authentication");
            }
            request.addHeader(this.authScheme.authenticate(creds, request, context));
        } else if (logger.isDebugEnabled()) {
            logger.debug("authState is null. No preemptive authentication.");
        }
    }

    public ContextAwareAuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public void setAuthScheme(ContextAwareAuthScheme authScheme) {
        this.authScheme = authScheme;
    }
}

