/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import thredds.catalog2.Catalog;
import thredds.catalog2.DatasetNode;
import thredds.catalog2.Metadata;
import thredds.catalog2.Property;
import thredds.catalog2.ThreddsMetadata;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.CatalogRefBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.MetadataBuilder;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.simpleImpl.CatalogImpl;
import thredds.catalog2.simpleImpl.CatalogRefImpl;
import thredds.catalog2.simpleImpl.DatasetImpl;
import thredds.catalog2.simpleImpl.DatasetNodeContainer;
import thredds.catalog2.simpleImpl.MetadataImpl;
import thredds.catalog2.simpleImpl.PropertyContainer;
import thredds.catalog2.simpleImpl.ThreddsMetadataImpl;

class DatasetNodeImpl
implements DatasetNode,
DatasetNodeBuilder {
    private String id;
    private String idAuthority;
    private String name;
    private PropertyContainer propertyContainer;
    private ThreddsMetadataImpl threddsMetadataImpl;
    private List<MetadataImpl> metadataImplList;
    private CatalogImpl parentCatalog;
    protected DatasetNodeImpl parent;
    private DatasetNodeContainer parentDatasetContainer;
    private DatasetNodeContainer datasetContainer;
    private boolean isBuilt = false;

    DatasetNodeImpl(String name, CatalogImpl parentCatalog, DatasetNodeImpl parent) {
        if (name == null) {
            throw new IllegalArgumentException("DatasetNode name must not be null.");
        }
        this.name = name;
        this.parentCatalog = parentCatalog;
        this.parent = parent;
        this.propertyContainer = new PropertyContainer();
        this.parentDatasetContainer = this.parent != null ? this.parent.getDatasetNodeContainer() : (this.parentCatalog != null ? this.parentCatalog.getDatasetNodeContainer() : null);
        DatasetNodeContainer rootContainer = this.parentDatasetContainer != null ? this.parentDatasetContainer.getRootContainer() : null;
        this.datasetContainer = new DatasetNodeContainer(rootContainer);
    }

    DatasetNodeContainer getDatasetNodeContainer() {
        return this.datasetContainer;
    }

    @Override
    public void setId(String id) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been finished().");
        }
        if (this.id != null) {
            if (!this.id.equals(id)) {
                if (this.isDatasetIdInUseGlobally(id)) {
                    throw new IllegalStateException();
                }
                if (this.parentDatasetContainer != null) {
                    this.parentDatasetContainer.removeDatasetNodeByGloballyUniqueId(this.id);
                    this.parentDatasetContainer.removeDatasetNodeFromLocalById(this.id);
                }
                if (id == null) {
                    this.id = null;
                    return;
                }
                this.id = id;
                if (this.parentDatasetContainer != null) {
                    this.parentDatasetContainer.addDatasetNodeByGloballyUniqueId(this);
                    this.parentDatasetContainer.addDatasetNodeToLocalById(this);
                }
            }
        } else {
            if (id == null) {
                return;
            }
            if (this.isDatasetIdInUseGlobally(id)) {
                throw new IllegalStateException();
            }
            this.id = id;
            if (this.parentDatasetContainer != null) {
                this.parentDatasetContainer.addDatasetNodeByGloballyUniqueId(this);
                this.parentDatasetContainer.addDatasetNodeToLocalById(this);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setIdAuthority(String idAuthority) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been finished().");
        }
        this.idAuthority = idAuthority;
    }

    @Override
    public String getIdAuthority() {
        return this.idAuthority;
    }

    @Override
    public void setName(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been finished().");
        }
        if (name == null) {
            throw new IllegalArgumentException("DatasetNode name must not be null.");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addProperty(String name, String value) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        this.propertyContainer.addProperty(name, value);
    }

    @Override
    public boolean removeProperty(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        return this.propertyContainer.removeProperty(name);
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been finished().");
        }
        return this.propertyContainer.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been finished().");
        }
        return this.propertyContainer.getPropertyValue(name);
    }

    @Override
    public List<Property> getProperties() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNode has escaped from its DatasetNodeBuilder before build() was called.");
        }
        return this.propertyContainer.getProperties();
    }

    @Override
    public Property getPropertyByName(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNode has escaped from its ServiceBuilder before build() was called.");
        }
        return this.propertyContainer.getPropertyByName(name);
    }

    @Override
    public ThreddsMetadataBuilder setNewThreddsMetadataBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        this.threddsMetadataImpl = new ThreddsMetadataImpl();
        return this.threddsMetadataImpl;
    }

    @Override
    public boolean removeThreddsMetadataBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        this.threddsMetadataImpl = null;
        return true;
    }

    @Override
    public ThreddsMetadataBuilder getThreddsMetadataBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        return this.threddsMetadataImpl;
    }

    @Override
    public ThreddsMetadata getThreddsMetadata() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNode has escaped its DatasetNodeBuilder before being built.");
        }
        return this.threddsMetadataImpl;
    }

    @Override
    public MetadataBuilder addMetadata() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        MetadataImpl mbi = new MetadataImpl();
        if (this.metadataImplList == null) {
            this.metadataImplList = new ArrayList<MetadataImpl>();
        }
        this.metadataImplList.add(mbi);
        return mbi;
    }

    @Override
    public boolean removeMetadata(MetadataBuilder metadataBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        if (metadataBuilder == null) {
            return false;
        }
        if (this.metadataImplList == null) {
            return false;
        }
        return this.metadataImplList.remove((MetadataImpl)metadataBuilder);
    }

    @Override
    public List<Metadata> getMetadata() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNode has escaped its DatasetNodeBuilder before being built.");
        }
        if (this.metadataImplList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<MetadataImpl>(this.metadataImplList));
    }

    @Override
    public List<MetadataBuilder> getMetadataBuilders() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNode has escaped its DatasetNodeBuilder before being built.");
        }
        if (this.metadataImplList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<MetadataImpl>(this.metadataImplList));
    }

    @Override
    public Catalog getParentCatalog() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNode has escaped its DatasetNodeBuilder before being built.");
        }
        return this.parentCatalog;
    }

    @Override
    public DatasetNode getParent() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNode has escaped its DatasetNodeBuilder before being built.");
        }
        return this.parent;
    }

    @Override
    public CatalogBuilder getParentCatalogBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        return this.parentCatalog;
    }

    @Override
    public DatasetNodeBuilder getParentDatasetBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        return this.parent;
    }

    @Override
    public boolean isCollection() {
        return !this.datasetContainer.isEmpty();
    }

    @Override
    public boolean isDatasetIdInUseGlobally(String id) {
        return this.datasetContainer.isDatasetNodeIdInUseGlobally(id);
    }

    @Override
    public DatasetBuilder addDataset(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        DatasetImpl ds = new DatasetImpl(name, this.parentCatalog, this);
        this.datasetContainer.addDatasetNode(ds);
        return ds;
    }

    @Override
    public CatalogRefBuilder addCatalogRef(String name, URI reference) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        CatalogRefImpl catRef = new CatalogRefImpl(name, reference, this.parentCatalog, this);
        this.datasetContainer.addDatasetNode(catRef);
        return catRef;
    }

    @Override
    public boolean removeDatasetNode(DatasetNodeBuilder datasetBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        return this.datasetContainer.removeDatasetNode((DatasetNodeImpl)datasetBuilder);
    }

    @Override
    public List<DatasetNode> getDatasets() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNode has escaped its DatasetNodeBuilder before being built.");
        }
        return this.datasetContainer.getDatasets();
    }

    @Override
    public DatasetNode getDatasetById(String id) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This DatasetNode has escaped its DatasetNodeBuilder before being built.");
        }
        return this.datasetContainer.getDatasetById(id);
    }

    @Override
    public List<DatasetNodeBuilder> getDatasetNodeBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        return this.datasetContainer.getDatasetNodeBuilders();
    }

    @Override
    public DatasetNodeBuilder getDatasetNodeBuilderById(String id) {
        if (this.isBuilt) {
            throw new IllegalStateException("This DatasetNodeBuilder has been built.");
        }
        return this.datasetContainer.getDatasetNodeBuilderById(id);
    }

    @Override
    public DatasetNodeBuilder findDatasetNodeBuilderByIdGlobally(String id) {
        return this.datasetContainer.getDatasetNodeByGloballyUniqueId(id);
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public BuilderIssues getIssues() {
        BuilderIssues issues = this.datasetContainer.getIssues();
        if (this.metadataImplList != null) {
            for (MetadataImpl mb : this.metadataImplList) {
                issues.addAllIssues(mb.getIssues());
            }
        }
        return issues;
    }

    @Override
    public DatasetNode build() throws BuilderException {
        if (this.isBuilt) {
            return this;
        }
        if (this.metadataImplList != null) {
            for (MetadataImpl mb : this.metadataImplList) {
                mb.build();
            }
        }
        this.datasetContainer.build();
        this.isBuilt = true;
        return this;
    }
}

