/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsBaseFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.lucene41.Lucene41PostingsBaseFormat;
import org.apache.lucene.codecs.memory.FSTOrdTermsReader;
import org.apache.lucene.codecs.memory.FSTOrdTermsWriter;
import org.apache.lucene.codecs.pulsing.PulsingPostingsReader;
import org.apache.lucene.codecs.pulsing.PulsingPostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.IOUtils;

public class FSTOrdPulsing41PostingsFormat
extends PostingsFormat {
    private final PostingsBaseFormat wrappedPostingsBaseFormat = new Lucene41PostingsBaseFormat();
    private final int freqCutoff;

    public FSTOrdPulsing41PostingsFormat() {
        this(1);
    }

    public FSTOrdPulsing41PostingsFormat(int freqCutoff) {
        super("FSTOrdPulsing41");
        this.freqCutoff = freqCutoff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FSTOrdTermsWriter fSTOrdTermsWriter;
        block3: {
            PostingsWriterBase docsWriter = null;
            PulsingPostingsWriter pulsingWriter = null;
            boolean success = false;
            try {
                docsWriter = this.wrappedPostingsBaseFormat.postingsWriterBase(state);
                pulsingWriter = new PulsingPostingsWriter(state, this.freqCutoff, docsWriter);
                FSTOrdTermsWriter ret = new FSTOrdTermsWriter(state, pulsingWriter);
                success = true;
                fSTOrdTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{docsWriter, pulsingWriter});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{docsWriter, pulsingWriter});
        }
        return fSTOrdTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FSTOrdTermsReader fSTOrdTermsReader;
        block3: {
            PostingsReaderBase docsReader = null;
            PulsingPostingsReader pulsingReader = null;
            boolean success = false;
            try {
                docsReader = this.wrappedPostingsBaseFormat.postingsReaderBase(state);
                pulsingReader = new PulsingPostingsReader(state, docsReader);
                FSTOrdTermsReader ret = new FSTOrdTermsReader(state, pulsingReader);
                success = true;
                fSTOrdTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{docsReader, pulsingReader});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{docsReader, pulsingReader});
        }
        return fSTOrdTermsReader;
    }
}

