/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class JPXFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(JPXFilter.class);

    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        BufferedImage bi = ImageIO.read(compressedData);
        if (bi != null) {
            DataBuffer dBuf = bi.getData().getDataBuffer();
            if (dBuf.getDataType() == 0) {
                ColorModel colorModel = bi.getColorModel();
                if (options.getItem(COSName.COLORSPACE) == null) {
                    options.setItem(COSName.COLORSPACE, (COSObjectable)PDColorSpaceFactory.createColorSpace(null, colorModel.getColorSpace()));
                }
                options.setInt(COSName.BITS_PER_COMPONENT, colorModel.getPixelSize() / colorModel.getNumComponents());
                options.setInt(COSName.HEIGHT, bi.getHeight());
                options.setInt(COSName.WIDTH, bi.getWidth());
                result.write(((DataBufferByte)dBuf).getData());
            } else {
                LOG.error((Object)("Image data buffer not of type byte but type " + dBuf.getDataType()));
            }
        }
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        LOG.error((Object)"Warning: JPXFilter.encode is not implemented yet, skipping this stream.");
    }
}

