/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.util;

import org.codelibs.core.util.StringUtil;

public class Base64Util {
    private static final char[] ENCODE_TABLE;
    private static final char PAD = '=';
    private static final byte[] DECODE_TABLE;

    public static String encode(byte[] inData) {
        if (inData == null || inData.length == 0) {
            return "";
        }
        int mod = inData.length % 3;
        int num = inData.length / 3;
        char[] outData = null;
        outData = mod != 0 ? new char[(num + 1) * 4] : new char[num * 4];
        for (int i = 0; i < num; ++i) {
            Base64Util.encode(inData, i * 3, outData, i * 4);
        }
        if (mod == 1) {
            Base64Util.encode2pad(inData, num * 3, outData, num * 4);
        } else if (mod == 2) {
            Base64Util.encode1pad(inData, num * 3, outData, num * 4);
        }
        return new String(outData);
    }

    public static byte[] decode(String inData) {
        if (StringUtil.isEmpty(inData)) {
            return null;
        }
        int num = inData.length() / 4 - 1;
        int lastBytes = Base64Util.getLastBytes(inData);
        byte[] outData = new byte[num * 3 + lastBytes];
        for (int i = 0; i < num; ++i) {
            Base64Util.decode(inData, i * 4, outData, i * 3);
        }
        switch (lastBytes) {
            case 1: {
                Base64Util.decode1byte(inData, num * 4, outData, num * 3);
                break;
            }
            case 2: {
                Base64Util.decode2byte(inData, num * 4, outData, num * 3);
                break;
            }
            default: {
                Base64Util.decode(inData, num * 4, outData, num * 3);
            }
        }
        return outData;
    }

    private static void encode(byte[] inData, int inIndex, char[] outData, int outIndex) {
        int i = ((inData[inIndex] & 0xFF) << 16) + ((inData[inIndex + 1] & 0xFF) << 8) + (inData[inIndex + 2] & 0xFF);
        outData[outIndex] = ENCODE_TABLE[i >> 18];
        outData[outIndex + 1] = ENCODE_TABLE[i >> 12 & 0x3F];
        outData[outIndex + 2] = ENCODE_TABLE[i >> 6 & 0x3F];
        outData[outIndex + 3] = ENCODE_TABLE[i & 0x3F];
    }

    private static void encode2pad(byte[] inData, int inIndex, char[] outData, int outIndex) {
        int i = inData[inIndex] & 0xFF;
        outData[outIndex] = ENCODE_TABLE[i >> 2];
        outData[outIndex + 1] = ENCODE_TABLE[i << 4 & 0x3F];
        outData[outIndex + 2] = 61;
        outData[outIndex + 3] = 61;
    }

    private static void encode1pad(byte[] inData, int inIndex, char[] outData, int outIndex) {
        int i = ((inData[inIndex] & 0xFF) << 8) + (inData[inIndex + 1] & 0xFF);
        outData[outIndex] = ENCODE_TABLE[i >> 10];
        outData[outIndex + 1] = ENCODE_TABLE[i >> 4 & 0x3F];
        outData[outIndex + 2] = ENCODE_TABLE[i << 2 & 0x3F];
        outData[outIndex + 3] = 61;
    }

    private static void decode(String inData, int inIndex, byte[] outData, int outIndex) {
        byte b0 = DECODE_TABLE[inData.charAt(inIndex)];
        byte b1 = DECODE_TABLE[inData.charAt(inIndex + 1)];
        byte b2 = DECODE_TABLE[inData.charAt(inIndex + 2)];
        byte b3 = DECODE_TABLE[inData.charAt(inIndex + 3)];
        outData[outIndex] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
        outData[outIndex + 1] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
        outData[outIndex + 2] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
    }

    private static void decode1byte(String inData, int inIndex, byte[] outData, int outIndex) {
        byte b0 = DECODE_TABLE[inData.charAt(inIndex)];
        byte b1 = DECODE_TABLE[inData.charAt(inIndex + 1)];
        outData[outIndex] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
    }

    private static void decode2byte(String inData, int inIndex, byte[] outData, int outIndex) {
        byte b0 = DECODE_TABLE[inData.charAt(inIndex)];
        byte b1 = DECODE_TABLE[inData.charAt(inIndex + 1)];
        byte b2 = DECODE_TABLE[inData.charAt(inIndex + 2)];
        outData[outIndex] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
        outData[outIndex + 1] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
    }

    private static int getLastBytes(String inData) {
        int len = inData.length();
        if (inData.charAt(len - 2) == '=') {
            return 1;
        }
        if (inData.charAt(len - 1) == '=') {
            return 2;
        }
        return 3;
    }

    static {
        int i;
        ENCODE_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DECODE_TABLE = new byte[128];
        for (i = 0; i < DECODE_TABLE.length; ++i) {
            Base64Util.DECODE_TABLE[i] = 127;
        }
        for (i = 0; i < ENCODE_TABLE.length; ++i) {
            Base64Util.DECODE_TABLE[Base64Util.ENCODE_TABLE[i]] = (byte)i;
        }
    }
}

