/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.math.BigInteger;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class PatriciaTrieSearch
implements LzssSearchMethod {
    private static final int UNUSED = 0;
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private int[] parent;
    private int[] hashTable;
    private int[] prev;
    private int[] next;
    private int[] position;
    private int[] level;
    private int[] childnum;
    private int avail;
    private int shift;
    private int lastMatchPos;
    private int lastMatchLen;

    private PatriciaTrieSearch() {
    }

    public PatriciaTrieSearch(int n, int n2, int n3, byte[] byArray) {
        int n4;
        this.DictionarySize = n;
        this.MaxMatch = n2;
        this.Threshold = n3;
        this.TextBuffer = byArray;
        this.DictionaryLimit = this.DictionarySize;
        this.parent = new int[this.DictionarySize * 2];
        this.prev = new int[this.DictionarySize * 2];
        this.next = new int[this.DictionarySize * 2];
        this.position = new int[this.DictionarySize];
        this.level = new int[this.DictionarySize];
        this.childnum = new int[this.DictionarySize];
        this.hashTable = new int[PatriciaTrieSearch.generateProbablePrime(this.DictionarySize + (this.DictionarySize >> 2))];
        for (n4 = 2; n4 < this.DictionarySize; ++n4) {
            this.next[n4] = n4 - 1;
        }
        this.avail = this.DictionarySize - 1;
        for (n4 = 0; n4 < this.DictionarySize * 2; ++n4) {
            this.parent[n4] = 0;
        }
        for (n4 = 0; n4 < this.hashTable.length; ++n4) {
            this.hashTable[n4] = 0;
        }
        this.shift = Bits.len(this.DictionarySize) - 8;
        this.lastMatchLen = 0;
        this.lastMatchPos = 0;
    }

    public void put(int n) {
        int n2;
        int n3;
        block13: {
            int n4;
            int n5;
            int n6 = (n & this.DictionarySize - 1) + this.DictionarySize;
            this.deleteNode(n6);
            int n7 = -1;
            n3 = n;
            if (3 < this.lastMatchLen) {
                n5 = this.lastMatchPos + 1 | this.DictionarySize;
                while (this.parent[n5] == 0) {
                    n5 = this.next[n5];
                }
                n4 = this.parent[n5];
                --this.lastMatchLen;
                while (0 < n4 && this.lastMatchLen <= this.level[n4]) {
                    n5 = n4;
                    n4 = this.parent[n4];
                }
                while (0 < n4) {
                    this.position[n4] = n;
                    n4 = this.parent[n4];
                }
                n2 = this.lastMatchLen;
            } else {
                n5 = this.child(this.TextBuffer[n] - 128, this.TextBuffer[n + 1] & 0xFF);
                n2 = 2;
                if (n5 == 0) {
                    this.attachNode(this.TextBuffer[n] - 128, n6, this.TextBuffer[n + 1] & 0xFF);
                    this.lastMatchLen = n2;
                    return;
                }
            }
            while (true) {
                if (n5 < this.DictionarySize) {
                    n4 = this.level[n5];
                    n7 = n5;
                    n3 = this.position[n5];
                } else {
                    n4 = this.MaxMatch;
                    n7 = n5;
                    int n8 = n3 = n <= n5 ? n5 - this.DictionarySize : n5;
                }
                while (n2 < n4 && this.TextBuffer[n3 + n2] == this.TextBuffer[n + n2]) {
                    ++n2;
                }
                if (n2 != n4 || n2 >= this.MaxMatch) break;
                this.position[n5] = n;
                if ((n5 = this.child(n5, this.TextBuffer[n + n2] & 0xFF)) == 0) {
                    this.attachNode(n7, n6, this.TextBuffer[n + n2] & 0xFF);
                    break block13;
                }
                ++n2;
            }
            if (n2 < n4) {
                this.splitNode(n7, n3, n6, n, n2);
            } else {
                this.replaceNode(n7, n6);
                this.next[n7] = n;
            }
        }
        this.lastMatchLen = n2;
        this.lastMatchPos = n3;
    }

    public int searchAndPut(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        block18: {
            int n6 = (n & this.DictionarySize - 1) + this.DictionarySize;
            this.deleteNode(n6);
            int n7 = -1;
            n5 = n;
            n4 = 0;
            n3 = 0;
            if (3 < this.lastMatchLen) {
                n4 = this.lastMatchPos + 1 | this.DictionarySize;
                while (this.parent[n4] == 0) {
                    n4 = this.next[n4];
                }
                n2 = this.parent[n4];
                --this.lastMatchLen;
                while (0 < n2 && this.lastMatchLen <= this.level[n2]) {
                    n4 = n2;
                    n2 = this.parent[n2];
                }
                while (0 < n2) {
                    this.position[n2] = n;
                    n2 = this.parent[n2];
                }
                n3 = this.lastMatchLen;
            } else {
                n4 = this.child(this.TextBuffer[n] - 128, this.TextBuffer[n + 1] & 0xFF);
                n3 = 2;
            }
            if (n4 != 0) {
                while (true) {
                    if (n4 < this.DictionarySize) {
                        n2 = this.level[n4];
                        n7 = n4;
                        n5 = this.position[n4];
                    } else {
                        n2 = this.MaxMatch;
                        n7 = n4;
                        int n8 = n5 = n <= n4 ? n4 - this.DictionarySize : n4;
                    }
                    while (n3 < n2 && this.TextBuffer[n5 + n3] == this.TextBuffer[n + n3]) {
                        ++n3;
                    }
                    if (n3 != n2 || n3 >= this.MaxMatch) break;
                    this.position[n4] = n;
                    if ((n4 = this.child(n4, this.TextBuffer[n + n3] & 0xFF)) == 0) {
                        this.attachNode(n7, n6, this.TextBuffer[n + n3] & 0xFF);
                        break block18;
                    }
                    ++n3;
                }
                if (n3 < n2) {
                    this.splitNode(n7, n5, n6, n, n3);
                } else {
                    this.replaceNode(n7, n6);
                    this.next[n7] = n;
                }
            } else {
                this.attachNode(this.TextBuffer[n] - 128, n6, this.TextBuffer[n + 1] & 0xFF);
                n3 = 0;
            }
        }
        this.lastMatchLen = n3;
        this.lastMatchPos = n5;
        n4 = n - this.DictionarySize;
        if (this.DictionaryLimit <= n4) {
            n2 = 0;
            while (this.TextBuffer[n4 + n2] == this.TextBuffer[n + n2] && this.MaxMatch > ++n2) {
            }
            if (n3 < n2) {
                n5 = n4;
                n3 = n2;
            }
        }
        if (this.Threshold <= n3) {
            return LzssOutputStream.createSearchReturn(n3, n5);
        }
        return -1;
    }

    public int search(int n, int n2) {
        int n3;
        int n4 = Math.max(this.DictionaryLimit, n2);
        int n5 = 0;
        int n6 = 0;
        byte[] byArray = this.TextBuffer;
        int n7 = Math.min(this.TextBuffer.length, n + this.MaxMatch);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n3 = n - 1; n4 < n3; --n3) {
            n8 = n3;
            n9 = n;
            while (byArray[n8] == byArray[n9]) {
                ++n8;
                if (n7 > ++n9) continue;
            }
            if (n5 >= (n10 = n9 - n)) continue;
            n6 = n3;
            n5 = n10;
            if (n7 <= n9) break;
        }
        if (2 < this.TextBuffer.length - n) {
            int n11 = this.child(this.TextBuffer[n] - 128, this.TextBuffer[n + 1] & 0xFF);
            n4 = Math.max(this.DictionaryLimit, n - this.DictionarySize);
            n10 = 2;
            while (n11 != 0) {
                int n12;
                if (n11 < this.DictionarySize) {
                    n12 = this.level[n11];
                    n3 = this.position[n11];
                } else {
                    n12 = this.MaxMatch;
                    int n13 = n3 = n2 < n11 ? n11 - this.DictionarySize : n11;
                }
                if (n4 > n3) break;
                n7 = Math.min(this.TextBuffer.length, n + n12);
                n8 = n3 + n10;
                n9 = n + n10;
                if (n9 < n7) {
                    while (byArray[n8] == byArray[n9]) {
                        ++n8;
                        if (n7 > ++n9) continue;
                    }
                }
                if (n5 < (n10 = n9 - n)) {
                    n6 = n3;
                    n5 = n10;
                }
                if (n10 != n12 || n5 >= this.MaxMatch || n + n10 >= this.TextBuffer.length) break;
                if ((n11 = this.child(n11, this.TextBuffer[n + n10] & 0xFF)) == 0) continue;
                ++n10;
            }
        }
        if (this.Threshold <= n5) {
            return LzssOutputStream.createSearchReturn(n5, n6);
        }
        return -1;
    }

    public void slide() {
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        this.lastMatchPos -= this.DictionarySize;
        for (int i = 0; i < this.position.length; ++i) {
            int n = this.position[i] - this.DictionarySize;
            this.position[i] = 0 < n ? n : 0;
        }
    }

    public int putRequires() {
        return this.MaxMatch;
    }

    private void splitNode(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.avail;
        this.avail = this.next[n6];
        this.replaceNode(n, n6);
        this.level[n6] = n5;
        this.position[n6] = n4;
        this.childnum[n6] = 0;
        this.attachNode(n6, n, this.TextBuffer[n2 + n5] & 0xFF);
        this.attachNode(n6, n3, this.TextBuffer[n4 + n5] & 0xFF);
    }

    private void deleteNode(int n) {
        if (this.parent[n] != 0) {
            int n2 = this.parent[n];
            int n3 = this.prev[n];
            int n4 = this.next[n];
            this.parent[n] = 0;
            this.prev[n] = 0;
            this.next[n] = 0;
            if (0 <= n3) {
                this.next[n3] = n4;
            } else {
                this.hashTable[n3 ^ 0xFFFFFFFF] = n4;
            }
            this.prev[n4] = n3;
            if (0 < n2) {
                int n5 = n2;
                this.childnum[n5] = this.childnum[n5] - 1;
                if (this.childnum[n2] <= 1) {
                    this.contractNode(this.child(n2, this.TextBuffer[this.position[n2] + this.level[n2]] & 0xFF));
                }
            }
        }
    }

    private void attachNode(int n, int n2, int n3) {
        int n4 = this.hash(n, n3);
        int n5 = this.hashTable[n4];
        this.hashTable[n4] = n2;
        this.parent[n2] = n;
        this.prev[n2] = ~n4;
        this.next[n2] = n5;
        this.prev[n5] = n2;
        if (0 < n) {
            int n6 = n;
            this.childnum[n6] = this.childnum[n6] + 1;
        }
    }

    private void replaceNode(int n, int n2) {
        this.parent[n2] = this.parent[n];
        this.prev[n2] = this.prev[n];
        this.next[n2] = this.next[n];
        this.prev[this.next[n2]] = n2;
        if (this.prev[n2] < 0) {
            this.hashTable[this.prev[n2] ^ 0xFFFFFFFF] = n2;
        } else {
            this.next[this.prev[n2]] = n2;
        }
        this.parent[n] = 0;
        this.prev[n] = 0;
        this.next[n] = 0;
    }

    private void contractNode(int n) {
        int n2 = this.parent[n];
        this.prev[this.next[n]] = this.prev[n];
        if (0 <= this.prev[n]) {
            this.next[this.prev[n]] = this.next[n];
        } else {
            this.hashTable[this.prev[n] ^ 0xFFFFFFFF] = this.next[n];
        }
        this.replaceNode(n2, n);
        this.next[n2] = this.avail;
        this.avail = n2;
    }

    private void slideTree(int[] nArray, int[] nArray2, int n) {
        int n2;
        for (n2 = 0; n2 < this.DictionarySize; ++n2) {
            nArray2[n2] = nArray[n2] < this.DictionarySize ? nArray[n2] : (nArray[n2] - n & this.DictionarySize - 1) + this.DictionarySize;
        }
        for (n2 = this.DictionarySize; n2 < nArray.length; ++n2) {
            nArray2[(n2 - n & this.DictionarySize - 1) + this.DictionarySize] = nArray[n2] < this.DictionarySize ? nArray[n2] : (nArray[n2] - n & this.DictionarySize - 1) + this.DictionarySize;
        }
    }

    private int child(int n, int n2) {
        int n3 = this.hashTable[this.hash(n, n2)];
        while (n3 != 0 && this.parent[n3] != n) {
            n3 = this.next[n3];
        }
        return n3;
    }

    private int hash(int n, int n2) {
        return (n + (n2 << this.shift) + 256) % this.hashTable.length;
    }

    private static int generateProbablePrime(int n) {
        n += (n & 1) == 0 ? 1 : 0;
        while (!new BigInteger(Integer.toString(n)).isProbablePrime(8)) {
            n += (n += (n += (n += 2) % 3 == 0 ? 2 : 0) % 5 == 0 ? 2 : 0) % 7 == 0 ? 2 : 0;
        }
        return n;
    }
}

