/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jp.gr.java_conf.dangan.io.LittleEndian;
import jp.gr.java_conf.dangan.util.MsdosDate;
import jp.gr.java_conf.dangan.util.lha.CRC16;
import jp.gr.java_conf.dangan.util.lha.LhaChecksum;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class LhaHeader
implements Cloneable {
    public static final int UNKNOWN = -1;
    public static final int NO_CRC = -2;
    private long OriginalSize = -1L;
    private Date LastModified = null;
    private String Path = "";
    private int CRC = -1;
    private String Method = "-lh5-";
    private long CompressedSize = -1L;
    private int HeaderLevel = 2;
    private byte OSID = (byte)74;
    private byte[] ExtraData = null;
    private byte Level0DosAttribute = (byte)32;
    private Vector ExtraExtHeaders = null;

    private LhaHeader() {
    }

    public LhaHeader(String string) {
        this(string, new Date(System.currentTimeMillis()));
    }

    public LhaHeader(String string, Date date) {
        this();
        if (string != null && !string.equals("") && date != null) {
            if (string.endsWith(File.separator)) {
                this.Method = "-lhd-";
            }
        } else {
            if (string == null) {
                throw new NullPointerException("path");
            }
            if (string.equals("")) {
                throw new IllegalArgumentException("path must not be empty.");
            }
            throw new NullPointerException("date");
        }
        this.Path = string;
        this.LastModified = date;
    }

    public LhaHeader(byte[] byArray) {
        this();
        if (byArray != null) {
            try {
                this.importHeader(byArray, LhaProperty.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("Java Runtime Environment not support " + LhaProperty.encoding + " encoding");
            }
        } else {
            throw new NullPointerException("HeaderData");
        }
    }

    public LhaHeader(byte[] byArray, String string) throws UnsupportedEncodingException {
        this();
        if (byArray == null || string == null) {
            if (byArray == null) {
                throw new NullPointerException("HeaderData");
            }
            throw new NullPointerException("encode");
        }
        this.importHeader(byArray, string);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("java.lang.Object is not support clone().");
        }
    }

    public String getCompressMethod() {
        return this.Method;
    }

    public long getOriginalSize() {
        return this.OriginalSize;
    }

    public long getCompressedSize() {
        return this.CompressedSize;
    }

    public Date getLastModified() {
        return new Date(this.LastModified.getTime());
    }

    public int getHeaderLevel() {
        return this.HeaderLevel;
    }

    public String getPath() {
        return this.Path;
    }

    public int getCRC() {
        return this.CRC;
    }

    public byte getOSID() {
        return this.OSID;
    }

    protected byte[] getExtraData() {
        return (byte[])this.ExtraData.clone();
    }

    protected byte getLevel0DosAttribute() {
        return this.Level0DosAttribute;
    }

    private String getFileName() {
        return this.Path.substring(this.Path.lastIndexOf(File.separatorChar) + 1);
    }

    private String getDirName() {
        return this.Path.substring(0, this.Path.lastIndexOf(File.separatorChar) + 1);
    }

    public byte[] getBytes() {
        try {
            return this.exportHeader(LhaProperty.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Java Runtime Environment not support " + LhaProperty.encoding + " encoding");
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return this.exportHeader(string);
    }

    public void setCompressMethod(String string) {
        if (string == null) {
            throw new NullPointerException("method");
        }
        if (!string.startsWith("-") || !string.endsWith("-")) {
            throw new IllegalArgumentException("method must starts with '-' and ends with '-'");
        }
        this.Method = string;
    }

    public void setOriginalSize(long l) {
        if (l == -1L) {
            throw new IllegalArgumentException("size must not LhaHeader.UNKNOWN( -1 )");
        }
        this.OriginalSize = l;
    }

    public void setCompressedSize(long l) {
        if (l == -1L) {
            throw new IllegalArgumentException("size must not LhaHeader.UNKNOWN( -1 )");
        }
        this.CompressedSize = l;
    }

    public void setLastModified(Date date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        this.LastModified = date;
    }

    public void setHeaderLevel(int n) {
        this.HeaderLevel = n;
    }

    public void setPath(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("path must not empty.");
        }
        this.Path = string;
    }

    public void setCRC(int n) {
        if (n == -1) {
            throw new IllegalArgumentException("crc must not LhaHeader.UNKNOWN( -1 )");
        }
        this.CRC = n;
    }

    public void setOSID(byte by) {
        this.OSID = by;
    }

    protected void setExtraData(byte[] byArray) {
        this.ExtraData = byArray;
    }

    protected void setLevel0DosAttribute(byte by) {
        this.Level0DosAttribute = by;
    }

    private void setFileName(String string) {
        this.Path = this.getDirName() + string;
    }

    private void setDirName(String string) {
        this.Path = string + this.getFileName();
    }

    private void importLevel0Header(byte[] byArray, String string) throws UnsupportedEncodingException {
        int n = (byArray[0] & 0xFF) + 2;
        int n2 = byArray[21] & 0xFF;
        int n3 = 22 + n2;
        int n4 = 24 + n2;
        int n5 = n - n4;
        this.Method = new String(byArray, 2, 5, string);
        this.CompressedSize = (long)LittleEndian.readInt(byArray, 7) & 0xFFFFFFFFL;
        this.OriginalSize = (long)LittleEndian.readInt(byArray, 11) & 0xFFFFFFFFL;
        this.LastModified = new MsdosDate(LittleEndian.readInt(byArray, 15));
        this.Level0DosAttribute = byArray[19];
        this.HeaderLevel = byArray[20] & 0xFF;
        this.Path = new String(byArray, 22, n2, string);
        this.Path = this.Path.replace('\\', File.separatorChar);
        if (n3 + 2 <= n) {
            this.CRC = LittleEndian.readShort(byArray, n3);
            if (0 < n5) {
                this.ExtraData = new byte[n5];
                System.arraycopy(byArray, n4, this.ExtraData, 0, n5);
            }
        } else {
            this.CRC = -2;
        }
    }

    private void importLevel1Header(byte[] byArray, String string) throws UnsupportedEncodingException {
        int n = (byArray[0] & 0xFF) + 2;
        int n2 = byArray[21] & 0xFF;
        int n3 = 22 + n2;
        int n4 = 24 + n2;
        int n5 = 25 + n2;
        int n6 = n - n5 - 2;
        this.Method = new String(byArray, 2, 5, string);
        this.CompressedSize = (long)LittleEndian.readInt(byArray, 7) & 0xFFFFFFFFL;
        this.OriginalSize = (long)LittleEndian.readInt(byArray, 11) & 0xFFFFFFFFL;
        this.LastModified = new MsdosDate(LittleEndian.readInt(byArray, 15));
        this.HeaderLevel = byArray[20] & 0xFF;
        this.Path = new String(byArray, 22, n2, string);
        this.CRC = LittleEndian.readShort(byArray, n3);
        this.OSID = byArray[n4];
        if (0 < n6) {
            this.ExtraData = new byte[n6];
            System.arraycopy(byArray, n5, this.ExtraData, 0, n6);
        }
        boolean bl = false;
        int n7 = n;
        int n8 = LittleEndian.readShort(byArray, n7 - 2);
        while (n8 != 0) {
            if (!bl) {
                this.CompressedSize -= (long)n8;
            }
            this.importExtHeader(byArray, n7, n8 - 2, string);
            if (byArray[n7] == 66) {
                bl = true;
            }
            n8 = LittleEndian.readShort(byArray, (n7 += n8) - 2);
        }
    }

    private void importLevel2Header(byte[] byArray, String string) throws UnsupportedEncodingException {
        int n = LittleEndian.readShort(byArray, 0);
        this.Method = new String(byArray, 2, 5, string);
        this.CompressedSize = (long)LittleEndian.readInt(byArray, 7) & 0xFFFFFFFFL;
        this.OriginalSize = (long)LittleEndian.readInt(byArray, 11) & 0xFFFFFFFFL;
        this.LastModified = new Date((long)LittleEndian.readInt(byArray, 15) * 1000L);
        this.HeaderLevel = byArray[20] & 0xFF;
        this.CRC = LittleEndian.readShort(byArray, 21);
        this.OSID = byArray[23];
        int n2 = 26;
        int n3 = LittleEndian.readShort(byArray, n2 - 2);
        while (n3 != 0) {
            this.importExtHeader(byArray, n2, n3 - 2, string);
            n3 = LittleEndian.readShort(byArray, (n2 += n3) - 2);
        }
    }

    private void importLevel3Header(byte[] byArray, String string) throws UnsupportedEncodingException {
        int n = LittleEndian.readShort(byArray, 0);
        this.Method = new String(byArray, 2, 5, string);
        this.CompressedSize = (long)LittleEndian.readInt(byArray, 7) & 0xFFFFFFFFL;
        this.OriginalSize = (long)LittleEndian.readInt(byArray, 11) & 0xFFFFFFFFL;
        this.LastModified = new Date((long)LittleEndian.readInt(byArray, 15) * 1000L);
        this.HeaderLevel = byArray[20] & 0xFF;
        this.CRC = LittleEndian.readShort(byArray, 21);
        this.OSID = byArray[23];
        int n2 = 32;
        int n3 = LittleEndian.readInt(byArray, n2 - 4);
        while (n3 != 0) {
            this.importExtHeader(byArray, n2, n3 - 4, string);
            n3 = LittleEndian.readInt(byArray, (n2 += n3) - 4);
        }
    }

    private void importHeader(byte[] byArray, String string) throws UnsupportedEncodingException {
        switch (byArray[20]) {
            case 0: {
                this.importLevel0Header(byArray, string);
                break;
            }
            case 1: {
                this.importLevel1Header(byArray, string);
                break;
            }
            case 2: {
                this.importLevel2Header(byArray, string);
                break;
            }
            case 3: {
                this.importLevel3Header(byArray, string);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown header level \"" + byArray[20] + "\".");
            }
        }
    }

    private void importCommonExtHeader(byte[] byArray, int n, int n2) {
        if (3 < n2) {
            if (this.ExtraExtHeaders == null) {
                this.ExtraExtHeaders = new Vector();
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.ExtraExtHeaders.addElement(byArray2);
        }
    }

    private void importFileNameExtHeader(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this.setFileName(new String(byArray, n + 1, n2 - 1, string));
    }

    private void importDirNameExtHeader(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        int n3;
        String string2 = "";
        for (int i = 1; i < n2; i += n3 + 1) {
            n3 = 0;
            while (i + n3 < n2 && byArray[n + i + n3] != -1) {
                ++n3;
            }
            string2 = i + n3 < n2 ? string2 + new String(byArray, n + i, n3, string) + File.separator : string2 + new String(byArray, n + i, n3, string);
        }
        this.setDirName(string2);
    }

    private void importFileSizeHeader(byte[] byArray, int n, int n2) {
        if (n2 == 17) {
            this.CompressedSize = LittleEndian.readLong(byArray, n + 1);
            this.OriginalSize = LittleEndian.readLong(byArray, n + 9);
        }
    }

    protected void importExtendHeader(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (this.ExtraExtHeaders == null) {
            this.ExtraExtHeaders = new Vector();
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.ExtraExtHeaders.addElement(byArray2);
    }

    private void importExtHeader(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        switch (byArray[n + 0]) {
            case 0: {
                this.importCommonExtHeader(byArray, n, n2);
                break;
            }
            case 1: {
                this.importFileNameExtHeader(byArray, n, n2, string);
                break;
            }
            case 2: {
                this.importDirNameExtHeader(byArray, n, n2, string);
                break;
            }
            case 66: {
                this.importFileSizeHeader(byArray, n, n2);
                break;
            }
            default: {
                this.importExtendHeader(byArray, n, n2, string);
            }
        }
    }

    private byte[] exportLevel0Header(String string) throws UnsupportedEncodingException {
        byte[] byArray;
        int n = this.CRC == -2 || this.CRC == -1 ? 0 : 2;
        byte[] byArray2 = this.Method.getBytes(string);
        MsdosDate msdosDate = null;
        try {
            msdosDate = this.LastModified instanceof MsdosDate ? (MsdosDate)this.LastModified : new MsdosDate(this.LastModified);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException.toString());
        }
        byte[] byArray3 = this.Path.replace(File.separatorChar, '\\').getBytes(string);
        int n2 = 22 + n + byArray3.length;
        byte[] byArray4 = n != 0 && this.ExtraData != null && n2 + this.ExtraData.length <= 100 ? this.ExtraData : new byte[]{};
        n2 += byArray4.length;
        if (byArray2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (100 < n2) {
            throw new IllegalStateException("Header size too large.");
        }
        if (this.CompressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.CompressedSize) {
            throw new IllegalStateException("CompressedSize must be 0xFFFFFFFF or less.");
        }
        if (this.CompressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.OriginalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.OriginalSize) {
            throw new IllegalStateException("OriginalSize must be 0xFFFFFFFF or less.");
        }
        if (this.OriginalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(n2 - 2);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(byArray2);
            LittleEndian.writeInt(byteArrayOutputStream, (int)this.CompressedSize);
            LittleEndian.writeInt(byteArrayOutputStream, (int)this.OriginalSize);
            LittleEndian.writeInt(byteArrayOutputStream, msdosDate.getMsdosTime());
            byteArrayOutputStream.write(this.Level0DosAttribute);
            byteArrayOutputStream.write(this.HeaderLevel);
            byteArrayOutputStream.write(byArray3.length);
            byteArrayOutputStream.write(byArray3);
            if (this.CRC != -1) {
                LittleEndian.writeShort(byteArrayOutputStream, this.CRC);
                byteArrayOutputStream.write(byArray4);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new Error("caught the IOException ( " + iOException.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        byArray[1] = (byte)LhaHeader.calcHeaderChecksum(byArray);
        return byArray;
    }

    private byte[] exportLevel1Header(String string) throws UnsupportedEncodingException {
        byte[] byArray;
        int n;
        MsdosDate msdosDate;
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray2 = this.Method.getBytes(string);
        try {
            msdosDate = this.LastModified instanceof MsdosDate ? (MsdosDate)this.LastModified : new MsdosDate(this.LastModified);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException.toString());
        }
        int n2 = 27;
        byte[] byArray3 = this.ExtraData != null && n2 + this.ExtraData.length <= 100 ? this.ExtraData : new byte[]{};
        byte[] byArray4 = this.getFileName().getBytes(string);
        if (100 < (n2 += byArray3.length) + byArray4.length) {
            byArray4 = new byte[]{};
        } else {
            bl = true;
        }
        n2 += byArray4.length;
        byte[][] byArray5 = this.exportExtHeaders(string);
        long l = this.CompressedSize;
        for (int i = 0; i < byArray5.length; ++i) {
            if (byArray5[i].length == 0 || 65534 <= byArray5[i].length || byArray5[i][0] == 1 && bl) {
                byArray5[i] = null;
                continue;
            }
            if (byArray5[i][0] == 0) {
                bl2 = true;
            }
            if (byArray5[i][0] == 1) {
                bl = true;
            }
            l += (long)(byArray5[i].length + 2);
        }
        if (byArray2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (l != this.CompressedSize && !bl2) {
            throw new IllegalStateException("no Header CRC field.");
        }
        if (!bl) {
            throw new IllegalStateException("no Filename infomation.");
        }
        if (this.CRC == -2) {
            throw new IllegalStateException("no CRC value.");
        }
        if (this.CRC == -1) {
            throw new IllegalStateException("CRC is UNKNOWN.");
        }
        if (this.CompressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.CompressedSize) {
            throw new IllegalStateException("CompressedSize must be 0xFFFFFFFF or less.");
        }
        if (this.CompressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.OriginalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.OriginalSize) {
            throw new IllegalStateException("OriginalSize must be 0xFFFFFFFF or less.");
        }
        if (this.OriginalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        if (0x100000000L <= l) {
            throw new IllegalStateException("SkipSize must be 0xFFFFFFFF or less.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(n2 - 2);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(byArray2);
            LittleEndian.writeInt(byteArrayOutputStream, (int)l);
            LittleEndian.writeInt(byteArrayOutputStream, (int)this.OriginalSize);
            LittleEndian.writeInt(byteArrayOutputStream, msdosDate.getMsdosTime());
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(this.HeaderLevel);
            byteArrayOutputStream.write(byArray4.length);
            byteArrayOutputStream.write(byArray4);
            LittleEndian.writeShort(byteArrayOutputStream, this.CRC);
            byteArrayOutputStream.write(this.OSID);
            byteArrayOutputStream.write(byArray3);
            for (n = 0; n < byArray5.length; ++n) {
                if (byArray5[n] == null) continue;
                LittleEndian.writeShort(byteArrayOutputStream, byArray5[n].length + 2);
                byteArrayOutputStream.write(byArray5[n]);
            }
            LittleEndian.writeShort(byteArrayOutputStream, 0);
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new Error("caught the IOException ( " + iOException.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        n = LhaHeader.getCRC16Position(byArray);
        byArray[1] = (byte)LhaHeader.calcHeaderChecksum(byArray);
        if (bl2) {
            LittleEndian.writeShort(byArray, n, LhaHeader.calcHeaderCRC16(byArray));
        }
        return byArray;
    }

    private byte[] exportLevel2Header(String string) throws UnsupportedEncodingException {
        byte[] byArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        byte[] byArray2 = this.Method.getBytes(string);
        int n = 26;
        boolean bl5 = 0x100000000L <= this.CompressedSize || 0x100000000L <= this.OriginalSize;
        byte[][] byArray3 = this.exportExtHeaders(string);
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i].length == 0 || 65535 <= n + byArray3[i].length + 2) {
                byArray3[i] = null;
                continue;
            }
            if (byArray3[i][0] == 0) {
                bl2 = true;
            }
            if (byArray3[i][0] == 1) {
                bl = true;
            }
            if (byArray3[i][0] == 66) {
                bl4 = true;
            }
            n += byArray3[i].length + 2;
        }
        if ((n & 0xFF) == 0) {
            ++n;
            bl3 = true;
        }
        if (byArray2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (this.LastModified.getTime() < 0L || (this.LastModified.getTime() / 1000L & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("LastModified can not change to 4byte time_t format.");
        }
        if (!bl2) {
            throw new IllegalStateException("HeaderSize too large. can not contain CRC of the Header.");
        }
        if (!bl) {
            throw new IllegalStateException("HeaderSize too large. can not contain Filename.");
        }
        if (bl5 && !bl4) {
            throw new IllegalStateException("HeaderSize too large. can not contain Filesize.");
        }
        if (this.CRC == -2) {
            throw new IllegalStateException("no CRC.");
        }
        if (this.CRC == -1) {
            throw new IllegalStateException("CRC must not be UNKNOWN.");
        }
        if (this.CompressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (this.CompressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.OriginalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (this.OriginalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            LittleEndian.writeShort(byteArrayOutputStream, n);
            byteArrayOutputStream.write(byArray2);
            LittleEndian.writeInt(byteArrayOutputStream, (int)this.CompressedSize);
            LittleEndian.writeInt(byteArrayOutputStream, (int)this.OriginalSize);
            LittleEndian.writeInt(byteArrayOutputStream, (int)(this.LastModified.getTime() / 1000L));
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(this.HeaderLevel);
            LittleEndian.writeShort(byteArrayOutputStream, this.CRC);
            byteArrayOutputStream.write(this.OSID);
            for (int i = 0; i < byArray3.length; ++i) {
                if (byArray3[i] == null) continue;
                LittleEndian.writeShort(byteArrayOutputStream, byArray3[i].length + 2);
                byteArrayOutputStream.write(byArray3[i]);
            }
            LittleEndian.writeShort(byteArrayOutputStream, 0);
            if (bl3) {
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new Error("caught the IOException ( " + iOException.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        int n2 = LhaHeader.getCRC16Position(byArray);
        LittleEndian.writeShort(byArray, n2, LhaHeader.calcHeaderCRC16(byArray));
        return byArray;
    }

    private byte[] exportLevel3Header(String string) throws UnsupportedEncodingException {
        byte[] byArray;
        byte[] byArray2 = this.Method.getBytes(string);
        int n = 32;
        byte[][] byArray3 = this.exportExtHeaders(string);
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i].length == 0) {
                byArray3[i] = null;
                continue;
            }
            n += byArray3[i].length + 4;
        }
        if (byArray2.length != 5) {
            throw new IllegalStateException("CompressMethod doesn't follow Format.");
        }
        if (this.LastModified.getTime() < 0L || (this.LastModified.getTime() / 1000L & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("LastModified can not change to 4byte time_t format.");
        }
        if (this.CRC == -2) {
            throw new IllegalStateException("no CRC value.");
        }
        if (this.CRC == -1) {
            throw new IllegalStateException("CRC is UNKNOWN.");
        }
        if (this.CompressedSize == -1L) {
            throw new IllegalStateException("CompressedSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.CompressedSize) {
            throw new IllegalStateException("CompressedSize must be 0xFFFFFFFF or less.");
        }
        if (this.CompressedSize < 0L) {
            throw new IllegalStateException("CompressedSize must be 0 or more.");
        }
        if (this.OriginalSize == -1L) {
            throw new IllegalStateException("OriginalSize must not be UNKNOWN.");
        }
        if (0x100000000L <= this.OriginalSize) {
            throw new IllegalStateException("OriginalSize must be 0xFFFFFFFF or less.");
        }
        if (this.OriginalSize < 0L) {
            throw new IllegalStateException("OriginalSize must be 0 or more.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            LittleEndian.writeShort(byteArrayOutputStream, 4);
            byteArrayOutputStream.write(byArray2);
            LittleEndian.writeInt(byteArrayOutputStream, (int)this.CompressedSize);
            LittleEndian.writeInt(byteArrayOutputStream, (int)this.OriginalSize);
            LittleEndian.writeInt(byteArrayOutputStream, (int)(this.LastModified.getTime() / 1000L));
            byteArrayOutputStream.write(32);
            byteArrayOutputStream.write(this.HeaderLevel);
            LittleEndian.writeShort(byteArrayOutputStream, this.CRC);
            byteArrayOutputStream.write(this.OSID);
            LittleEndian.writeInt(byteArrayOutputStream, n);
            for (int i = 0; i < byArray3.length; ++i) {
                if (byArray3[i] == null) continue;
                LittleEndian.writeInt(byteArrayOutputStream, byArray3[i].length + 4);
                byteArrayOutputStream.write(byArray3[i]);
            }
            LittleEndian.writeInt(byteArrayOutputStream, 0);
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new Error("caught the IOException ( " + iOException.getMessage() + " ) which should be never thrown by ByteArrayOutputStream.");
        }
        int n2 = LhaHeader.getCRC16Position(byArray);
        LittleEndian.writeShort(byArray, n2, LhaHeader.calcHeaderCRC16(byArray));
        return byArray;
    }

    private byte[] exportHeader(String string) throws UnsupportedEncodingException {
        switch (this.HeaderLevel) {
            case 0: {
                return this.exportLevel0Header(string);
            }
            case 1: {
                return this.exportLevel1Header(string);
            }
            case 2: {
                return this.exportLevel2Header(string);
            }
            case 3: {
                return this.exportLevel3Header(string);
            }
        }
        throw new IllegalStateException("unknown header level \"" + this.HeaderLevel + "\".");
    }

    private byte[] exportCommonExtHeader() {
        if (this.ExtraExtHeaders != null) {
            for (int i = 0; i < this.ExtraExtHeaders.size(); ++i) {
                byte[] byArray = (byte[])this.ExtraExtHeaders.elementAt(i);
                if (byArray[0] != 0) continue;
                return byArray;
            }
        }
        return new byte[3];
    }

    private byte[] exportFileNameExtHeader(String string) throws UnsupportedEncodingException {
        byte[] byArray = this.getFileName().getBytes(string);
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 1;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return byArray2;
    }

    private byte[] exportDirNameExtHeader(String string) throws UnsupportedEncodingException {
        byte[] byArray;
        String string2 = this.getDirName();
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n + n2 < string2.length()) {
            if (string2.charAt(n + n2) == File.separatorChar) {
                byArray = string2.substring(n, n + n2).getBytes(string);
                byte[] byArray2 = new byte[byArray.length + 1];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray2[byArray.length] = -1;
                n3 += byArray2.length;
                vector.addElement(byArray2);
                n += n2 + 1;
                n2 = 0;
                continue;
            }
            if (n + n2 + 1 < string2.length()) {
                byArray = string2.substring(n, n + n2 + 1).getBytes(string);
                n3 += byArray.length;
                vector.addElement(byArray);
                n += n2 + 1;
                n2 = 0;
                continue;
            }
            ++n2;
        }
        byArray = new byte[n3 + 1];
        byArray[0] = 2;
        n = 1;
        for (int i = 0; i < vector.size(); ++i) {
            byte[] byArray3 = (byte[])vector.elementAt(i);
            System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
            n += byArray3.length;
        }
        return byArray;
    }

    private byte[] exportFileSizeHeader() {
        byte[] byArray = new byte[17];
        byArray[0] = 66;
        LittleEndian.writeLong(byArray, 1, this.CompressedSize);
        LittleEndian.writeLong(byArray, 9, this.OriginalSize);
        return byArray;
    }

    protected byte[][] exportExtendHeaders(String string) throws UnsupportedEncodingException {
        if (this.ExtraExtHeaders != null) {
            byte[][] byArrayArray = new byte[this.ExtraExtHeaders.size()][];
            for (int i = 0; i < this.ExtraExtHeaders.size(); ++i) {
                byArrayArray[i] = (byte[])this.ExtraExtHeaders.elementAt(i);
            }
            return byArrayArray;
        }
        return new byte[0][];
    }

    private byte[][] exportExtHeaders(String string) throws UnsupportedEncodingException {
        byte[] byArray = this.exportCommonExtHeader();
        byte[] byArray2 = this.exportFileNameExtHeader(string);
        byte[] byArray3 = this.exportDirNameExtHeader(string);
        byte[][] byArray4 = this.exportExtendHeaders(string);
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.addElement(byArray);
        vector.addElement(byArray2);
        if (1 < byArray3.length) {
            vector.addElement(byArray3);
        }
        if (this.HeaderLevel == 2 && (0x100000000L <= this.CompressedSize || 0x100000000L <= this.OriginalSize)) {
            vector.addElement(this.exportFileSizeHeader());
        }
        for (int i = 0; i < byArray4.length; ++i) {
            byte[] byArray5 = byArray4[i];
            if (0 >= byArray5.length || byArray5[0] == 0 || byArray5[0] == 1 || byArray5[0] == 2) continue;
            vector.addElement(byArray5);
        }
        byte[][] byArrayArray = new byte[vector.size()][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            byArrayArray[i] = (byte[])vector.elementAt(i);
        }
        return byArrayArray;
    }

    public static boolean checkHeaderData(byte[] byArray) {
        try {
            switch (byArray[20] & 0xFF) {
                case 0: {
                    return LhaHeader.verifyHeaderChecksum(byArray);
                }
                case 1: {
                    return LhaHeader.verifyHeaderChecksum(byArray) && (LhaHeader.getCRC16Position(byArray) == -1 || LhaHeader.verifyHeaderCRC16(byArray));
                }
                case 2: {
                    return LhaHeader.verifyHeaderCRC16(byArray);
                }
                case 3: {
                    return LhaHeader.verifyHeaderCRC16(byArray);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int getCRC16Position(byte[] byArray) {
        int n;
        int n2;
        int n3;
        switch (byArray[20] & 0xFF) {
            case 1: {
                n3 = 2;
                n = n2 = (byArray[0] & 0xFF) + 2;
                break;
            }
            case 2: {
                n3 = 2;
                n2 = 26;
                n = 26;
                break;
            }
            case 3: {
                n3 = 4;
                n2 = 32;
                n = 32;
                break;
            }
            default: {
                return -1;
            }
        }
        while (0 < n2 && n < byArray.length) {
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                n2 = n2 << 8 | byArray[n - (1 + i)] & 0xFF;
            }
            if (byArray[n] == 0) {
                return n + 1;
            }
            n += n2;
        }
        return -1;
    }

    private static int calcHeaderChecksum(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        LhaChecksum lhaChecksum = new LhaChecksum();
        lhaChecksum.update(byArray, 2, n);
        return (int)lhaChecksum.getValue();
    }

    private static int calcHeaderCRC16(byte[] byArray) {
        int n = LhaHeader.getCRC16Position(byArray);
        int n2 = 0;
        if (n != -1) {
            n2 = LittleEndian.readShort(byArray, n);
            LittleEndian.writeShort(byArray, n, 0);
        }
        CRC16 cRC16 = new CRC16();
        cRC16.update(byArray);
        if (n != -1) {
            LittleEndian.writeShort(byArray, n, n2);
        }
        return (int)cRC16.getValue();
    }

    private static int readHeaderChecksum(byte[] byArray) {
        return byArray[1] & 0xFF;
    }

    private static int readHeaderCRC16(byte[] byArray) {
        int n = LhaHeader.getCRC16Position(byArray);
        if (n != -1) {
            return LittleEndian.readShort(byArray, n);
        }
        return -1;
    }

    private static boolean verifyHeaderChecksum(byte[] byArray) {
        switch (byArray[20] & 0xFF) {
            case 0: 
            case 1: {
                return LhaHeader.readHeaderChecksum(byArray) == LhaHeader.calcHeaderChecksum(byArray);
            }
        }
        return false;
    }

    private static boolean verifyHeaderCRC16(byte[] byArray) {
        switch (byArray[20] & 0xFF) {
            case 1: 
            case 2: 
            case 3: {
                return LhaHeader.readHeaderCRC16(byArray) == LhaHeader.calcHeaderCRC16(byArray);
            }
        }
        return false;
    }

    public static byte[] getFirstHeaderData(InputStream inputStream) throws IOException {
        if (inputStream.markSupported()) {
            try {
                int n;
                int n2 = -1;
                int n3 = -1;
                while (0 <= (n = inputStream.read())) {
                    if (n == 45 && 0 < n2) {
                        inputStream.mark(65536);
                        LhaHeader.ensureSkip(inputStream, 3L);
                        if (inputStream.read() == 45) {
                            byte[] byArray;
                            LhaHeader.ensureSkip(inputStream, 13L);
                            int n4 = inputStream.read();
                            inputStream.reset();
                            switch (n4) {
                                case 0: {
                                    byArray = LhaHeader.readLevel0HeaderData(n2, n3, n, inputStream);
                                    break;
                                }
                                case 1: {
                                    byArray = LhaHeader.readLevel1HeaderData(n2, n3, n, inputStream);
                                    break;
                                }
                                case 2: {
                                    byArray = LhaHeader.readLevel2HeaderData(n2, n3, n, inputStream);
                                    break;
                                }
                                case 3: {
                                    byArray = LhaHeader.readLevel3HeaderData(n2, n3, n, inputStream);
                                    break;
                                }
                                default: {
                                    byArray = null;
                                }
                            }
                            if (byArray != null && LhaHeader.checkHeaderData(byArray)) {
                                return byArray;
                            }
                        }
                        inputStream.reset();
                    }
                    n2 = n3;
                    n3 = n;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return null;
        }
        throw new IllegalArgumentException("InputStream needed mark()/reset() support.");
    }

    public static byte[] getNextHeaderData(InputStream inputStream) throws IOException {
        if (inputStream.markSupported()) {
            try {
                int n = inputStream.read();
                if (0 < n) {
                    int n2 = inputStream.read();
                    int n3 = inputStream.read();
                    inputStream.mark(65536);
                    LhaHeader.ensureSkip(inputStream, 3L);
                    int n4 = inputStream.read();
                    if (n3 == 45 && n4 == 45) {
                        byte[] byArray;
                        LhaHeader.ensureSkip(inputStream, 13L);
                        int n5 = inputStream.read();
                        inputStream.reset();
                        switch (n5) {
                            case 0: {
                                byArray = LhaHeader.readLevel0HeaderData(n, n2, n3, inputStream);
                                break;
                            }
                            case 1: {
                                byArray = LhaHeader.readLevel1HeaderData(n, n2, n3, inputStream);
                                break;
                            }
                            case 2: {
                                byArray = LhaHeader.readLevel2HeaderData(n, n2, n3, inputStream);
                                break;
                            }
                            case 3: {
                                byArray = LhaHeader.readLevel3HeaderData(n, n2, n3, inputStream);
                                break;
                            }
                            default: {
                                byArray = null;
                            }
                        }
                        if (byArray != null && LhaHeader.checkHeaderData(byArray)) {
                            return byArray;
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return null;
        }
        throw new IllegalArgumentException("InputStream needed mark()/reset() support.");
    }

    private static byte[] readLevel0HeaderData(int n, int n2, int n3, InputStream inputStream) throws IOException {
        int n4;
        byte[] byArray = new byte[n + 2];
        byArray[0] = (byte)n;
        byArray[1] = (byte)n2;
        byArray[2] = (byte)n3;
        int n5 = 0;
        n += 2;
        for (n4 = 3; n4 < n && 0 <= n5; n4 += n5) {
            n5 = inputStream.read(byArray, n4, n - n4);
        }
        if (n4 == n) {
            return byArray;
        }
        throw new EOFException();
    }

    private static byte[] readLevel1HeaderData(int n, int n2, int n3, InputStream inputStream) throws IOException {
        int n4;
        int n5 = n + 2;
        Vector<byte[]> vector = new Vector<byte[]>();
        byte[] byArray = new byte[n5];
        byArray[0] = (byte)n;
        byArray[1] = (byte)n2;
        byArray[2] = (byte)n3;
        int n6 = 0;
        int n7 = 0;
        do {
            for (n6 = 0 == vector.size() ? 3 : 0; n6 < n5 && 0 <= n7; n6 += n7) {
                n7 = inputStream.read(byArray, n6, n5 - n6);
            }
            if (n6 == n5) {
                if (0 == vector.size() && !LhaHeader.verifyHeaderChecksum(byArray)) {
                    return null;
                }
            } else {
                throw new EOFException();
            }
            vector.addElement(byArray);
            n7 = n5;
            n5 = LittleEndian.readShort(byArray, n5 - 2);
            byArray = new byte[n5];
        } while (0 < n5 && n6 == n7);
        n5 = 0;
        for (n4 = 0; n4 < vector.size(); ++n4) {
            n5 += ((byte[])vector.elementAt(n4)).length;
        }
        byArray = new byte[n5];
        n4 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            byte[] byArray2 = (byte[])vector.elementAt(i);
            System.arraycopy(byArray2, 0, byArray, n4, byArray2.length);
            n4 += byArray2.length;
        }
        return byArray;
    }

    private static byte[] readLevel2HeaderData(int n, int n2, int n3, InputStream inputStream) throws IOException {
        int n4;
        int n5 = n2 << 8 | n;
        byte[] byArray = new byte[n5];
        byArray[0] = (byte)n;
        byArray[1] = (byte)n2;
        byArray[2] = (byte)n3;
        int n6 = 0;
        for (n4 = 3; n4 < n5 && 0 <= n6; n4 += n6) {
            n6 = inputStream.read(byArray, n4, n5 - n4);
        }
        if (n4 == n5) {
            return byArray;
        }
        throw new EOFException();
    }

    private static byte[] readLevel3HeaderData(int n, int n2, int n3, InputStream inputStream) throws IOException {
        if (n == 4 && n2 == 0) {
            int n4;
            inputStream.skip(21L);
            int n5 = LittleEndian.readInt(inputStream);
            inputStream.reset();
            byte[] byArray = new byte[n5];
            byArray[0] = (byte)n;
            byArray[1] = (byte)n2;
            byArray[2] = (byte)n3;
            int n6 = 0;
            for (n4 = 3; n4 < n5 && 0 <= n6; n4 += n6) {
                n6 = inputStream.read(byArray, n4, n5 - n4);
            }
            if (n4 == n5) {
                return byArray;
            }
            throw new EOFException();
        }
        return null;
    }

    public static LhaHeader createInstance(byte[] byArray, Properties properties) {
        String string;
        String string2;
        String string3 = properties.getProperty("lha.encoding");
        if (string3 == null) {
            string3 = LhaProperty.getProperty("lha.encoding");
        }
        if ((string2 = properties.getProperty("lha.packages")) == null) {
            string2 = LhaProperty.getProperty("lha.packages");
        }
        if ((string = properties.getProperty("lha.header")) == null) {
            string = LhaProperty.getProperty("lha.header");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("data", byArray);
        hashtable.put("encoding", string3);
        return (LhaHeader)LhaProperty.parse(string, hashtable, string2);
    }

    private static void ensureSkip(InputStream inputStream, long l) throws IOException {
        while (0L < l) {
            long l2 = inputStream.skip(l);
            if (l2 <= 0L) {
                if (0 <= inputStream.read()) {
                    --l;
                    continue;
                }
                throw new EOFException();
            }
            l -= l2;
        }
    }
}

