/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsLoader;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsViewer;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class OfflineEditsBinaryLoader
implements OfflineEditsLoader {
    private OfflineEditsVisitor visitor;
    private EditLogInputStream inputStream;
    private final boolean fixTxIds;
    private final boolean recoveryMode;
    private long nextTxId;
    public static final Log LOG = LogFactory.getLog((String)OfflineEditsBinaryLoader.class.getName());

    public OfflineEditsBinaryLoader(OfflineEditsVisitor visitor, EditLogInputStream inputStream, OfflineEditsViewer.Flags flags) {
        this.visitor = visitor;
        this.inputStream = inputStream;
        this.fixTxIds = flags.getFixTxIds();
        this.recoveryMode = flags.getRecoveryMode();
        this.nextTxId = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEdits() throws IOException {
        try {
            this.visitor.start(this.inputStream.getVersion());
            while (true) {
                try {
                    FSEditLogOp op;
                    while ((op = this.inputStream.readOp()) != null) {
                        if (this.fixTxIds) {
                            if (this.nextTxId <= 0L) {
                                this.nextTxId = op.getTransactionId();
                                if (this.nextTxId <= 0L) {
                                    this.nextTxId = 1L;
                                }
                            }
                            op.setTransactionId(this.nextTxId);
                            ++this.nextTxId;
                        }
                        this.visitor.visitOp(op);
                    }
                }
                catch (IOException e) {
                    if (!this.recoveryMode) {
                        LOG.error((Object)("Got IOException at position " + this.inputStream.getPosition()));
                        this.visitor.close(e);
                        throw e;
                    }
                    LOG.error((Object)"Got IOException while reading stream!  Resyncing.", (Throwable)e);
                    this.inputStream.resync();
                    continue;
                }
                catch (RuntimeException e) {
                    if (!this.recoveryMode) {
                        LOG.error((Object)("Got RuntimeException at position " + this.inputStream.getPosition()));
                        this.visitor.close(e);
                        throw e;
                    }
                    LOG.error((Object)"Got RuntimeException while reading stream!  Resyncing.", (Throwable)e);
                    this.inputStream.resync();
                    continue;
                }
                break;
            }
            this.visitor.close(null);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.inputStream});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.inputStream});
    }
}

