/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.client.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codelibs.robot.MaxLengthExceededException;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.builder.RequestDataBuilder;
import org.codelibs.robot.client.AbstractS2RobotClient;
import org.codelibs.robot.client.fs.ChildUrlsException;
import org.codelibs.robot.entity.RequestData;
import org.codelibs.robot.entity.ResponseData;
import org.codelibs.robot.helper.ContentLengthHelper;
import org.codelibs.robot.helper.MimeTypeHelper;
import org.codelibs.robot.util.TemporaryFileInputStream;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemClient
extends AbstractS2RobotClient {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemClient.class);
    protected String charset = "UTF-8";
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected ContentLengthHelper contentLengthHelper;

    @Override
    public ResponseData doGet(String uri) {
        return this.getResponseData(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseData getResponseData(String uri, boolean includeContent) {
        ResponseData responseData;
        block17: {
            File file;
            block19: {
                String filePath;
                block18: {
                    responseData = new ResponseData();
                    responseData.setMethod("GET");
                    filePath = this.preprocessUri(uri);
                    responseData.setUrl(filePath);
                    file = null;
                    try {
                        file = new File(new URI(filePath));
                    }
                    catch (URISyntaxException e) {
                        logger.warn("Could not parse url: " + filePath, (Throwable)e);
                    }
                    if (file != null) break block18;
                    responseData.setHttpStatusCode(404);
                    responseData.setCharSet(this.charset);
                    responseData.setContentLength(0L);
                    break block17;
                }
                if (!file.isFile()) break block19;
                MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)SingletonS2Container.getComponent((String)"mimeTypeHelper");
                FileInputStream is = null;
                try {
                    is = new FileInputStream(file);
                    responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)is, file.getName()));
                }
                catch (Exception e) {
                    try {
                        responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
                IOUtils.closeQuietly((InputStream)is);
                responseData.setContentLength(file.length());
                if (this.contentLengthHelper != null) {
                    long maxLength = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                    if (responseData.getContentLength() > maxLength) {
                        throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + maxLength + " byte. The url is " + filePath);
                    }
                }
                responseData.setHttpStatusCode(200);
                responseData.setCharSet(this.geCharSet(file));
                responseData.setLastModified(new Date(file.lastModified()));
                if (file.canRead()) {
                    if (includeContent) {
                        File outputFile = null;
                        try {
                            outputFile = File.createTempFile("s2robot-FileSystemClient-", ".out");
                            FileUtil.copy((File)file, (File)outputFile);
                            responseData.setResponseBody(new TemporaryFileInputStream(outputFile));
                        }
                        catch (Exception e) {
                            logger.warn("I/O Exception.", (Throwable)e);
                            responseData.setHttpStatusCode(500);
                            if (outputFile != null && !outputFile.delete()) {
                                logger.warn("Could not delete " + outputFile.getAbsolutePath());
                            }
                            break block17;
                        }
                    }
                } else {
                    responseData.setHttpStatusCode(403);
                }
                break block17;
            }
            if (file.isDirectory()) {
                File[] files;
                HashSet<RequestData> requestDataSet = new HashSet<RequestData>();
                if (includeContent && (files = file.listFiles()) != null) {
                    for (File f : files) {
                        String chileUri = f.toURI().toASCIIString();
                        requestDataSet.add(RequestDataBuilder.newRequestData().get().url(chileUri).build());
                    }
                }
                throw new ChildUrlsException(requestDataSet);
            }
            responseData.setHttpStatusCode(404);
            responseData.setCharSet(this.charset);
            responseData.setContentLength(0L);
        }
        return responseData;
    }

    protected String preprocessUri(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            throw new RobotSystemException("The uri is empty.");
        }
        String filePath = uri;
        if (!filePath.startsWith("file:")) {
            filePath = "file://" + filePath;
        }
        StringBuilder buf = new StringBuilder(filePath.length() + 100);
        try {
            for (char c : filePath.toCharArray()) {
                if (c == ' ') {
                    buf.append("%20");
                    continue;
                }
                String str = String.valueOf(c);
                if (StringUtils.isAsciiPrintable((CharSequence)str)) {
                    buf.append(c);
                    continue;
                }
                buf.append(URLEncoder.encode(str, this.charset));
            }
        }
        catch (UnsupportedEncodingException e) {
            return filePath;
        }
        return buf.toString();
    }

    protected String geCharSet(File file) {
        return this.charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.getResponseData(url, false);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }
}

