/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.client;

import java.util.Map;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.client.S2RobotClient;
import org.codelibs.robot.entity.RequestData;
import org.codelibs.robot.entity.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractS2RobotClient
implements S2RobotClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractS2RobotClient.class);
    private Map<String, Object> initParamMap;

    protected <T> T getInitParameter(String key, T defaultValue) {
        if (this.initParamMap != null) {
            try {
                Object value = this.initParamMap.get(key);
                if (value != null) {
                    return (T)value;
                }
            }
            catch (Exception e) {
                logger.warn("Could not load init parameters: " + key + " from " + this.initParamMap, (Throwable)e);
            }
        }
        return defaultValue;
    }

    @Override
    public void setInitParameterMap(Map<String, Object> params) {
        this.initParamMap = params;
    }

    @Override
    public ResponseData execute(RequestData request) {
        switch (request.getMethod()) {
            case GET: {
                return this.doGet(request.getUrl());
            }
            case HEAD: {
                return this.doHead(request.getUrl());
            }
            case POST: {
                return this.doPost(request.getUrl());
            }
        }
        throw new RobotSystemException((Object)((Object)request.getMethod()) + " method is not supported.");
    }

    protected ResponseData doGet(String url) {
        throw new RobotSystemException("GET method is not supported.");
    }

    protected ResponseData doHead(String url) {
        throw new RobotSystemException("HEAD method is not supported.");
    }

    protected ResponseData doPost(String url) {
        throw new RobotSystemException("POST method is not supported.");
    }
}

