/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class DownloadAction
extends Action {
    protected static final int DEFAULT_BUFFER_SIZE = 4096;

    protected abstract StreamInfo getStreamInfo(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected int getBufferSize() {
        return 4096;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StreamInfo info = this.getStreamInfo(mapping, form, request, response);
        String contentType = info.getContentType();
        InputStream stream = info.getInputStream();
        try {
            response.setContentType(contentType);
            this.copy(stream, (OutputStream)response.getOutputStream());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return null;
    }

    public int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[this.getBufferSize()];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static class ResourceStreamInfo
    implements StreamInfo {
        private String contentType;
        private ServletContext context;
        private String path;

        public ResourceStreamInfo(String contentType, ServletContext context, String path) {
            this.contentType = contentType;
            this.context = context;
            this.path = path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return this.context.getResourceAsStream(this.path);
        }
    }

    public static class FileStreamInfo
    implements StreamInfo {
        private String contentType;
        private File file;

        public FileStreamInfo(String contentType, File file) {
            this.contentType = contentType;
            this.file = file;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            FileInputStream fis = new FileInputStream(this.file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            return bis;
        }
    }

    public static interface StreamInfo {
        public String getContentType();

        public InputStream getInputStream() throws IOException;
    }
}

