/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sastruts.core.filter;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.codelibs.core.crypto.CachedCipher;
import org.codelibs.sastruts.core.entity.UserInfo;
import org.codelibs.sastruts.core.util.ActivityUtil;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.util.StringUtil;

public class AuthFilter
implements Filter {
    private static final String DEFAULT_LOGIN_PATH = "/login/";
    private static final String HTTPS = "https:";
    private static final String HTTP = "http:";
    public List<Pattern> urlPatternList = new ArrayList<Pattern>();
    protected String cipherName;
    protected String loginPath;
    protected boolean useSecureLogin;
    protected String returnPathName;

    public void init(FilterConfig filterConfig) throws ServletException {
        String value = filterConfig.getInitParameter("urlPatterns");
        if (value != null) {
            String[] urlPatterns;
            for (String urlPattern : urlPatterns = value.split(",")) {
                this.urlPatternList.add(Pattern.compile(urlPattern.trim()));
            }
        }
        this.cipherName = filterConfig.getInitParameter("cipherName");
        if (StringUtil.isBlank((String)this.cipherName)) {
            this.cipherName = "authCipher";
        }
        this.loginPath = filterConfig.getInitParameter("loginPath");
        value = filterConfig.getInitParameter("useSecureLogin");
        this.useSecureLogin = StringUtil.isNotBlank((String)value) ? Boolean.parseBoolean(value) : false;
        this.returnPathName = filterConfig.getInitParameter("returnPathName");
        if (StringUtil.isBlank((String)this.returnPathName)) {
            this.returnPathName = "returnPath";
        }
    }

    public void destroy() {
        this.urlPatternList = null;
        this.cipherName = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String uri = req.getRequestURI();
        CachedCipher cipher = this.getCachedCipher();
        for (Pattern pattern : this.urlPatternList) {
            Matcher matcher = pattern.matcher(uri);
            if (!matcher.matches()) continue;
            String requestURL = req.getRequestURL().toString();
            if (this.useSecureLogin && requestURL.startsWith(HTTP)) {
                res.sendRedirect(requestURL.replaceFirst(HTTP, HTTPS));
                return;
            }
            UserInfo userInfo = this.getUserInfo(req);
            if (userInfo != null) {
                ActivityUtil.access(userInfo.getUsername(), req);
                chain.doFilter((ServletRequest)new AuthHttpServletRequest(req, userInfo), response);
            } else {
                StringBuilder buf = new StringBuilder(256);
                buf.append(System.currentTimeMillis());
                buf.append('|');
                buf.append(requestURL);
                String encoding = request.getCharacterEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                StringBuilder urlBuf = new StringBuilder(1000);
                if (StringUtil.isBlank((String)this.loginPath)) {
                    String contextPath = req.getContextPath();
                    if (contextPath != null) {
                        urlBuf.append(contextPath);
                    }
                    urlBuf.append(DEFAULT_LOGIN_PATH);
                } else {
                    urlBuf.append(res.encodeURL(this.loginPath));
                }
                urlBuf.append('?').append(this.returnPathName).append('=');
                urlBuf.append(URLEncoder.encode(cipher.encryptoText(buf.toString()), encoding));
                res.sendRedirect(urlBuf.toString());
            }
            return;
        }
        chain.doFilter(request, response);
    }

    protected UserInfo getUserInfo(HttpServletRequest req) {
        Object obj = req.getSession().getAttribute("LoginInfo");
        if (obj instanceof UserInfo) {
            return (UserInfo)obj;
        }
        return null;
    }

    protected CachedCipher getCachedCipher() {
        return (CachedCipher)SingletonS2Container.getComponent((String)this.cipherName);
    }

    protected static class AuthHttpServletRequest
    extends HttpServletRequestWrapper {
        protected UserInfo userInfo;

        protected AuthHttpServletRequest(HttpServletRequest request, UserInfo userInfo) {
            super(request);
            this.userInfo = userInfo;
        }

        public String getRemoteUser() {
            return this.userInfo.getUsername();
        }

        public boolean isUserInRole(String role) {
            return this.userInfo.isUserInRole(role);
        }
    }
}

