/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.KeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLHostnameVerifier;
import org.apache.hadoop.util.PlatformName;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SSLFactory
implements ConnectionConfigurator {
    public static final String SSL_REQUIRE_CLIENT_CERT_KEY = "hadoop.ssl.require.client.cert";
    public static final String SSL_HOSTNAME_VERIFIER_KEY = "hadoop.ssl.hostname.verifier";
    public static final String SSL_CLIENT_CONF_KEY = "hadoop.ssl.client.conf";
    public static final String SSL_SERVER_CONF_KEY = "hadoop.ssl.server.conf";
    public static final String SSLCERTIFICATE = PlatformName.IBM_JAVA ? "ibmX509" : "SunX509";
    public static final boolean DEFAULT_SSL_REQUIRE_CLIENT_CERT = false;
    public static final String KEYSTORES_FACTORY_CLASS_KEY = "hadoop.ssl.keystores.factory.class";
    private Configuration conf;
    private Mode mode;
    private boolean requireClientCert;
    private SSLContext context;
    private HostnameVerifier hostnameVerifier;
    private KeyStoresFactory keystoresFactory;

    public SSLFactory(Mode mode, Configuration conf) {
        this.conf = conf;
        if (mode == null) {
            throw new IllegalArgumentException("mode cannot be NULL");
        }
        this.mode = mode;
        this.requireClientCert = conf.getBoolean(SSL_REQUIRE_CLIENT_CERT_KEY, false);
        Configuration sslConf = this.readSSLConfiguration(mode);
        Class<KeyStoresFactory> klass = conf.getClass(KEYSTORES_FACTORY_CLASS_KEY, FileBasedKeyStoresFactory.class, KeyStoresFactory.class);
        this.keystoresFactory = ReflectionUtils.newInstance(klass, sslConf);
    }

    private Configuration readSSLConfiguration(Mode mode) {
        Configuration sslConf = new Configuration(false);
        sslConf.setBoolean(SSL_REQUIRE_CLIENT_CERT_KEY, this.requireClientCert);
        String sslConfResource = mode == Mode.CLIENT ? this.conf.get(SSL_CLIENT_CONF_KEY, "ssl-client.xml") : this.conf.get(SSL_SERVER_CONF_KEY, "ssl-server.xml");
        sslConf.addResource(sslConfResource);
        return sslConf;
    }

    public void init() throws GeneralSecurityException, IOException {
        this.keystoresFactory.init(this.mode);
        this.context = SSLContext.getInstance("TLS");
        this.context.init(this.keystoresFactory.getKeyManagers(), this.keystoresFactory.getTrustManagers(), null);
        this.hostnameVerifier = this.getHostnameVerifier(this.conf);
    }

    private HostnameVerifier getHostnameVerifier(Configuration conf) throws GeneralSecurityException, IOException {
        SSLHostnameVerifier hostnameVerifier;
        String verifier = conf.get(SSL_HOSTNAME_VERIFIER_KEY, "DEFAULT").trim().toUpperCase();
        if (verifier.equals("DEFAULT")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT;
        } else if (verifier.equals("DEFAULT_AND_LOCALHOST")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT_AND_LOCALHOST;
        } else if (verifier.equals("STRICT")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT;
        } else if (verifier.equals("STRICT_IE6")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT_IE6;
        } else if (verifier.equals("ALLOW_ALL")) {
            hostnameVerifier = SSLHostnameVerifier.ALLOW_ALL;
        } else {
            throw new GeneralSecurityException("Invalid hostname verifier: " + verifier);
        }
        return hostnameVerifier;
    }

    public void destroy() {
        this.keystoresFactory.destroy();
    }

    public KeyStoresFactory getKeystoresFactory() {
        return this.keystoresFactory;
    }

    public SSLEngine createSSLEngine() throws GeneralSecurityException, IOException {
        SSLEngine sslEngine = this.context.createSSLEngine();
        if (this.mode == Mode.CLIENT) {
            sslEngine.setUseClientMode(true);
        } else {
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(this.requireClientCert);
        }
        return sslEngine;
    }

    public SSLServerSocketFactory createSSLServerSocketFactory() throws GeneralSecurityException, IOException {
        if (this.mode != Mode.SERVER) {
            throw new IllegalStateException("Factory is in CLIENT mode");
        }
        return this.context.getServerSocketFactory();
    }

    public SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException, IOException {
        if (this.mode != Mode.CLIENT) {
            throw new IllegalStateException("Factory is in CLIENT mode");
        }
        return this.context.getSocketFactory();
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.mode != Mode.CLIENT) {
            throw new IllegalStateException("Factory is in CLIENT mode");
        }
        return this.hostnameVerifier;
    }

    public boolean isClientCertRequired() {
        return this.requireClientCert;
    }

    public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sslConn = (HttpsURLConnection)conn;
            try {
                sslConn.setSSLSocketFactory(this.createSSLSocketFactory());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            sslConn.setHostnameVerifier(this.getHostnameVerifier());
            conn = sslConn;
        }
        return conn;
    }

    @InterfaceAudience.Private
    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

