/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.function;

import org.apache.mahout.math.function.DoubleDoubleFunction;

public final class PlusMult
implements DoubleDoubleFunction {
    private double multiplicator;

    public PlusMult(double multiplicator) {
        this.multiplicator = multiplicator;
    }

    @Override
    public double apply(double a, double b) {
        return a + b * this.multiplicator;
    }

    public static PlusMult minusMult(double constant) {
        return new PlusMult(-constant);
    }

    public static PlusMult plusMult(double constant) {
        return new PlusMult(constant);
    }

    public double getMultiplicator() {
        return this.multiplicator;
    }

    public void setMultiplicator(double multiplicator) {
        this.multiplicator = multiplicator;
    }
}

