/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class NonnegativeMatrixFactorizationKL
extends IterativeMatrixFactorizationBase {
    public NonnegativeMatrixFactorizationKL(DoubleMatrix2D A) {
        super(A);
    }

    @Override
    public void compute() {
        int m = this.A.rows();
        int n = this.A.columns();
        double eps = 1.0E-9;
        this.U = new DenseDoubleMatrix2D(m, this.k);
        this.V = new DenseDoubleMatrix2D(n, this.k);
        this.seedingStrategy.seed(this.A, this.U, this.V);
        DoubleMatrix2D Aeps = this.A.copy();
        Aeps.assign(Functions.plus((double)eps));
        DenseDoubleMatrix2D UV = new DenseDoubleMatrix2D(m, n);
        DenseDoubleMatrix2D VT = new DenseDoubleMatrix2D(n, this.k);
        DenseDoubleMatrix2D UT = new DenseDoubleMatrix2D(m, this.k);
        double[] work = new double[this.U.columns()];
        DoubleDoubleFunction invDiv = Functions.swapArgs((DoubleDoubleFunction)Functions.DIV);
        DoubleFunction plusEps = Functions.plus((double)eps);
        if (this.stopThreshold >= 0.0) {
            this.updateApproximationError();
        }
        for (int i = 0; i < this.maxIterations; ++i) {
            this.U.zMult(this.V, (DoubleMatrix2D)UV, 1.0, 0.0, false, true);
            UV.assign(plusEps);
            UV.assign(Aeps, invDiv);
            UV.zMult(this.U, (DoubleMatrix2D)VT, 1.0, 0.0, true, false);
            this.V.assign((DoubleMatrix2D)VT, Functions.MULT);
            this.U.zMult(this.V, (DoubleMatrix2D)UV, 1.0, 0.0, false, true);
            UV.assign(plusEps);
            UV.assign(Aeps, invDiv);
            UV.zMult(this.V, (DoubleMatrix2D)UT, 1.0, 0.0, false, false);
            this.U.assign((DoubleMatrix2D)UT, Functions.MULT);
            MatrixUtils.normalizeColumnL1(this.U, work);
            ++this.iterationsCompleted;
            if (this.stopThreshold >= 0.0 && this.updateApproximationError()) break;
        }
        if (this.ordered) {
            this.order();
        }
    }

    public String toString() {
        return "NMF-KL-" + this.seedingStrategy.toString();
    }
}

