/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.extension;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.exception.RelationEntityNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.optional.OptionalObjectExceptionThrower;
import org.seasar.dbflute.optional.RelationOptionalFactory;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;

public class TnRelationRowOptionalHandler {
    private static final Log _log = LogFactory.getLog(TnRelationRowOptionalHandler.class);
    protected final RelationOptionalFactory _relationOptionalFactory;

    public TnRelationRowOptionalHandler(RelationOptionalFactory relationOptionalFactory) {
        this._relationOptionalFactory = relationOptionalFactory;
    }

    public Object filterOptionalRelationRowIfNeeds(Object row, TnRelationPropertyType rpt, Object relationRow) {
        DfPropertyDesc pd;
        Class<?> optionalType = this.getOptionalEntityType();
        if (optionalType.isAssignableFrom((pd = rpt.getPropertyDesc()).getPropertyType())) {
            if (relationRow == null) {
                return this.createOptionalNullEntity(row, rpt);
            }
            if (!optionalType.isInstance(relationRow)) {
                return this.createOptionalPresentEntity(relationRow);
            }
        }
        return relationRow;
    }

    protected Object createOptionalNullEntity(Object row, TnRelationPropertyType rpt) {
        return this._relationOptionalFactory.createOptionalNullEntity(this.createOptionalNullableThrower(row, rpt));
    }

    protected OptionalObjectExceptionThrower createOptionalNullableThrower(final Object row, TnRelationPropertyType rpt) {
        Object parameterBean;
        String outsideSqlPath;
        final String propertyName = rpt.getPropertyDesc().getPropertyName();
        final DBMeta localDBMeta = rpt.getMyBeanMetaData().getDBMeta();
        final ConditionBean cb = ConditionBeanContext.isExistConditionBeanOnThread() ? ConditionBeanContext.getConditionBeanOnThread() : null;
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
            outsideSqlPath = context.getOutsideSqlPath();
            parameterBean = context.getParameterBean();
        } else {
            outsideSqlPath = null;
            parameterBean = null;
        }
        return new OptionalObjectExceptionThrower(){

            @Override
            public void throwNotFoundException() {
                TnRelationRowOptionalHandler.this.throwRelationEntityNotFoundException(row, propertyName, localDBMeta, cb, outsideSqlPath, parameterBean);
            }
        };
    }

    protected void throwRelationEntityNotFoundException(Object row, String propertyName, DBMeta localDBMeta, ConditionBean cb, String outsideSqlPath, Object parameterBean) {
        ExceptionMessageBuilder br;
        block6: {
            String localSuffix;
            br = new ExceptionMessageBuilder();
            br.addNotice("The relation entity was NOT found.");
            br.addItem("Advice");
            br.addElement("Confirm the existence in your business rule.");
            br.addElement("If the relation entity might not exist, ...");
            br.addElement("For example:");
            br.addElement("  (x):");
            br.addElement("    MemberCB cb = new MemberCB();");
            br.addElement("    cb.setupSelect_MemberServiceAsOne();");
            br.addElement("    List<Member> memberList = memberBhv.selectList(cb);");
            br.addElement("    for (Member member : memberList) {");
            br.addElement("        ... = member.getMemberServiceAsOne().get()...; // *No");
            br.addElement("    }");
            br.addElement("  (o):");
            br.addElement("    MemberCB cb = new MemberCB();");
            br.addElement("    cb.setupSelect_MemberServiceAsOne();");
            br.addElement("    List<Member> memberList = memberBhv.selectList(cb);");
            br.addElement("    for (Member member : memberList) {");
            br.addElement("        member.getMemberServiceAsOne().ifPresent(service -> {");
            br.addElement("            ... = service.getServicePointCount(); // OK");
            br.addElement("        });");
            br.addElement("        // and you can use isPresent(), map(), orElseNull(), ...");
            br.addElement("    }");
            br.addItem("Your Operation");
            String localTable = localDBMeta.getTableDbName();
            if (row instanceof Entity) {
                Map<String, Object> pkMap = localDBMeta.extractPrimaryKeyMap((Entity)row);
                localSuffix = pkMap.toString();
            } else {
                localSuffix = "{" + row + "}";
            }
            br.addElement(localTable + ":" + localSuffix + " -> " + propertyName);
            if (cb != null) {
                try {
                    String displaySql = cb.toDisplaySql();
                    br.addItem("ConditionBean");
                    br.addElement(displaySql);
                }
                catch (RuntimeException continued) {
                    if (!_log.isDebugEnabled()) break block6;
                    String tableDbName = cb.getTableDbName();
                    _log.debug((Object)("Failed to get display SQL from the condition-bean for debug: " + tableDbName));
                }
            }
        }
        if (outsideSqlPath != null) {
            br.addItem("OutsideSql");
            br.addElement("path : " + outsideSqlPath);
            br.addElement("pmb  : " + parameterBean);
        }
        String msg = br.buildExceptionMessage();
        throw new RelationEntityNotFoundException(msg);
    }

    protected Object createOptionalPresentEntity(Object relationRow) {
        return this._relationOptionalFactory.createOptionalPresentEntity(relationRow);
    }

    public Class<?> getOptionalEntityType() {
        return this._relationOptionalFactory.getOptionalEntityType();
    }
}

