/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.token.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.token.file.FileMakingCallback;
import org.seasar.dbflute.helper.token.file.FileMakingHeaderInfo;
import org.seasar.dbflute.helper.token.file.FileMakingOption;
import org.seasar.dbflute.helper.token.file.FileMakingRowResource;
import org.seasar.dbflute.helper.token.file.FileMakingRowWriter;
import org.seasar.dbflute.helper.token.file.FileTokenizingCallback;
import org.seasar.dbflute.helper.token.file.FileTokenizingHeaderInfo;
import org.seasar.dbflute.helper.token.file.FileTokenizingOption;
import org.seasar.dbflute.helper.token.file.FileTokenizingRowResource;
import org.seasar.dbflute.helper.token.file.exception.FileMakingInvalidValueCountException;
import org.seasar.dbflute.helper.token.file.exception.FileMakingRequiredOptionNotFoundException;
import org.seasar.dbflute.helper.token.file.exception.FileMakingSQLHandlingFailureException;
import org.seasar.dbflute.helper.token.file.exception.FileTokenizingSQLHandlingFailureException;
import org.seasar.dbflute.helper.token.line.LineMakingOption;
import org.seasar.dbflute.helper.token.line.LineToken;
import org.seasar.dbflute.helper.token.line.LineTokenizingOption;
import org.seasar.dbflute.util.Srl;

public class FileToken {
    protected static final String HEADER_DONE_MARK = "headerDone";
    protected static final String FIRST_LINE_DONE_MARK = "firstLineDone";
    protected final LineToken _lineToken = new LineToken();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenize(String filePath, FileTokenizingCallback callback, FileTokenizingOption option) throws FileNotFoundException, IOException {
        this.assertStringNotNullAndNotTrimmedEmpty("filePath", filePath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            this.tokenize(fis, callback, option);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void tokenize(InputStream ins, FileTokenizingCallback callback, FileTokenizingOption option) throws FileNotFoundException, IOException {
        block26: {
            this.assertObjectNotNull("ins", ins);
            this.assertObjectNotNull("callback", callback);
            this.assertObjectNotNull("option", option);
            delimiter = option.getDelimiter();
            encoding = option.getEncoding();
            this.assertObjectNotNull("delimiter", delimiter);
            this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
            lineString = null;
            preContinueString = "";
            temporaryValueList = new ArrayList<String>();
            filteredValueList = new ArrayList<String>();
            br = null;
            try {
                br = new BufferedReader(new InputStreamReader(ins, encoding));
                realRowStringSb = new StringBuilder();
                headerInfo = null;
                count = -1;
                rowNumber = 1;
                lineNumber = 0;
                while (true) lbl-1000:
                // 5 sources

                {
                    ++count;
                    if ("".equals(preContinueString)) {
                        lineNumber = count + 1;
                    }
                    if ((lineString = br.readLine()) == null) {
                        break block26;
                    }
                    if (count == 0) {
                        if (option.isBeginFirstLine()) {
                            headerInfo = new FileTokenizingHeaderInfo();
                        } else {
                            headerInfo = this.analyzeHeaderInfo(delimiter, lineString);
                            continue;
                        }
                    }
                    if (preContinueString.equals("")) {
                        rowString = lineString;
                        realRowStringSb.append(lineString);
                    } else {
                        lineSeparator = "\n";
                        rowString = preContinueString + "\n" + lineString;
                        realRowStringSb.append("\n").append(lineString);
                    }
                    valueLineInfo = this.arrangeValueList(rowString, delimiter);
                    ls = valueLineInfo.getValueList();
                    if (valueLineInfo.isContinueNextLine()) {
                        preContinueString = ls.remove(ls.size() - 1);
                        temporaryValueList.addAll(ls);
                        continue;
                    }
                    temporaryValueList.addAll(ls);
                    try {
                        resource = new FileTokenizingRowResource();
                        resource.setHeaderInfo(headerInfo);
                        if (option.isHandleEmptyAsNull()) {
                            for (String value : temporaryValueList) {
                                if ("".equals(value)) {
                                    filteredValueList.add(null);
                                    continue;
                                }
                                filteredValueList.add(value);
                            }
                            resource.setValueList(filteredValueList);
                        } else {
                            resource.setValueList(temporaryValueList);
                        }
                        realRowString = realRowStringSb.toString();
                        realRowStringSb.setLength(0);
                        resource.setRowString(realRowString);
                        resource.setRowNumber(rowNumber);
                        resource.setLineNumber(lineNumber);
                        callback.handleRow(resource);
                    }
                    finally {
                        ++rowNumber;
                        temporaryValueList.clear();
                        filteredValueList.clear();
                        preContinueString = "";
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                msg = "SQL handling failed in the row handling process: option=" + option;
                throw new FileTokenizingSQLHandlingFailureException(msg, e);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ignored) {}
            }
            ** GOTO lbl-1000
        }
    }

    protected ValueLineInfo arrangeValueList(String lineString, String delimiter) {
        ArrayList<String> valueList = new ArrayList<String>();
        LineTokenizingOption tokenizingOption = new LineTokenizingOption();
        tokenizingOption.setDelimiter(delimiter);
        List<String> list = this._lineToken.tokenize(lineString, tokenizingOption);
        String[] values = list.toArray(new String[list.size()]);
        for (int i = 0; i < values.length; ++i) {
            valueList.add(values[i]);
        }
        return this.arrangeValueList(valueList, delimiter);
    }

    protected ValueLineInfo arrangeValueList(List<String> valueList, String delimiter) {
        ValueLineInfo valueLineInfo = new ValueLineInfo();
        ArrayList<String> resultList = new ArrayList<String>();
        String preString = "";
        for (int i = 0; i < valueList.size(); ++i) {
            String value = valueList.get(i);
            if (value == null) continue;
            if (i == valueList.size() - 1) {
                if (preString.equals("")) {
                    if (this.isFrontQOnly(value)) {
                        valueLineInfo.setContinueNextLine(true);
                        resultList.add(value);
                        break;
                    }
                    if (this.isRearQOnly(value)) {
                        resultList.add(value);
                        break;
                    }
                    if (this.isNotBothQ(value)) {
                        resultList.add(value);
                        break;
                    }
                    resultList.add(this.removeDoubleQuotation(value));
                    break;
                }
                if (this.endsQuote(value, false)) {
                    resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
                    break;
                }
                valueLineInfo.setContinueNextLine(true);
                resultList.add(this.connectPreString(preString, delimiter, value));
                break;
            }
            if (preString.equals("")) {
                if (this.isFrontQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isRearQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isNotBothQ(value)) {
                    resultList.add(value);
                } else {
                    resultList.add(this.removeDoubleQuotation(value));
                }
            } else if (this.endsQuote(value, false)) {
                resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
            } else {
                preString = this.connectPreString(preString, delimiter, value);
                continue;
            }
            preString = "";
        }
        valueLineInfo.setValueList(resultList);
        return valueLineInfo;
    }

    protected String connectPreString(String preString, String delimiter, String value) {
        if (preString.equals("")) {
            return value;
        }
        return preString + delimiter + value;
    }

    protected boolean isNotBothQ(String value) {
        return !this.isQQ(value) && !value.startsWith("\"") && !this.endsQuote(value, false);
    }

    protected boolean isRearQOnly(String value) {
        return !this.isQQ(value) && !value.startsWith("\"") && this.endsQuote(value, false);
    }

    protected boolean isFrontQOnly(String value) {
        return !this.isQQ(value) && value.startsWith("\"") && !this.endsQuote(value, true);
    }

    protected boolean isQQ(String value) {
        return value.equals("\"\"");
    }

    protected boolean endsQuote(String value, boolean startsQuote) {
        char ch;
        value = startsQuote ? value.substring(1) : value;
        int length = value.length();
        int count = 0;
        for (int i = 0; i < length && (ch = value.charAt(length - (i + 1))) == '\"'; ++i) {
            ++count;
        }
        return count > 0 && this.isOddNumber(count);
    }

    protected boolean isOddNumber(int number) {
        return number % 2 != 0;
    }

    protected String removeDoubleQuotation(String value) {
        if (!value.startsWith("\"") && !value.endsWith("\"")) {
            return value;
        }
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        value = Srl.replace(value, "\"\"", "\"");
        return value;
    }

    protected String removeRightDoubleQuotation(String value) {
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    protected FileTokenizingHeaderInfo analyzeHeaderInfo(String delimiter, String lineString) {
        FileTokenizingHeaderInfo headerInfo = new FileTokenizingHeaderInfo();
        String[] values = lineString.split(delimiter);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i].trim();
            String columnName = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
            headerInfo.addColumnName(columnName);
        }
        headerInfo.setColumnNameRowString(lineString);
        return headerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void make(String filePath, FileMakingCallback callback, FileMakingOption option) throws FileNotFoundException, IOException {
        this.assertStringNotNullAndNotTrimmedEmpty("filePath", filePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            this.doMake(fos, callback, option);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public void make(OutputStream ous, FileMakingCallback callback, FileMakingOption option) throws FileNotFoundException, IOException {
        this.doMake(ous, callback, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMake(OutputStream ous, FileMakingCallback callback, FileMakingOption option) throws FileNotFoundException, IOException {
        this.assertObjectNotNull("ous", ous);
        this.assertObjectNotNull("callback", callback);
        this.assertObjectNotNull("option", option);
        this.assertMakingDelimiter(option);
        this.assertMakingEncoding(option);
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(ous, option.getEncoding()));
            HashSet<String> doneMarkSet = new HashSet<String>(2);
            FileMakingHeaderInfo headerInfo = option.getFileMakingHeaderInfo();
            if (headerInfo != null) {
                List<String> columnNameList = headerInfo.getColumnNameList();
                this.doWriterHeader(writer, columnNameList, option, doneMarkSet);
            }
            LineMakingOption lineOption = this.prepareWritingLineOption(option);
            String lineSep = this.prepareWritingLineSeparator(option);
            this.callbackDataRowWriter(callback, option, lineSep, lineOption, writer, doneMarkSet);
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void doWriterHeader(Writer writer, List<String> columnNameList, FileMakingOption option, Set<String> doneMarkSet) throws IOException {
        if (doneMarkSet.contains(HEADER_DONE_MARK)) {
            return;
        }
        if (columnNameList != null && !columnNameList.isEmpty()) {
            LineMakingOption lineMakingOption = new LineMakingOption();
            lineMakingOption.setDelimiter(option.getDelimiter());
            lineMakingOption.trimSpace();
            this.reflectQuoteMinimally(option, lineMakingOption);
            String columnHeaderString = this._lineToken.make(columnNameList, lineMakingOption);
            writer.write(columnHeaderString);
            doneMarkSet.add(HEADER_DONE_MARK);
            doneMarkSet.add(FIRST_LINE_DONE_MARK);
        }
    }

    protected void callbackDataRowWriter(FileMakingCallback callback, final FileMakingOption option, final String lineSep, final LineMakingOption lineOption, final Writer writer, final Set<String> doneMarkSet) throws IOException {
        final FileMakingRowResource resource = new FileMakingRowResource();
        try {
            callback.write(new FileMakingRowWriter(){

                @Override
                public void writeRow(List<String> valueList) throws IOException {
                    this.writeRow(resource.acceptRow(valueList));
                }

                @Override
                public void writeRow(Map<String, String> columnValueMap) throws IOException {
                    this.writeRow(resource.acceptRow(columnValueMap));
                }

                protected void writeRow(FileMakingRowResource resource2) throws IOException {
                    this.assertRowResourceOfWriter(resource2);
                    FileToken.this.doWriteDataRow(writer, resource2, option, lineOption, lineSep, doneMarkSet);
                }

                protected void assertRowResourceOfWriter(FileMakingRowResource resource2) {
                    if (resource2 == null || !resource2.hasRowData()) {
                        String msg = "The argument 'resource' of row writer should not be null.";
                        throw new IllegalArgumentException(msg);
                    }
                }
            });
        }
        catch (SQLException e) {
            String msg = "SQL handling failed in the row writing process: option=" + option;
            throw new FileMakingSQLHandlingFailureException(msg, e);
        }
    }

    protected void doWriteDataRow(Writer writer, FileMakingRowResource resource, FileMakingOption option, LineMakingOption lineOption, String lineSep, Set<String> doneMarkSet) throws IOException {
        List<String> valueList;
        if (!resource.hasRowData()) {
            return;
        }
        if (resource.hasValueList()) {
            valueList = resource.getValueList();
        } else if (resource.hasValueMap()) {
            Map<String, String> valueMap = resource.getValueMap();
            if (!doneMarkSet.contains(HEADER_DONE_MARK)) {
                ArrayList<String> columnNameList = new ArrayList<String>(valueMap.keySet());
                option.headerInfo(columnNameList);
                this.doWriterHeader(writer, columnNameList, option, doneMarkSet);
                doneMarkSet.add(HEADER_DONE_MARK);
            }
            FileMakingHeaderInfo headerInfo = option.getFileMakingHeaderInfo();
            List<String> columnNameList = headerInfo.getColumnNameList();
            valueList = new ArrayList<String>(columnNameList.size());
            for (String columnName : columnNameList) {
                valueList.add(valueMap.get(columnName));
            }
        } else {
            String msg = "Either value list or value map is required: " + resource;
            throw new IllegalStateException(msg);
        }
        this.checkValueCount(option, valueList);
        String lineString = this._lineToken.make(valueList, lineOption);
        String actualLine = doneMarkSet.contains(FIRST_LINE_DONE_MARK) ? lineSep + lineString : lineString;
        writer.write(actualLine);
        doneMarkSet.add(FIRST_LINE_DONE_MARK);
        resource.clear();
    }

    protected String prepareWritingLineSeparator(FileMakingOption option) {
        String lineSep = option.getLineSeparator() != null && !option.getLineSeparator().equals("") ? option.getLineSeparator() : "\n";
        return lineSep;
    }

    protected LineMakingOption prepareWritingLineOption(FileMakingOption option) {
        LineMakingOption lineOption = new LineMakingOption();
        lineOption.setDelimiter(option.getDelimiter());
        this.reflectQuoteMinimally(option, lineOption);
        return lineOption;
    }

    protected void reflectQuoteMinimally(FileMakingOption fileMakingOption, LineMakingOption lineMakingOption) {
        if (fileMakingOption.isQuoteMinimally()) {
            lineMakingOption.quoteMinimally();
        } else {
            lineMakingOption.quoteAll();
        }
    }

    protected void checkValueCount(FileMakingOption option, List<String> valueList) {
        int valueSize;
        if (option.isSuppressValueCountCheck()) {
            return;
        }
        FileMakingHeaderInfo headerInfo = option.getFileMakingHeaderInfo();
        if (headerInfo == null) {
            return;
        }
        List<String> columnNameList = headerInfo.getColumnNameList();
        if (columnNameList == null || columnNameList.isEmpty()) {
            return;
        }
        int columnSize = columnNameList.size();
        if (columnSize != (valueSize = valueList.size())) {
            this.throwFileMakingInvalidValueCountException(columnNameList, valueList);
        }
    }

    protected void throwFileMakingInvalidValueCountException(List<String> columnNameList, List<String> valueList) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The value count of the row does not match column count of header.");
        br.addItem("Column List");
        br.addElement(columnNameList);
        br.addElement("column count: " + columnNameList.size());
        br.addItem("Value List");
        br.addElement(valueList);
        br.addElement("value count: " + valueList.size());
        String msg = br.buildExceptionMessage();
        throw new FileMakingInvalidValueCountException(msg);
    }

    protected void assertMakingDelimiter(FileMakingOption option) {
        String delimiter = option.getDelimiter();
        if (delimiter != null) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The option of delimiter for FileToken is required.");
        br.addItem("Advice");
        br.addElement("You should specify delimiter by option.");
        br.addElement("For example:");
        br.addElement("  (x): new FileMakingOption().encodeAsUTF8()");
        br.addElement("  (o): new FileMakingOption().delimitateByTab().encodeAsUTF8()");
        br.addItem("Option");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new FileMakingRequiredOptionNotFoundException(msg);
    }

    protected void assertMakingEncoding(FileMakingOption option) {
        String encoding = option.getEncoding();
        if (encoding != null && encoding.trim().length() > 0) {
            return;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The option of encoding for FileToken is required.");
        br.addItem("Advice");
        br.addElement("You should specify delimiter by option.");
        br.addElement("For example:");
        br.addElement("  (x): new FileMakingOption().delimitateByTab()");
        br.addElement("  (o): new FileMakingOption().delimitateByTab().encodeAsUTF8()");
        br.addItem("Option");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new FileMakingRequiredOptionNotFoundException(msg);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public static class ValueLineInfo {
        protected List<String> _valueList;
        protected boolean _continueNextLine;

        public List<String> getValueList() {
            return this._valueList;
        }

        public void setValueList(List<String> valueList) {
            this._valueList = valueList;
        }

        public boolean isContinueNextLine() {
            return this._continueNextLine;
        }

        public void setContinueNextLine(boolean continueNextLine) {
            this._continueNextLine = continueNextLine;
        }
    }
}

