/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.filesystem;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.filesystem.FileTextLineFilter;
import org.seasar.dbflute.helper.filesystem.FileTextWholeFilter;
import org.seasar.dbflute.util.Srl;

public class FileTextIO {
    protected String _encoding;

    public String read(InputStream ins) {
        this.assertState();
        this.assertObjectNotNull("ins", ins);
        try {
            return this.readTextClosed(ins);
        }
        catch (IOException e) {
            return this.handleInputStreamReadFailureException(ins, e);
        }
    }

    public String read(String textPath) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        try {
            return this.readTextClosed(this.createFileInputStream(textPath));
        }
        catch (IOException e) {
            return this.handleTextFileReadFailureException(textPath, e);
        }
    }

    public String readFilteringLine(String textPath, FileTextLineFilter filter) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("filter", filter);
        try {
            return this.filterAsLine(this.readTextClosed(this.createFileInputStream(textPath)), filter);
        }
        catch (IOException e) {
            return this.handleTextFileReadFailureException(textPath, e);
        }
    }

    public String readFilteringLine(InputStream ins, FileTextLineFilter filter) {
        this.assertState();
        this.assertObjectNotNull("ins", ins);
        this.assertObjectNotNull("filter", filter);
        try {
            return this.filterAsLine(this.readTextClosed(ins), filter);
        }
        catch (IOException e) {
            return this.handleInputStreamReadFailureException(ins, e);
        }
    }

    public String readFilteringWhole(String textPath, FileTextWholeFilter filter) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("filter", filter);
        try {
            return this.filterAsWhole(this.readTextClosed(this.createFileInputStream(textPath)), filter);
        }
        catch (IOException e) {
            return this.handleTextFileReadFailureException(textPath, e);
        }
    }

    public String readFilteringWhole(InputStream ins, FileTextWholeFilter filter) {
        this.assertState();
        this.assertObjectNotNull("ins", ins);
        this.assertObjectNotNull("filter", filter);
        try {
            return this.filterAsWhole(this.readTextClosed(ins), filter);
        }
        catch (IOException e) {
            return this.handleInputStreamReadFailureException(ins, e);
        }
    }

    public String rewriteFilteringLine(String textPath, FileTextLineFilter filter) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("filter", filter);
        String read = this.readFilteringLine(textPath, filter);
        this.write(textPath, read);
        return read;
    }

    public String rewriteFilteringLine(String textPath, FileTextWholeFilter filter) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("filter", filter);
        String read = this.readFilteringWhole(textPath, filter);
        this.write(textPath, read);
        return read;
    }

    public void write(OutputStream ous, String text) {
        this.assertState();
        this.assertObjectNotNull("ous", ous);
        this.assertStringNotNullAndNotTrimmedEmpty("text", text);
        this.writeTextClosed(ous, text);
    }

    public void write(String textPath, String text) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertStringNotNullAndNotTrimmedEmpty("text", text);
        this.writeTextClosed(this.createFileOutputStream(textPath), text);
    }

    public String writeFilteringLine(String textPath, String text, FileTextLineFilter filter) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertStringNotNullAndNotTrimmedEmpty("text", text);
        String filtered = this.filterAsLine(text, filter);
        this.writeTextClosed(this.createFileOutputStream(textPath), filtered);
        return filtered;
    }

    public String writeFilteringLine(OutputStream ous, String text, FileTextLineFilter filter) {
        this.assertState();
        this.assertObjectNotNull("ous", ous);
        this.assertStringNotNullAndNotTrimmedEmpty("text", text);
        String filtered = this.filterAsLine(text, filter);
        this.writeTextClosed(ous, filtered);
        return filtered;
    }

    public String writeFilteringLine(String textPath, String text, FileTextWholeFilter filter) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertStringNotNullAndNotTrimmedEmpty("text", text);
        String filtered = this.filterAsWhole(text, filter);
        this.writeTextClosed(this.createFileOutputStream(textPath), filtered);
        return filtered;
    }

    public String writeFilteringLine(OutputStream ous, String text, FileTextWholeFilter filter) {
        this.assertState();
        this.assertObjectNotNull("ous", ous);
        this.assertStringNotNullAndNotTrimmedEmpty("text", text);
        String filtered = this.filterAsWhole(text, filter);
        this.writeTextClosed(ous, filtered);
        return filtered;
    }

    public FileTextIO encodeAsUTF8() {
        this._encoding = "UTF-8";
        return this;
    }

    public FileTextIO encodeAsWindows31J() {
        this._encoding = "Windows-31J";
        return this;
    }

    protected FileInputStream createFileInputStream(String textPath) {
        try {
            return new FileInputStream(textPath);
        }
        catch (FileNotFoundException e) {
            String msg = "Not found the text file: " + textPath;
            throw new IllegalStateException(msg, e);
        }
    }

    protected FileOutputStream createFileOutputStream(String textPath) {
        try {
            return new FileOutputStream(textPath);
        }
        catch (FileNotFoundException e) {
            String msg = "Not found the text file: " + textPath;
            throw new IllegalStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytesClosed(InputStream ins) throws IOException {
        try {
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            int next = 0;
            while ((next = ins.read(buffer, 0, buffer.length)) != -1) {
                ous.write(buffer, 0, next);
            }
            byte[] byArray = ous.toByteArray();
            return byArray;
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    protected String readTextClosed(InputStream ins) throws IOException {
        byte[] bytes = this.readBytesClosed(ins);
        try {
            return new String(bytes, this._encoding);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unknown encoding: " + this._encoding;
            throw new IllegalStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTextClosed(OutputStream ous, String text) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(ous, this._encoding));
            writer.write(text);
            writer.flush();
            this.close(writer);
        }
        catch (IOException e) {
            try {
                this.handleOutputStreamWriteFailureException(ous, e);
                this.close(writer);
            }
            catch (Throwable throwable) {
                this.close(writer);
                throw throwable;
            }
        }
    }

    protected void close(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void close(BufferedWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void handleOutputStreamWriteFailureException(OutputStream ous, IOException e) {
        String msg = "Failed to write the text to the output stream: " + ous;
        throw new IllegalStateException(msg, e);
    }

    protected void handleTextFileWriteFailureException(String textPath, IOException e) {
        String msg = "Failed to write the text file: " + textPath;
        throw new IllegalStateException(msg, e);
    }

    protected String handleInputStreamReadFailureException(InputStream ins, IOException e) {
        String msg = "Failed to read the input stream: " + ins;
        throw new IllegalStateException(msg, e);
    }

    protected String handleTextFileReadFailureException(String textPath, IOException e) {
        String msg = "Failed to read the text file: " + textPath;
        throw new IllegalStateException(msg, e);
    }

    protected String filterAsLine(String text, FileTextLineFilter filter) {
        String cr = "\r";
        String lf = "\n";
        StringBuilder sb = new StringBuilder();
        List<String> lineList = Srl.splitList(text, "\n");
        int lineCount = lineList.size();
        int index = 0;
        for (String line : lineList) {
            boolean hasCR;
            String pureLine;
            if (line.endsWith("\r")) {
                pureLine = Srl.substringLastFront(line, "\r");
                hasCR = true;
            } else {
                pureLine = line;
                hasCR = false;
            }
            String filteredLine = filter.filter(pureLine);
            if (filteredLine != null) {
                sb.append(filteredLine);
                if (index + 1 < lineCount) {
                    sb.append(hasCR ? "\r" : "").append("\n");
                }
            }
            ++index;
        }
        return sb.toString();
    }

    protected String filterAsWhole(String text, FileTextWholeFilter filter) {
        String filtered = filter.filter(text);
        return filtered != null ? filtered : "";
    }

    protected void assertState() {
        if (this._encoding == null || this._encoding.trim().length() == 0) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the encoding for the file.");
            br.addItem("Advice");
            br.addElement("You should specify 'encoding' like this:");
            br.addElement("  (o):");
            br.addElement("    FileTextIO textIO = new FileTextIO().encodeAsUTF8();");
            String msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }
}

