/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.exception.SpecifyDerivedReferrerUnknownAliasNameException;
import org.seasar.dbflute.exception.UndefinedClassificationCodeException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ClassificationMeta;
import org.seasar.dbflute.jdbc.ClassificationUndefinedHandlingType;
import org.seasar.dbflute.jdbc.ParameterUtil;
import org.seasar.dbflute.util.DfTypeUtil;

public interface Entity {
    public DBMeta getDBMeta();

    public String getTableDbName();

    public String getTablePropertyName();

    public boolean hasPrimaryKeyValue();

    public Set<String> myuniqueDrivenProperties();

    public Set<String> modifiedProperties();

    public void clearModifiedInfo();

    public boolean hasModification();

    public void markAsSelect();

    public boolean createdBySelect();

    public int instanceHash();

    public String toStringWithRelation();

    public String buildDisplayString(String var1, boolean var2, boolean var3);

    public static final class FunCustodial {
        private static final Log _clsMetaLog = LogFactory.getLog(ClassificationMeta.class);

        public static <NUMBER extends Number> NUMBER toNumber(Object obj, Class<NUMBER> type) {
            return (NUMBER)DfTypeUtil.toNumber(obj, type);
        }

        public static Boolean toBoolean(Object obj) {
            return DfTypeUtil.toBoolean(obj);
        }

        public static boolean isSameValue(Object value1, Object value2) {
            if (value1 == null && value2 == null) {
                return true;
            }
            if (value1 == null || value2 == null) {
                return false;
            }
            if (value1 instanceof byte[] && value2 instanceof byte[]) {
                return FunCustodial.isSameValueBytes((byte[])value1, (byte[])value2);
            }
            return value1.equals(value2);
        }

        public static boolean isSameValueBytes(byte[] bytes1, byte[] bytes2) {
            if (bytes1 == null && bytes2 == null) {
                return true;
            }
            if (bytes1 == null || bytes2 == null) {
                return false;
            }
            if (bytes1.length != bytes2.length) {
                return false;
            }
            for (int i = 0; i < bytes1.length; ++i) {
                if (bytes1[i] == bytes2[i]) continue;
                return false;
            }
            return true;
        }

        public static int calculateHashcode(int result, Object value) {
            if (value == null) {
                return result;
            }
            return 31 * result + (value instanceof byte[] ? ((byte[])value).length : value.hashCode());
        }

        public static String convertEmptyToNull(String value) {
            return ParameterUtil.convertEmptyToNull(value);
        }

        public static String toClassTitle(Object entity) {
            return DfTypeUtil.toClassTitle(entity);
        }

        public static String toString(Date date, String pattern) {
            if (date == null) {
                return null;
            }
            String str = DfTypeUtil.toString(date, pattern);
            return (DfTypeUtil.isDateBC(date) ? "BC" : "") + str;
        }

        public static String toString(byte[] bytes) {
            return "byte[" + (bytes != null ? String.valueOf(bytes.length) : "null") + "]";
        }

        public static void checkClassificationCode(Entity entity, String columnDbName, ClassificationMeta meta, Object code) {
            if (code == null) {
                return;
            }
            ClassificationUndefinedHandlingType undefinedHandlingType = meta.undefinedHandlingType();
            if (!undefinedHandlingType.isChecked()) {
                return;
            }
            if (meta.codeOf(code) != null) {
                return;
            }
            FunCustodial.handleUndefinedClassificationCode(entity.getTableDbName(), columnDbName, meta, code);
        }

        public static void handleUndefinedClassificationCode(String tableDbName, String columnDbName, ClassificationMeta meta, Object code) {
            ClassificationUndefinedHandlingType undefinedHandlingType = meta.undefinedHandlingType();
            if (ClassificationUndefinedHandlingType.EXCEPTION.equals((Object)undefinedHandlingType)) {
                FunCustodial.throwUndefinedClassificationCodeException(tableDbName, columnDbName, meta, code);
            } else if (ClassificationUndefinedHandlingType.LOGGING.equals((Object)undefinedHandlingType)) {
                FunCustodial.showUndefinedClassificationCodeMessage(tableDbName, columnDbName, meta, code);
            }
        }

        public static void throwUndefinedClassificationCodeException(String tableDbName, String columnDbName, ClassificationMeta meta, Object code) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Undefined classification code was set to the entity.");
            br.addItem("Advice");
            br.addElement("Confirm the value of the classication column on your database,");
            br.addElement("or setting value to your entity.");
            br.addElement("The code is NOT one of classification code defined on DBFlute.");
            br.addElement("");
            br.addElement("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
            br.addElement(" Use formal code!");
            br.addElement("  Or add the code to classification definition.");
            br.addElement("_/_/_/_/_/_/_/_/_/_/");
            br.addElement("");
            br.addElement("Or if you (reluctantly) need to allow it, change the option like this:");
            br.addElement("but *Deprecated");
            br.addElement("(classificationDefinitionMap.dfprop)");
            br.addElement("    ; [classification-name] = list:{");
            br.addElement("        ; map:{");
            br.addElement("            ; topComment=...; codeType=...");
            br.addElement("            ; undefinedHandlingType=ALLOWED");
            br.addElement("        }");
            br.addElement("        map:{...}");
            br.addElement("    }");
            br.addElement("*for your information, the default of undefinedHandlingType is LOGGING");
            br.addItem("Table");
            br.addElement(tableDbName);
            br.addItem("Column");
            br.addElement(columnDbName);
            br.addItem("Classification");
            br.addElement(meta.classificationName());
            List<Classification> listAll = meta.listAll();
            StringBuilder sb = new StringBuilder();
            for (Classification cls : listAll) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(cls.name()).append("(").append(cls.code()).append(")");
            }
            br.addElement(sb.toString());
            br.addItem("Undefined Code");
            br.addElement(code);
            String msg = br.buildExceptionMessage();
            throw new UndefinedClassificationCodeException(msg);
        }

        public static void showUndefinedClassificationCodeMessage(String tableDbName, String columnDbName, ClassificationMeta meta, Object code) {
            if (_clsMetaLog.isInfoEnabled()) {
                String classificationName = meta.classificationName();
                String exp = tableDbName + "." + columnDbName + "->" + classificationName + "." + code;
                _clsMetaLog.info((Object)("*Undefined classification code was set: " + exp));
            }
        }
    }

    public static class EntityDerivedMap
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Map<String, Object> _derivedMap;

        public void registerDerivedValue(String aliasName, Object selectedValue) {
            this.getDerivedMap().put(aliasName, selectedValue);
        }

        public <VALUE> VALUE findDerivedValue(String aliasName) {
            if (aliasName == null) {
                throw new IllegalArgumentException("The argument 'aliasName' should not be null.");
            }
            Map<String, Object> derivedMap = this.getDerivedMap();
            if (!derivedMap.containsKey(aliasName)) {
                this.throwUnknownAliasNameException(aliasName, derivedMap);
            }
            Object found = derivedMap.get(aliasName);
            return (VALUE)found;
        }

        protected void throwUnknownAliasNameException(String aliasName, Map<String, Object> derivedMap) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the alias name in the derived map");
            br.addItem("Advice");
            br.addElement("Make sure your alias name to find the derived value.");
            br.addElement("You should specify the name specified as DerivedReferrer.");
            br.addElement("For example:");
            br.addElement("  (o):");
            br.addElement("    MemberCB cb = new MemberCB();");
            br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
            br.addElement("        purchaseCB.specify().columnPurchasePrice();");
            br.addElement("    }, Member.ALIAS_highestPurchasePrice);");
            br.addElement("    ...");
            br.addElement("    Member member = ...");
            br.addElement("    Integer price = member.derived(Member.ALIAS_dynamicPurchasePanther); // *NG");
            br.addElement("  (o):");
            br.addElement("    MemberCB cb = new MemberCB();");
            br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
            br.addElement("        purchaseCB.specify().columnPurchasePrice();");
            br.addElement("    }, Member.ALIAS_highestPurchasePrice);");
            br.addElement("    ...");
            br.addElement("    Member member = ...");
            br.addElement("    Integer price = member.derived(Member.ALIAS_highestPurchasePrice); // OK");
            br.addItem("Alias Name");
            br.addElement(aliasName);
            br.addItem("Derived Map");
            br.addElement(derivedMap.keySet());
            String msg = br.buildExceptionMessage();
            throw new SpecifyDerivedReferrerUnknownAliasNameException(msg);
        }

        public boolean isEmpty() {
            return this.getDerivedMap().isEmpty();
        }

        public void clear() {
            this.getDerivedMap().clear();
        }

        public void remove(String aliasName) {
            this.getDerivedMap().remove(aliasName);
        }

        protected Map<String, Object> getDerivedMap() {
            if (this._derivedMap == null) {
                this._derivedMap = new HashMap<String, Object>();
            }
            return this._derivedMap;
        }
    }

    public static class EntityModifiedProperties
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Set<String> _propertyNameSet;

        public void addPropertyName(String propertyName) {
            this.getPropertyNameSet().add(propertyName);
        }

        public Set<String> getPropertyNames() {
            return this.getPropertyNameSet();
        }

        public boolean isEmpty() {
            return this.getPropertyNameSet().isEmpty();
        }

        public void clear() {
            this.getPropertyNameSet().clear();
        }

        public void remove(String propertyName) {
            this.getPropertyNameSet().remove(propertyName);
        }

        public void accept(EntityModifiedProperties properties) {
            this.clear();
            for (String propertyName : properties.getPropertyNames()) {
                this.addPropertyName(propertyName);
            }
        }

        protected Set<String> getPropertyNameSet() {
            if (this._propertyNameSet == null) {
                this._propertyNameSet = new LinkedHashSet<String>();
            }
            return this._propertyNameSet;
        }
    }

    public static class EntityUniqueDrivenProperties
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Set<String> _propertyNameSet;

        public void addPropertyName(String propertyName) {
            this.getPropertyNameSet().add(propertyName);
        }

        public Set<String> getPropertyNames() {
            return this.getPropertyNameSet();
        }

        public boolean isEmpty() {
            return this.getPropertyNameSet().isEmpty();
        }

        public void clear() {
            this.getPropertyNameSet().clear();
        }

        public void remove(String propertyName) {
            this.getPropertyNameSet().remove(propertyName);
        }

        public void accept(EntityModifiedProperties properties) {
            this.clear();
            for (String propertyName : properties.getPropertyNames()) {
                this.addPropertyName(propertyName);
            }
        }

        protected Set<String> getPropertyNameSet() {
            if (this._propertyNameSet == null) {
                this._propertyNameSet = new LinkedHashSet<String>(2);
            }
            return this._propertyNameSet;
        }
    }
}

