/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.coll;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.coll.CollationDataReader;
import com.ibm.icu.impl.coll.CollationRoot;
import com.ibm.icu.impl.coll.CollationTailoring;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollationLoader {
    private static volatile String rootRules = null;

    private CollationLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRootRules() {
        if (rootRules != null) {
            return;
        }
        Class<CollationLoader> clazz = CollationLoader.class;
        synchronized (CollationLoader.class) {
            if (rootRules == null) {
                UResourceBundle rootBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt53b/coll", ULocale.ROOT);
                rootRules = rootBundle.getString("UCARules");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String getRootRules() {
        CollationLoader.loadRootRules();
        return rootRules;
    }

    static String loadRules(ULocale locale, CharSequence collationType) {
        UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt53b/coll", locale);
        ICUResourceBundle data = ((ICUResourceBundle)bundle).getWithFallback("collations/" + collationType);
        String rules = data.getString("Sequence");
        return rules;
    }

    private static final UResourceBundle getWithFallback(UResourceBundle table, String entryName) {
        try {
            return ((ICUResourceBundle)table).getWithFallback(entryName);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static CollationTailoring loadTailoring(ULocale locale, Output<ULocale> outValidLocale) {
        UResourceBundle data;
        UResourceBundle collations;
        CollationTailoring root = CollationRoot.getRoot();
        String localeName = locale.getName();
        if (localeName.length() == 0 || localeName.equals("root")) {
            outValidLocale.value = ULocale.ROOT;
            return root;
        }
        UResourceBundle bundle = null;
        try {
            bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt53b/coll", locale);
        }
        catch (MissingResourceException e) {
            outValidLocale.value = ULocale.ROOT;
            return root;
        }
        ULocale validLocale = bundle.getULocale();
        String validLocaleName = validLocale.getName();
        if (validLocaleName.length() == 0 || validLocaleName.equals("root")) {
            validLocale = ULocale.ROOT;
        }
        outValidLocale.value = validLocale;
        try {
            collations = ((ICUResourceBundle)bundle).get("collations");
            if (collations == null) {
                return root;
            }
        }
        catch (MissingResourceException ignored) {
            return root;
        }
        String type = locale.getKeywordValue("collation");
        String defaultType = "standard";
        try {
            String defT = ((ICUResourceBundle)collations).getStringWithFallback("default");
            if (defT != null) {
                defaultType = defT;
            }
        }
        catch (MissingResourceException ignored) {
            // empty catch block
        }
        if (type == null || type.equals("default")) {
            type = defaultType;
        }
        if ((data = CollationLoader.getWithFallback(collations, type)) == null && type.length() > 6 && type.startsWith("search")) {
            type = "search";
            data = CollationLoader.getWithFallback(collations, type);
        }
        if (data == null && !type.equals(defaultType)) {
            type = defaultType;
            data = CollationLoader.getWithFallback(collations, type);
        }
        if (data == null && !type.equals("standard")) {
            type = "standard";
            data = CollationLoader.getWithFallback(collations, type);
        }
        if (data == null) {
            return root;
        }
        ULocale actualLocale = data.getULocale();
        String actualLocaleName = actualLocale.getName();
        if (actualLocaleName.length() == 0 || actualLocaleName.equals("root")) {
            actualLocale = ULocale.ROOT;
            if (type.equals("standard")) {
                return root;
            }
        }
        CollationTailoring t = new CollationTailoring(root.settings);
        t.actualLocale = actualLocale;
        UResourceBundle binary = ((ICUResourceBundle)data).get("%%CollationBin");
        byte[] inBytes = binary.getBinary(null);
        ByteArrayInputStream inStream = new ByteArrayInputStream(inBytes);
        try {
            CollationDataReader.read(root, inStream, t);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Failed to load collation tailoring data for locale:" + actualLocale + " type:" + type, e);
        }
        try {
            String s = ((ICUResourceBundle)data).getString("Sequence");
            if (s != null) {
                t.rules = s;
            }
        }
        catch (MissingResourceException ignored) {
            // empty catch block
        }
        if (!type.equals(defaultType)) {
            outValidLocale.value = validLocale.setKeywordValue("collation", type);
        }
        if (!actualLocale.equals(validLocale)) {
            UResourceBundle actualBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt53b/coll", actualLocale);
            try {
                String defT = ((ICUResourceBundle)actualBundle).getStringWithFallback("collations/default");
                if (defT != null) {
                    defaultType = defT;
                }
            }
            catch (MissingResourceException ignored) {
                // empty catch block
            }
        }
        if (!type.equals(defaultType)) {
            t.actualLocale = t.actualLocale.setKeywordValue("collation", type);
        }
        return t;
    }
}

