/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractByteSet
extends AbstractSet {
    public boolean contains(final byte key) {
        return !this.forEachKey(new ByteProcedure(){

            public boolean apply(byte iterKey) {
                return key != iterKey;
            }
        });
    }

    public AbstractByteSet copy() {
        return (AbstractByteSet)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractByteSet)) {
            return false;
        }
        final AbstractByteSet other = (AbstractByteSet)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachKey(new ByteProcedure(){

            public boolean apply(byte key) {
                return other.contains(key);
            }
        });
    }

    public abstract boolean forEachKey(ByteProcedure var1);

    public ByteArrayList keys() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            public boolean apply(byte key) {
                list.add(key);
                return true;
            }
        });
    }

    public abstract boolean add(byte var1);

    public abstract boolean remove(byte var1);

    public String toString() {
        ByteArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }
}

