/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class SuggestResponse
implements Map<String, List<String>> {
    protected String searchQuery;
    protected long execTime;
    private final Map<String, List<String>> parent = new LinkedHashMap<String, List<String>>();

    public SuggestResponse(QueryResponse queryResponse, int num, String query) {
        if (queryResponse != null) {
            this.parent.put(query, new SuggestResponseList(queryResponse, query));
            this.setSearchQuery(query);
        }
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public long getExecTime() {
        return this.execTime;
    }

    public void setExecTime(long execTime) {
        this.execTime = execTime;
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public boolean isEmpty() {
        return this.parent.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.parent.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.parent.containsValue(value);
    }

    @Override
    public List<String> get(Object key) {
        return this.parent.get(key);
    }

    @Override
    public List<String> put(String key, List<String> value) {
        return this.parent.put(key, value);
    }

    @Override
    public List<String> remove(Object key) {
        return this.parent.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.parent.putAll(m);
    }

    @Override
    public void clear() {
        this.parent.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.parent.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.parent.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.parent.entrySet();
    }

    public String toString() {
        return "SuggestResponse [searchQuery=" + this.searchQuery + ", execTime=" + this.execTime + ", parent=" + this.parent + "]";
    }

    public static class SuggestResponseList
    implements List<String> {
        private List<String> parent;
        private final List<Integer> frequencies;
        private final int frequency;
        private final String token;
        private final int startOffset;
        private final int endOffset;
        private final int numFound;

        public SuggestResponseList(QueryResponse queryResponse, String query) {
            ArrayList<String> valueList = new ArrayList<String>();
            ArrayList<Integer> frequencyList = new ArrayList<Integer>();
            SolrDocumentList sdList = queryResponse.getResults();
            for (SolrDocument sd : sdList) {
                Object text = sd.getFieldValue("text_s");
                Object freq = sd.getFieldValue("count_i");
                if (text == null || freq == null) continue;
                valueList.add(text.toString());
                frequencyList.add(Integer.parseInt(freq.toString()));
            }
            this.parent = valueList;
            this.frequencies = frequencyList;
            this.frequency = 1;
            this.token = query;
            this.startOffset = 0;
            this.endOffset = query.length();
            this.numFound = (int)queryResponse.getResults().getNumFound();
        }

        public SuggestResponseList(SpellCheckResponse.Suggestion suggestion) {
            this.parent = suggestion.getAlternatives();
            if (this.parent == null) {
                this.parent = Collections.emptyList();
            }
            this.frequencies = suggestion.getAlternativeFrequencies();
            this.frequency = suggestion.getOriginalFrequency();
            this.token = suggestion.getToken();
            this.startOffset = suggestion.getStartOffset();
            this.endOffset = suggestion.getEndOffset();
            this.numFound = suggestion.getNumFound();
        }

        public List<Integer> getFrequencies() {
            return this.frequencies;
        }

        public int getFrequency() {
            return this.frequency;
        }

        public String getToken() {
            return this.token;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getNumFound() {
            return this.numFound;
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public boolean isEmpty() {
            return this.parent.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.parent.contains(o);
        }

        @Override
        public Iterator<String> iterator() {
            return this.parent.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.parent.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.parent.toArray(a);
        }

        @Override
        public boolean add(String e) {
            return this.parent.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.parent.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.parent.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            return this.parent.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends String> c) {
            return this.parent.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.parent.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.parent.retainAll(c);
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public String get(int index) {
            return this.parent.get(index);
        }

        @Override
        public String set(int index, String element) {
            return this.parent.set(index, element);
        }

        @Override
        public void add(int index, String element) {
            this.parent.add(index, element);
        }

        @Override
        public String remove(int index) {
            return this.parent.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.parent.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.parent.lastIndexOf(o);
        }

        @Override
        public ListIterator<String> listIterator() {
            return this.parent.listIterator();
        }

        @Override
        public ListIterator<String> listIterator(int index) {
            return this.parent.listIterator(index);
        }

        @Override
        public List<String> subList(int fromIndex, int toIndex) {
            return this.parent.subList(fromIndex, toIndex);
        }

        public String toString() {
            return "SuggestResponseList [parent=" + this.parent + ", frequencies=" + this.frequencies + ", frequency=" + this.frequency + ", token=" + this.token + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", numFound=" + this.numFound + "]";
        }
    }
}

