/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.trans.XPathException;

public class StylesheetFunctionLibrary
implements FunctionLibrary {
    private PrincipalStylesheetModule stylesheet;
    private boolean overriding;

    public StylesheetFunctionLibrary(PrincipalStylesheetModule sheet, boolean overriding) {
        this.stylesheet = sheet;
        this.overriding = overriding;
    }

    public boolean isOverriding() {
        return this.overriding;
    }

    public Expression bind(StructuredQName functionName, int arity, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        XSLFunction fn = this.stylesheet.getFunction(functionName, staticArgs.length);
        if (fn == null) {
            return null;
        }
        if (fn.isOverriding() != this.overriding) {
            return null;
        }
        UserFunctionCall fc = new UserFunctionCall();
        fn.registerReference(fc);
        fc.setFunctionName(functionName);
        fc.setArguments(staticArgs);
        fc.setContainer(container);
        return fc;
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        return this.stylesheet.getFunction(functionName, arity) != null;
    }

    public FunctionLibrary copy() {
        return this;
    }
}

