/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;

public class PDFParserConfig
implements Serializable {
    private static final long serialVersionUID = 6492570218190936986L;
    private boolean enableAutoSpace = true;
    private boolean suppressDuplicateOverlappingText;
    private boolean extractAnnotationText = true;
    private boolean sortByPosition = false;
    private boolean useNonSequentialParser = false;
    private boolean extractAcroFormContent = true;

    public PDFParserConfig() {
        this.init(this.getClass().getResourceAsStream("PDFParser.properties"));
    }

    public PDFParserConfig(InputStream is) {
        this.init(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream is) {
        if (is == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        this.setEnableAutoSpace(this.getProp(props.getProperty("enableAutoSpace"), this.getEnableAutoSpace()));
        this.setSuppressDuplicateOverlappingText(this.getProp(props.getProperty("suppressDuplicateOverlappingText"), this.getSuppressDuplicateOverlappingText()));
        this.setExtractAnnotationText(this.getProp(props.getProperty("extractAnnotationText"), this.getExtractAnnotationText()));
        this.setSortByPosition(this.getProp(props.getProperty("sortByPosition"), this.getSortByPosition()));
        this.setUseNonSequentialParser(this.getProp(props.getProperty("useNonSequentialParser"), this.getUseNonSequentialParser()));
        this.setExtractAcroFormContent(this.getProp(props.getProperty("extractAcroFormContent"), this.getExtractAcroFormContent()));
    }

    public void setExtractAcroFormContent(boolean extractAcroFormContent) {
        this.extractAcroFormContent = extractAcroFormContent;
    }

    public boolean getExtractAcroFormContent() {
        return this.extractAcroFormContent;
    }

    public boolean getEnableAutoSpace() {
        return this.enableAutoSpace;
    }

    public void setEnableAutoSpace(boolean enableAutoSpace) {
        this.enableAutoSpace = enableAutoSpace;
    }

    public boolean getSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    public void setSuppressDuplicateOverlappingText(boolean suppressDuplicateOverlappingText) {
        this.suppressDuplicateOverlappingText = suppressDuplicateOverlappingText;
    }

    public boolean getExtractAnnotationText() {
        return this.extractAnnotationText;
    }

    public void setExtractAnnotationText(boolean extractAnnotationText) {
        this.extractAnnotationText = extractAnnotationText;
    }

    public boolean getSortByPosition() {
        return this.sortByPosition;
    }

    public void setSortByPosition(boolean sortByPosition) {
        this.sortByPosition = sortByPosition;
    }

    public boolean getUseNonSequentialParser() {
        return this.useNonSequentialParser;
    }

    public void setUseNonSequentialParser(boolean useNonSequentialParser) {
        this.useNonSequentialParser = useNonSequentialParser;
    }

    private boolean getProp(String p, boolean defaultMissing) {
        if (p == null) {
            return defaultMissing;
        }
        if (p.toLowerCase().equals("true")) {
            return true;
        }
        if (p.toLowerCase().equals("false")) {
            return false;
        }
        return defaultMissing;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enableAutoSpace ? 1231 : 1237);
        result = 31 * result + (this.extractAcroFormContent ? 1231 : 1237);
        result = 31 * result + (this.extractAnnotationText ? 1231 : 1237);
        result = 31 * result + (this.sortByPosition ? 1231 : 1237);
        result = 31 * result + (this.suppressDuplicateOverlappingText ? 1231 : 1237);
        result = 31 * result + (this.useNonSequentialParser ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PDFParserConfig other = (PDFParserConfig)obj;
        if (this.enableAutoSpace != other.enableAutoSpace) {
            return false;
        }
        if (this.extractAcroFormContent != other.extractAcroFormContent) {
            return false;
        }
        if (this.extractAnnotationText != other.extractAnnotationText) {
            return false;
        }
        if (this.sortByPosition != other.sortByPosition) {
            return false;
        }
        if (this.suppressDuplicateOverlappingText != other.suppressDuplicateOverlappingText) {
            return false;
        }
        return this.useNonSequentialParser == other.useNonSequentialParser;
    }

    public String toString() {
        return "PDFParserConfig [enableAutoSpace=" + this.enableAutoSpace + ", suppressDuplicateOverlappingText=" + this.suppressDuplicateOverlappingText + ", extractAnnotationText=" + this.extractAnnotationText + ", sortByPosition=" + this.sortByPosition + ", useNonSequentialParser=" + this.useNonSequentialParser + ", extractAcroFormContent=" + this.extractAcroFormContent + "]";
    }
}

